/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.mapred.ClusterWithLinuxTaskController;
import org.apache.hadoop.mapred.LinuxTaskController;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskTracker;

public class TestLinuxTaskController
extends TestCase {
    private static int INVALID_TASKCONTROLLER_PERMISSIONS = 22;
    private static File testDir = new File(System.getProperty("test.build.data", "/tmp"), TestLinuxTaskController.class.getName());
    private static String taskControllerPath = System.getProperty("taskcontroller-path");

    protected void setUp() throws Exception {
        testDir.mkdirs();
    }

    protected void tearDown() throws Exception {
        FileUtil.fullyDelete((File)testDir);
    }

    private void validateTaskControllerSetup(TaskController controller, boolean shouldFail) throws IOException {
        if (shouldFail) {
            IOException th = null;
            try {
                controller.setup(new LocalDirAllocator("mapred.local.dir"), new TaskTracker.LocalStorage(controller.getConf().getStrings("mapred.local.dir")));
            }
            catch (IOException ie) {
                th = ie;
            }
            TestLinuxTaskController.assertNotNull((String)"No exception during setup", (Object)th);
            TestLinuxTaskController.assertTrue((String)("Exception message does not contain exit code" + INVALID_TASKCONTROLLER_PERMISSIONS), (boolean)th.getMessage().contains("with exit code " + INVALID_TASKCONTROLLER_PERMISSIONS));
        } else {
            controller.setup(new LocalDirAllocator("mapred.local.dir"), new TaskTracker.LocalStorage(controller.getConf().getStrings("mapred.local.dir")));
        }
    }

    public void testTaskControllerGroup() throws Exception {
        if (!ClusterWithLinuxTaskController.isTaskExecPathPassed()) {
            return;
        }
        ClusterWithLinuxTaskController.getTaskControllerConfFile(taskControllerPath).delete();
        Configuration conf = new Configuration();
        File mapredLocal = new File(testDir, "mapred/local");
        mapredLocal.mkdirs();
        conf.set("mapred.local.dir", mapredLocal.toString());
        MyLinuxTaskController controller = new MyLinuxTaskController();
        controller.setConf(conf);
        this.validateTaskControllerSetup((TaskController)controller, true);
        conf.set(ClusterWithLinuxTaskController.TT_GROUP, "invalid");
        ClusterWithLinuxTaskController.createTaskControllerConf(taskControllerPath, conf);
        this.validateTaskControllerSetup((TaskController)controller, true);
        conf.set(ClusterWithLinuxTaskController.TT_GROUP, ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        ClusterWithLinuxTaskController.createTaskControllerConf(taskControllerPath, conf);
        this.validateTaskControllerSetup((TaskController)controller, false);
    }

    static /* synthetic */ String access$000() {
        return taskControllerPath;
    }

    public static class MyLinuxTaskController
    extends LinuxTaskController {
        String taskControllerExePath = TestLinuxTaskController.access$000() + "/task-controller";
    }
}

