/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TestJvmManager;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTaskEnvironment {
    private static File TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestJvmManager.class.getSimpleName());
    private static int MAP_SLOTS = 1;
    private static int REDUCE_SLOTS = 1;
    private TaskTracker tt = new TaskTracker();
    private JvmManager jvmManager;
    private JobConf ttConf = new JobConf();

    @Before
    public void setUp() {
        TEST_DIR.mkdirs();
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    public TestTaskEnvironment() throws Exception {
        this.ttConf.setLong("mapred.tasktracker.tasks.sleeptime-before-sigkill", 2000L);
        this.tt.setConf(this.ttConf);
        this.tt.setMaxMapSlots(MAP_SLOTS);
        this.tt.setMaxReduceSlots(REDUCE_SLOTS);
        this.tt.setTaskController((TaskController)new DefaultTaskController());
        this.jvmManager = new JvmManager(this.tt);
        this.tt.setJvmManagerInstance(this.jvmManager);
        this.tt.setUserLogManager(new UserLogManager((Configuration)this.ttConf));
    }

    private File writeScript(String fileName, String cmd, File pidFile) throws IOException {
        File script = new File(TEST_DIR, fileName);
        FileOutputStream out = new FileOutputStream(script);
        out.write(("echo $$ >" + pidFile.toString() + ";").getBytes());
        out.write("trap '' 15\n".getBytes());
        out.write(cmd.getBytes());
        out.close();
        script.setExecutable(true);
        return script;
    }

    @Test
    public void testTaskEnv() throws Throwable {
        this.ttConf.set("mapreduce.admin.user.shell", "/bin/testshell");
        this.ttConf.set("mapreduce.admin.user.env", "key1=value1,key2=value2");
        this.ttConf.set("mapred.child.env", "ROOT=$HOME");
        HashMap env = new HashMap();
        String user = "test";
        JobConf taskConf = new JobConf((Configuration)this.ttConf);
        TaskAttemptID attemptID = new TaskAttemptID("test", 0, true, 0, 0);
        MapTask task = new MapTask(null, attemptID, 0, null, MAP_SLOTS);
        task.setConf((Configuration)taskConf);
        TaskTracker taskTracker = this.tt;
        taskTracker.getClass();
        TaskTracker.TaskInProgress tip = new TaskTracker.TaskInProgress(taskTracker, (Task)task, taskConf);
        TaskTracker.RunningJob rjob = new TaskTracker.RunningJob(attemptID.getJobID());
        DefaultTaskController taskController = new DefaultTaskController();
        taskController.setConf((Configuration)this.ttConf);
        rjob.distCacheMgr = new TrackerDistributedCacheManager((Configuration)this.ttConf, (TaskController)taskController).newTaskDistributedCacheManager((JobID)attemptID.getJobID(), (Configuration)taskConf);
        TaskRunner taskRunner = task.createRunner(this.tt, tip, rjob);
        String errorInfo = "Child error";
        String mapredChildEnv = taskRunner.getChildEnv(taskConf);
        taskRunner.updateUserLoginEnv(errorInfo, user, taskConf, env);
        taskRunner.setEnvFromInputString(errorInfo, env, mapredChildEnv);
        Vector<String> vargs = new Vector<String>(1);
        File pidFile = new File(TEST_DIR, "pid");
        vargs.add(this.writeScript("ENV", "/bin/env ", pidFile).getAbsolutePath());
        File workDir = new File(TEST_DIR, "work");
        workDir.mkdir();
        File stdout = new File(TEST_DIR, "stdout");
        File stderr = new File(TEST_DIR, "stderr");
        HashMap jvmenvmap = env;
        String javaOpts = taskRunner.getChildJavaOpts(this.ttConf, "mapred.map.child.java.opts");
        Assert.assertTrue((boolean)jvmenvmap.containsKey("SHELL"));
        Assert.assertTrue((boolean)jvmenvmap.containsValue("/bin/testshell"));
        Assert.assertTrue((boolean)jvmenvmap.containsKey("key2"));
        Assert.assertTrue((boolean)jvmenvmap.containsValue("value2"));
        Assert.assertTrue((String)javaOpts, (boolean)javaOpts.contains("Xmx"));
        Assert.assertTrue((String)javaOpts, (boolean)javaOpts.contains("IPv4"));
        String root = (String)jvmenvmap.get("ROOT");
        Assert.assertTrue((String)root, (boolean)root.contentEquals(System.getenv("HOME")));
    }
}

