/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskOutputSize {
    private static Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"), "test");

    @After
    public void tearDown() throws Exception {
        FileUtil.fullyDelete((File)new File(rootDir.toString()));
    }

    @Test
    public void testTaskOutputSize() throws Exception {
        TaskStatus ts;
        MiniMRCluster mr = new MiniMRCluster(1, "file:///", 1);
        Path inDir = new Path(rootDir, "input");
        Path outDir = new Path(rootDir, "output");
        Job job = MapReduceTestUtil.createJob((Configuration)mr.createJobConf(), inDir, outDir, 1, 1);
        job.waitForCompletion(true);
        Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
        for (TaskCompletionEvent tce : job.getTaskCompletionEvents(0)) {
            ts = jt.getTaskStatus(tce.getTaskAttemptId());
            if (tce.isMapTask()) {
                Assert.assertTrue((String)("map output size is not found for " + tce.getTaskAttemptId()), (ts.getOutputSize() > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((String)("task output size not expected for " + tce.getTaskAttemptId()), (long)-1L, (long)ts.getOutputSize());
        }
        job = MapReduceTestUtil.createJob((Configuration)mr.createJobConf(), inDir, outDir, 1, 0);
        job.waitForCompletion(true);
        Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        for (TaskCompletionEvent tce : job.getTaskCompletionEvents(0)) {
            ts = jt.getTaskStatus(tce.getTaskAttemptId());
            Assert.assertEquals((String)("task output size not expected for " + tce.getTaskAttemptId()), (long)-1L, (long)ts.getOutputSize());
        }
        job = MapReduceTestUtil.createFailJob((Configuration)mr.createJobConf(), outDir, inDir);
        job.waitForCompletion(true);
        Assert.assertFalse((String)"Job not failed", (boolean)job.isSuccessful());
        for (TaskCompletionEvent tce : job.getTaskCompletionEvents(0)) {
            ts = jt.getTaskStatus(tce.getTaskAttemptId());
            Assert.assertEquals((String)("task output size not expected for " + tce.getTaskAttemptId()), (long)-1L, (long)ts.getOutputSize());
        }
    }
}

