/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class TestChild
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path inDir = new Path(TEST_ROOT_DIR, "./wc/input");
    private final Path outDir = new Path(TEST_ROOT_DIR, "./wc/output");
    private static final String OLD_CONFIGS = "test.old.configs";
    private static final String TASK_OPTS_VAL = "-Xmx200m";
    private static final String MAP_OPTS_VAL = "-Xmx200m";
    private static final String REDUCE_OPTS_VAL = "-Xmx300m";

    public TestChild() throws IOException {
        super(2, 4, 2, 2);
    }

    private Job submitAndValidateJob(JobConf conf, int numMaps, int numReds, boolean oldConfigs) throws IOException, InterruptedException, ClassNotFoundException {
        conf.setBoolean(OLD_CONFIGS, oldConfigs);
        if (oldConfigs) {
            conf.set("mapred.child.java.opts", "-Xmx200m");
        } else {
            conf.set("mapred.map.child.java.opts", "-Xmx200m");
            conf.set("mapred.reduce.child.java.opts", REDUCE_OPTS_VAL);
        }
        Job job = MapReduceTestUtil.createJob((Configuration)conf, this.inDir, this.outDir, numMaps, numReds);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        TestChild.assertNull((String)"Job.jobClient already initialized before job-submission!", (Object)job.getJobClient());
        job.waitForCompletion(true);
        TestChild.assertTrue((boolean)job.isSuccessful());
        TestChild.assertNotNull((String)"Job.jobClient not initialized after job-completion!", (Object)job.getJobClient());
        FileSystem fs = FileSystem.get((Configuration)conf);
        TestChild.assertTrue((String)"Job output directory doesn't exit!", (boolean)fs.exists(this.outDir));
        FileStatus[] list = fs.listStatus(this.outDir, (PathFilter)new OutputFilter());
        int numPartFiles = numReds == 0 ? numMaps : numReds;
        TestChild.assertTrue((String)("Number of part-files is " + list.length + " and not " + numPartFiles), (list.length == numPartFiles ? 1 : 0) != 0);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChild() throws Exception {
        try {
            this.submitAndValidateJob(this.createJobConf(), 1, 1, true);
            this.submitAndValidateJob(this.createJobConf(), 1, 1, false);
        }
        finally {
            this.tearDown();
        }
    }

    private static class OutputFilter
    implements PathFilter {
        private OutputFilter() {
        }

        public boolean accept(Path path) {
            return !path.getName().startsWith("_");
        }
    }

    static class MyReducer
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        MyReducer() {
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            boolean oldConfigs = conf.getBoolean(TestChild.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = conf.get("mapred.child.java.opts");
                Assert.assertNotNull((String)"mapred.child.java.opts is null!", (Object)javaOpts);
                Assert.assertEquals((String)("mapred.child.java.opts has value of: " + javaOpts), (String)javaOpts, (String)"-Xmx200m");
            } else {
                String reduceJavaOpts = conf.get("mapred.reduce.child.java.opts");
                Assert.assertNotNull((String)"mapred.reduce.child.java.opts is null!", (Object)reduceJavaOpts);
                Assert.assertEquals((String)("mapred.reduce.child.java.opts has value of: " + reduceJavaOpts), (String)reduceJavaOpts, (String)TestChild.REDUCE_OPTS_VAL);
            }
        }
    }

    static class MyMapper
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        MyMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            boolean oldConfigs = conf.getBoolean(TestChild.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = conf.get("mapred.child.java.opts");
                Assert.assertNotNull((String)"mapred.child.java.opts is null!", (Object)javaOpts);
                Assert.assertEquals((String)("mapred.child.java.opts has value of: " + javaOpts), (String)javaOpts, (String)"-Xmx200m");
            } else {
                String mapJavaOpts = conf.get("mapred.map.child.java.opts");
                Assert.assertNotNull((String)"mapred.map.child.java.opts is null!", (Object)mapJavaOpts);
                Assert.assertEquals((String)("mapred.map.child.java.opts has value of: " + mapJavaOpts), (String)mapJavaOpts, (String)"-Xmx200m");
            }
        }
    }
}

