/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.junit.Assert;
import org.junit.Test;

public class TestInputSampler {
    @Test
    public void testSplitSampler() throws Exception {
        int TOT_SPLITS = 15;
        int NUM_SPLITS = 5;
        int STEP_SAMPLE = 5;
        int NUM_SAMPLES = 25;
        InputSampler.SplitSampler sampler = new InputSampler.SplitSampler(25, 5);
        int[] inits = new int[15];
        for (int i = 0; i < 15; ++i) {
            inits[i] = i * 5;
        }
        Job ignored = new Job();
        Object[] samples = sampler.getSample((InputFormat)new TestInputSamplerIF(100000, 15, inits), ignored);
        Assert.assertEquals((long)25L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 25; ++i) {
            Assert.assertEquals((long)i, (long)((IntWritable)samples[i]).get());
        }
    }

    @Test
    public void testIntervalSampler() throws Exception {
        int TOT_SPLITS = 16;
        int PER_SPLIT_SAMPLE = 4;
        int NUM_SAMPLES = 64;
        double FREQ = 0.0625;
        InputSampler.IntervalSampler sampler = new InputSampler.IntervalSampler(0.0625, 64);
        int[] inits = new int[16];
        for (int i = 0; i < 16; ++i) {
            inits[i] = i;
        }
        Job ignored = Job.getInstance();
        Object[] samples = sampler.getSample((InputFormat)new TestInputSamplerIF(64, 16, inits), ignored);
        Assert.assertEquals((long)64L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((long)i, (long)((IntWritable)samples[i]).get());
        }
    }

    static class TestInputSamplerIF
    extends InputFormat<IntWritable, NullWritable> {
        final int maxDepth;
        final ArrayList<InputSplit> splits = new ArrayList();

        TestInputSamplerIF(int maxDepth, int numSplits, int ... splitInit) {
            this.maxDepth = maxDepth;
            assert (splitInit.length == numSplits);
            for (int i = 0; i < numSplits; ++i) {
                this.splits.add(new SequentialSplit(splitInit[i]));
            }
        }

        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            return this.splits;
        }

        public RecordReader<IntWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return new RecordReader<IntWritable, NullWritable>(){
                private int maxVal;
                private final IntWritable i = new IntWritable();

                public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                    this.i.set(((SequentialSplit)split).getInit() - 1);
                    this.maxVal = this.i.get() + TestInputSamplerIF.this.maxDepth + 1;
                }

                public boolean nextKeyValue() {
                    this.i.set(this.i.get() + 1);
                    return this.i.get() < this.maxVal;
                }

                public IntWritable getCurrentKey() {
                    return this.i;
                }

                public NullWritable getCurrentValue() {
                    return NullWritable.get();
                }

                public float getProgress() {
                    return 1.0f;
                }

                public void close() {
                }
            };
        }
    }

    static class SequentialSplit
    extends InputSplit {
        private int i;

        SequentialSplit(int i) {
            this.i = i;
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }

        public int getInit() {
            return this.i;
        }
    }
}

