/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token.delegation;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegationTokenAuthMethod {
    private MiniMRCluster cluster;
    private JobConf config;

    @Before
    public void setup() throws Exception {
        this.config = new JobConf();
        this.cluster = new MiniMRCluster(0, 0, 1, "file:///", 1, null, null, null, this.config);
    }

    private Token<DelegationTokenIdentifier> generateDelegationToken(String owner, String renewer) {
        DelegationTokenSecretManager dtSecretManager = this.cluster.getJobTrackerRunner().getJobTracker().getDelegationTokenSecretManager();
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(owner), new Text(renewer), null);
        return new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
    }

    @Test
    public void testDelegationToken() throws Exception {
        final JobTracker jt = this.cluster.getJobTrackerRunner().getJobTracker();
        final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        this.config.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.config);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    Token token = jt.getDelegationToken(new Text(ugi.getShortUserName()));
                    jt.renewDelegationToken(token);
                    jt.cancelDelegationToken(token);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                return null;
            }
        });
    }

    @Test
    public void testGetDelegationTokenWithoutKerberos() throws Exception {
        final JobTracker jt = this.cluster.getJobTrackerRunner().getJobTracker();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN);
        this.config.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.config);
        Assert.assertTrue((boolean)UserGroupInformation.isSecurityEnabled());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    Token token = jt.getDelegationToken(new Text("arenewer"));
                    Assert.assertTrue((token != null ? 1 : 0) != 0);
                    Assert.fail((String)"Delegation token should not be issued without Kerberos authentication");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Test
    public void testRenewDelegationTokenWithoutKerberos() throws Exception {
        final JobTracker jt = this.cluster.getJobTrackerRunner().getJobTracker();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN);
        this.config.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.config);
        Assert.assertTrue((boolean)UserGroupInformation.isSecurityEnabled());
        final Token<DelegationTokenIdentifier> token = this.generateDelegationToken("owner", ugi.getShortUserName());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    jt.renewDelegationToken(token);
                    Assert.fail((String)"Delegation token should not be renewed without Kerberos authentication");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

