/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TestJobSplitWriter {
    static final String TEST_ROOT = System.getProperty("test.build.data", "/tmp");
    static final Path TEST_DIR = new Path(TEST_ROOT, TestJobSplitWriter.class.getSimpleName());

    @AfterClass
    public static void cleanup() throws IOException {
        FileSystem fs = FileSystem.getLocal((Configuration)new Configuration()).getRaw();
        fs.delete(TEST_DIR, true);
    }

    @Test
    public void testSplitLocationLimit() throws IOException, InterruptedException {
        int SPLITS = 5;
        int MAX_LOC = 10;
        Path outdir = new Path(TEST_DIR, "testSplitLocationLimit");
        final String[] locs = TestJobSplitWriter.getLoc(15);
        Configuration conf = new Configuration();
        FileSystem rfs = FileSystem.getLocal((Configuration)conf).getRaw();
        NewSplit split = new NewSplit(){

            public String[] getLocations() {
                return locs;
            }
        };
        List<1> splits = Collections.nCopies(5, split);
        conf.setInt("mapreduce.job.max.split.locations", 10);
        JobSplitWriter.createSplitFiles((Path)outdir, (Configuration)conf, (FileSystem)FileSystem.getLocal((Configuration)conf).getRaw(), splits);
        TestJobSplitWriter.checkMeta(10, SplitMetaInfoReader.readSplitMetaInfo(null, (FileSystem)rfs, (Configuration)conf, (Path)outdir), Arrays.copyOf(locs, 10));
        conf.setInt("mapreduce.job.max.split.locations", 5);
        try {
            SplitMetaInfoReader.readSplitMetaInfo(null, (FileSystem)rfs, (Configuration)conf, (Path)outdir);
            Assert.fail((String)"Reader failed to detect location limit");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Test
    public void testSplitLocationLimitOldApi() throws IOException {
        int SPLITS = 5;
        int MAX_LOC = 10;
        Path outdir = new Path(TEST_DIR, "testSplitLocationLimitOldApi");
        final String[] locs = TestJobSplitWriter.getLoc(15);
        Configuration conf = new Configuration();
        FileSystem rfs = FileSystem.getLocal((Configuration)conf).getRaw();
        OldSplit split = new OldSplit(){

            public String[] getLocations() {
                return locs;
            }
        };
        Object[] splits = new org.apache.hadoop.mapred.InputSplit[5];
        Arrays.fill(splits, split);
        conf.setInt("mapreduce.job.max.split.locations", 10);
        JobSplitWriter.createSplitFiles((Path)outdir, (Configuration)conf, (FileSystem)FileSystem.getLocal((Configuration)conf).getRaw(), (org.apache.hadoop.mapred.InputSplit[])splits);
        TestJobSplitWriter.checkMeta(10, SplitMetaInfoReader.readSplitMetaInfo(null, (FileSystem)rfs, (Configuration)conf, (Path)outdir), Arrays.copyOf(locs, 10));
        conf.setInt("mapreduce.job.max.split.locations", 5);
        try {
            SplitMetaInfoReader.readSplitMetaInfo(null, (FileSystem)rfs, (Configuration)conf, (Path)outdir);
            Assert.fail((String)"Reader failed to detect location limit");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static void checkMeta(int MAX_LOC, JobSplit.TaskSplitMetaInfo[] metaSplits, String[] chk_locs) {
        for (JobSplit.TaskSplitMetaInfo meta : metaSplits) {
            Object[] meta_locs = meta.getLocations();
            Assert.assertEquals((long)MAX_LOC, (long)meta_locs.length);
            Assert.assertArrayEquals((Object[])chk_locs, (Object[])meta_locs);
        }
    }

    private static String[] getLoc(int locations) {
        String[] ret = new String[locations];
        for (int i = 0; i < locations; ++i) {
            ret[i] = "LOC" + i;
        }
        return ret;
    }

    static abstract class OldSplit
    implements org.apache.hadoop.mapred.InputSplit {
        OldSplit() {
        }

        public long getLength() {
            return 42L;
        }

        public void readFields(DataInput in) throws IOException {
        }

        public void write(DataOutput in) throws IOException {
        }
    }

    static abstract class NewSplit
    extends InputSplit
    implements Writable {
        NewSplit() {
        }

        public long getLength() {
            return 42L;
        }

        public void readFields(DataInput in) throws IOException {
        }

        public void write(DataOutput in) throws IOException {
        }
    }
}

