/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.util.BitSet;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.RecBuffer;
import org.apache.hadoop.record.RecInt;

public class TestRecordWritable
extends TestCase {
    private static final Log LOG = FileInputFormat.LOG;
    private static int MAX_LENGTH = 10000;
    private static Configuration conf = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        JobConf job = new JobConf(conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "test.seq");
        int seed = new Random().nextInt();
        Random random = new Random(seed);
        fs.delete(dir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{dir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            RecInt key;
            SequenceFile.Writer writer = new SequenceFile.Writer((FileSystem)fs, conf, file, RecInt.class, RecBuffer.class);
            try {
                for (int i = 0; i < length; ++i) {
                    key = new RecInt();
                    key.setData(i);
                    byte[] data = new byte[random.nextInt(10)];
                    random.nextBytes(data);
                    RecBuffer value = new RecBuffer();
                    value.setData(new Buffer(data));
                    writer.append((Writable)key, (Writable)value);
                }
            }
            finally {
                writer.close();
            }
            SequenceFileInputFormat format = new SequenceFileInputFormat();
            key = new RecInt();
            RecBuffer value = new RecBuffer();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 100) + 1;
                InputSplit[] splits = format.getSplits(job, numSplits);
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    RecordReader reader = format.getRecordReader(splits[j], job, Reporter.NULL);
                    try {
                        int count = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            TestRecordWritable.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(key.getData()));
                            bits.set(key.getData());
                            ++count;
                        }
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                TestRecordWritable.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestRecordWritable().testFormat();
    }
}

