/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class StubContext {
    private StubStatusReporter reporter = new StubStatusReporter();
    private RecordReader<Text, FileStatus> reader;
    private StubInMemoryWriter writer = new StubInMemoryWriter();
    private Mapper.Context mapperContext;

    public StubContext(Configuration conf, RecordReader<Text, FileStatus> reader, int taskId) throws IOException, InterruptedException {
        Mapper mapper;
        Mapper mapper2 = mapper = new Mapper();
        mapper2.getClass();
        Mapper.Context contextImpl = new Mapper.Context(mapper2, conf, StubContext.getTaskAttemptID(taskId), reader, (RecordWriter)this.writer, null, (StatusReporter)this.reporter, null);
        this.reader = reader;
        this.mapperContext = contextImpl;
    }

    public Mapper.Context getContext() {
        return this.mapperContext;
    }

    public StatusReporter getReporter() {
        return this.reporter;
    }

    public RecordReader<Text, FileStatus> getReader() {
        return this.reader;
    }

    public StubInMemoryWriter getWriter() {
        return this.writer;
    }

    public static TaskAttemptID getTaskAttemptID(int taskId) {
        return new TaskAttemptID("", 0, true, taskId, 0);
    }

    public static class StubInMemoryWriter
    extends RecordWriter<Text, Text> {
        List<Text> keys = new ArrayList<Text>();
        List<Text> values = new ArrayList<Text>();

        public void write(Text key, Text value) throws IOException, InterruptedException {
            this.keys.add(key);
            this.values.add(value);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public List<Text> keys() {
            return this.keys;
        }

        public List<Text> values() {
            return this.values;
        }
    }

    public static class StubStatusReporter
    extends StatusReporter {
        private Counters counters = new Counters();

        public Counter getCounter(Enum<?> name) {
            return this.counters.findCounter(name);
        }

        public Counter getCounter(String group, String name) {
            return this.counters.findCounter(group, name);
        }

        public void progress() {
        }

        public float getProgress() {
            return 0.0f;
        }

        public void setStatus(String status) {
        }
    }
}

