/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.util.ProcessTree;
import org.apache.hadoop.util.ProcfsBasedProcessTree;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class TestProcfsBasedProcessTree
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestProcfsBasedProcessTree.class);
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
    private Shell.ShellCommandExecutor shexec = null;
    private String pidFile;
    private String lowestDescendant;
    private String shellScript;
    private static final int N = 6;

    private String getRogueTaskPID() {
        File f = new File(this.pidFile);
        while (!f.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return UtilsForTests.getPidFromPidFile(this.pidFile);
    }

    public void testProcessTree() {
        try {
            if (!ProcfsBasedProcessTree.isAvailable()) {
                System.out.println("ProcfsBasedProcessTree is not available on this system. Not testing");
                return;
            }
        }
        catch (Exception e) {
            LOG.info((Object)StringUtils.stringifyException((Throwable)e));
            return;
        }
        Random rm = new Random();
        File tempFile = new File(TEST_ROOT_DIR, this.getName() + "_shellScript_" + rm.nextInt() + ".sh");
        tempFile.deleteOnExit();
        this.shellScript = TEST_ROOT_DIR + File.separator + tempFile.getName();
        tempFile = new File(TEST_ROOT_DIR, this.getName() + "_pidFile_" + rm.nextInt() + ".pid");
        tempFile.deleteOnExit();
        this.pidFile = TEST_ROOT_DIR + File.separator + tempFile.getName();
        this.lowestDescendant = TEST_ROOT_DIR + File.separator + "lowestDescendantPidFile";
        try {
            FileWriter fWriter = new FileWriter(this.shellScript);
            fWriter.write("# rogue task\nsleep 1\necho hello\nif [ $1 -ne 0 ]\nthen\n sh " + this.shellScript + " $(($1-1))\n" + "else\n" + " echo $$ > " + this.lowestDescendant + "\n" + " while true\n do\n" + "  sleep 5\n" + " done\n" + "fi");
            fWriter.close();
        }
        catch (IOException ioe) {
            LOG.info((Object)("Error: " + ioe));
            return;
        }
        RogueTaskThread t = new RogueTaskThread();
        t.start();
        String pid = this.getRogueTaskPID();
        LOG.info((Object)("Root process pid: " + pid));
        ProcfsBasedProcessTree p = new ProcfsBasedProcessTree(pid, ProcessTree.isSetsidAvailable);
        p = p.getProcessTree();
        LOG.info((Object)("ProcessTree: " + p.toString()));
        File leaf = new File(this.lowestDescendant);
        while (!leaf.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        p = p.getProcessTree();
        LOG.info((Object)("ProcessTree: " + p.toString()));
        String processTreeDump = p.getProcessTreeDump();
        if (ProcessTree.isSetsidAvailable) {
            ProcessTree.killProcessGroup((String)pid, (ProcessTree.Signal)ProcessTree.Signal.KILL);
        } else {
            ProcessTree.killProcess((String)pid, (ProcessTree.Signal)ProcessTree.Signal.KILL);
        }
        if (ProcessTree.isSetsidAvailable) {
            TestProcfsBasedProcessTree.assertEquals((boolean)false, (boolean)p.isAnyProcessInTreeAlive());
        } else {
            TestProcfsBasedProcessTree.assertEquals((boolean)false, (boolean)p.isAlive());
        }
        LOG.info((Object)("Process-tree dump follows: \n" + processTreeDump));
        TestProcfsBasedProcessTree.assertTrue((String)"Process-tree dump doesn't start with a proper header", (boolean)processTreeDump.startsWith("\t|- PID PPID PGRPID SESSID CMD_NAME USER_MODE_TIME(MILLIS) SYSTEM_TIME(MILLIS) VMEM_USAGE(BYTES) RSSMEM_USAGE(PAGES) FULL_CMD_LINE\n"));
        for (int i = 6; i >= 0; --i) {
            String cmdLineDump = "\\|- [0-9]+ [0-9]+ [0-9]+ [0-9]+ \\(sh\\) [0-9]+ [0-9]+ [0-9]+ [0-9]+ sh " + this.shellScript + " " + i;
            Pattern pat = Pattern.compile(cmdLineDump);
            Matcher mat = pat.matcher(processTreeDump);
            TestProcfsBasedProcessTree.assertTrue((String)("Process-tree dump doesn't contain the cmdLineDump of " + i + "th process!"), (boolean)mat.find());
        }
        try {
            t.join(2000L);
            LOG.info((Object)"RogueTaskThread successfully joined.");
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted while joining RogueTaskThread.");
        }
        p = p.getProcessTree();
        TestProcfsBasedProcessTree.assertFalse((String)"ProcessTree must have been gone", (boolean)p.isAlive());
        TestProcfsBasedProcessTree.assertTrue((String)("Cumulative vmem for the gone-process is " + p.getCumulativeVmem() + " . It should be zero."), (p.getCumulativeVmem() == 0L ? 1 : 0) != 0);
        TestProcfsBasedProcessTree.assertTrue((boolean)p.toString().equals("[ ]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCpuAndMemoryForProcessTree() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "1000", "200"}), new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200", "2000", "400"}), new ProcessStatInfo(new String[]{"300", "proc3", "200", "100", "100", "300000", "300", "3000", "600"}), new ProcessStatInfo(new String[]{"400", "proc4", "1", "400", "400", "400000", "400", "4000", "800"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos);
            ProcfsBasedProcessTree processTree = new ProcfsBasedProcessTree("100", procfsRootDir.getAbsolutePath());
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative virtual memory does not match", (long)600000L, (long)processTree.getCumulativeVmem());
            long cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 600L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative rss memory does not match", (long)cumuRssMem, (long)processTree.getCumulativeRssmem());
            long cumuCpuTime = ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS > 0L ? 7200L * ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS : 0L;
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative cpu time does not match", (long)cumuCpuTime, (long)processTree.getCumulativeCpuTime());
            procInfos[0] = new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "2000", "300"});
            procInfos[1] = new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200", "3000", "500"});
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos);
            processTree.getProcessTree();
            cumuCpuTime = ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS > 0L ? 9400L * ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS : 0L;
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative cpu time does not match", (long)cumuCpuTime, (long)processTree.getCumulativeCpuTime());
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemForOlderProcesses() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100"}), new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200"}), new ProcessStatInfo(new String[]{"300", "proc3", "1", "300", "300", "300000", "300"}), new ProcessStatInfo(new String[]{"400", "proc4", "100", "100", "100", "400000", "400"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos);
            ProcfsBasedProcessTree processTree = new ProcfsBasedProcessTree("100", procfsRootDir.getAbsolutePath());
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative memory does not match", (long)700000L, (long)processTree.getCumulativeVmem());
            String[] newPids = new String[]{"500"};
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, newPids);
            ProcessStatInfo[] newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"500", "proc5", "100", "100", "100", "500000", "500"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, newPids, newProcInfos);
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative vmem does not include new process", (long)1200000L, (long)processTree.getCumulativeVmem());
            long cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 1200L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative rssmem does not include new process", (long)cumuRssMem, (long)processTree.getCumulativeRssmem());
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative vmem shouldn't have included new process", (long)700000L, (long)processTree.getCumulativeVmem(1));
            cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 700L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative rssmem shouldn't have included new process", (long)cumuRssMem, (long)processTree.getCumulativeRssmem(1));
            newPids = new String[]{"600"};
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, newPids);
            newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"600", "proc6", "100", "100", "100", "600000", "600"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, newPids, newProcInfos);
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative vmem shouldn't have included new processes", (long)700000L, (long)processTree.getCumulativeVmem(2));
            cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 700L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative rssmem shouldn't have included new processes", (long)cumuRssMem, (long)processTree.getCumulativeRssmem(2));
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative vmem shouldn't have included new processes", (long)1200000L, (long)processTree.getCumulativeVmem(1));
            cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 1200L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative rssmem shouldn't have included new processes", (long)cumuRssMem, (long)processTree.getCumulativeRssmem(1));
            TestProcfsBasedProcessTree.assertEquals((String)"Getting non-zero vmem for processes older than 3 iterations", (long)0L, (long)processTree.getCumulativeVmem(3));
            TestProcfsBasedProcessTree.assertEquals((String)"Getting non-zero rssmem for processes older than 3 iterations", (long)0L, (long)processTree.getCumulativeRssmem(3));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProcessTreeDump() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400", "500", "600"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            int numProcesses = pids.length;
            ProcessStatInfo[] procInfos = new ProcessStatInfo[numProcesses];
            procInfos[0] = new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "1000", "200"});
            procInfos[1] = new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200", "2000", "400"});
            procInfos[2] = new ProcessStatInfo(new String[]{"300", "proc3", "200", "100", "100", "300000", "300", "3000", "600"});
            procInfos[3] = new ProcessStatInfo(new String[]{"400", "proc4", "200", "100", "100", "400000", "400", "4000", "800"});
            procInfos[4] = new ProcessStatInfo(new String[]{"500", "proc5", "400", "100", "100", "400000", "400", "4000", "800"});
            procInfos[5] = new ProcessStatInfo(new String[]{"600", "proc6", "1", "1", "1", "400000", "400", "4000", "800"});
            String[] cmdLines = new String[numProcesses];
            cmdLines[0] = "proc1 arg1 arg2";
            cmdLines[1] = "proc2 arg3 arg4";
            cmdLines[2] = "proc3 arg5 arg6";
            cmdLines[3] = "proc4 arg7 arg8";
            cmdLines[4] = "proc5 arg9 arg10";
            cmdLines[5] = "proc6 arg11 arg12";
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos);
            TestProcfsBasedProcessTree.writeCmdLineFiles(procfsRootDir, pids, cmdLines);
            ProcfsBasedProcessTree processTree = new ProcfsBasedProcessTree("100", procfsRootDir.getAbsolutePath());
            processTree.getProcessTree();
            String processTreeDump = processTree.getProcessTreeDump();
            LOG.info((Object)("Process-tree dump follows: \n" + processTreeDump));
            TestProcfsBasedProcessTree.assertTrue((String)"Process-tree dump doesn't start with a proper header", (boolean)processTreeDump.startsWith("\t|- PID PPID PGRPID SESSID CMD_NAME USER_MODE_TIME(MILLIS) SYSTEM_TIME(MILLIS) VMEM_USAGE(BYTES) RSSMEM_USAGE(PAGES) FULL_CMD_LINE\n"));
            for (int i = 0; i < 5; ++i) {
                ProcessStatInfo p = procInfos[i];
                TestProcfsBasedProcessTree.assertTrue((String)("Process-tree dump doesn't contain the cmdLineDump of process " + p.pid), (boolean)processTreeDump.contains("\t|- " + p.pid + " " + p.ppid + " " + p.pgrpId + " " + p.session + " (" + p.name + ") " + p.utime + " " + p.stime + " " + p.vmem + " " + p.rssmemPage + " " + cmdLines[i]));
            }
            ProcessStatInfo p = procInfos[5];
            TestProcfsBasedProcessTree.assertFalse((String)("Process-tree dump shouldn't contain the cmdLineDump of process " + p.pid), (boolean)processTreeDump.contains("\t|- " + p.pid + " " + p.ppid + " " + p.pgrpId + " " + p.session + " (" + p.name + ") " + p.utime + " " + p.stime + " " + p.vmem + " " + cmdLines[5]));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    public static void setupProcfsRootDir(File procfsRootDir) throws IOException {
        if (procfsRootDir.exists()) {
            TestProcfsBasedProcessTree.assertTrue((boolean)FileUtil.fullyDelete((File)procfsRootDir));
        }
        TestProcfsBasedProcessTree.assertTrue((boolean)procfsRootDir.mkdirs());
    }

    public static void setupPidDirs(File procfsRootDir, String[] pids) throws IOException {
        for (String pid : pids) {
            File pidDir = new File(procfsRootDir, pid);
            pidDir.mkdir();
            if (!pidDir.exists()) {
                throw new IOException("couldn't make process directory under fake procfs");
            }
            LOG.info((Object)"created pid dir");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatFiles(File procfsRootDir, String[] pids, ProcessStatInfo[] procs) throws IOException {
        for (int i = 0; i < pids.length; ++i) {
            File statFile = new File(new File(procfsRootDir, pids[i]), "stat");
            BufferedWriter bw = null;
            try {
                FileWriter fw = new FileWriter(statFile);
                bw = new BufferedWriter(fw);
                bw.write(procs[i].getStatLine());
                LOG.info((Object)("wrote stat file for " + pids[i] + " with contents: " + procs[i].getStatLine()));
                continue;
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCmdLineFiles(File procfsRootDir, String[] pids, String[] cmdLines) throws IOException {
        for (int i = 0; i < pids.length; ++i) {
            File statFile = new File(new File(procfsRootDir, pids[i]), "cmdline");
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(statFile));
                bw.write(cmdLines[i]);
                LOG.info((Object)("wrote command-line file for " + pids[i] + " with contents: " + cmdLines[i]));
                continue;
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    public static class ProcessStatInfo {
        String pid;
        String name;
        String ppid;
        String pgrpId;
        String session;
        String vmem = "0";
        String rssmemPage = "0";
        String utime = "0";
        String stime = "0";

        public ProcessStatInfo(String[] statEntries) {
            this.pid = statEntries[0];
            this.name = statEntries[1];
            this.ppid = statEntries[2];
            this.pgrpId = statEntries[3];
            this.session = statEntries[4];
            this.vmem = statEntries[5];
            if (statEntries.length > 6) {
                this.rssmemPage = statEntries[6];
            }
            if (statEntries.length > 7) {
                this.utime = statEntries[7];
                this.stime = statEntries[8];
            }
        }

        public String getStatLine() {
            return String.format("%s (%s) S %s %s %s 0 0 0 0 0 0 0 %s %s 0 0 0 0 0 0 0 %s %s 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0", this.pid, this.name, this.ppid, this.pgrpId, this.session, this.utime, this.stime, this.vmem, this.rssmemPage);
        }
    }

    private class RogueTaskThread
    extends Thread {
        private RogueTaskThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vector<String> args = new Vector<String>();
                if (ProcessTree.isSetsidAvailable) {
                    args.add("setsid");
                }
                args.add("bash");
                args.add("-c");
                args.add(" echo $$ > " + TestProcfsBasedProcessTree.this.pidFile + "; sh " + TestProcfsBasedProcessTree.this.shellScript + " " + 6 + ";");
                TestProcfsBasedProcessTree.this.shexec = new Shell.ShellCommandExecutor(args.toArray(new String[0]));
                TestProcfsBasedProcessTree.this.shexec.execute();
            }
            catch (Shell.ExitCodeException ee) {
                LOG.info((Object)("Shell Command exit with a non-zero exit code. This is expected as we are killing the subprocesses of the task intentionally. " + (Object)((Object)ee)));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Error executing shell command " + ioe));
            }
            finally {
                LOG.info((Object)("Exit code: " + TestProcfsBasedProcessTree.this.shexec.getExitCode()));
            }
        }
    }
}

