/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.util.ReflectionUtils;

public class TestReflectionUtils
extends TestCase {
    private static Class[] toConstruct = new Class[]{String.class, TestReflectionUtils.class, HashMap.class};
    private Throwable failure = null;

    public void setUp() {
        ReflectionUtils.clearCache();
    }

    public void testCache() throws Exception {
        TestReflectionUtils.assertEquals((int)0, (int)this.cacheSize());
        this.doTestCache();
        TestReflectionUtils.assertEquals((int)toConstruct.length, (int)this.cacheSize());
        ReflectionUtils.clearCache();
        TestReflectionUtils.assertEquals((int)0, (int)this.cacheSize());
    }

    private void doTestCache() {
        for (int i = 0; i < toConstruct.length; ++i) {
            Class cl = toConstruct[i];
            Object x = ReflectionUtils.newInstance((Class)cl, null);
            Object y = ReflectionUtils.newInstance((Class)cl, null);
            TestReflectionUtils.assertEquals((Object)cl, x.getClass());
            TestReflectionUtils.assertEquals((Object)cl, y.getClass());
        }
    }

    public void testThreadSafe() throws Exception {
        int i;
        Thread[] th = new Thread[32];
        for (i = 0; i < th.length; ++i) {
            th[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        TestReflectionUtils.this.doTestCache();
                    }
                    catch (Throwable t) {
                        TestReflectionUtils.this.failure = t;
                    }
                }
            };
            th[i].start();
        }
        for (i = 0; i < th.length; ++i) {
            th[i].join();
        }
        if (this.failure != null) {
            this.failure.printStackTrace();
            TestReflectionUtils.fail((String)this.failure.getMessage());
        }
    }

    private int cacheSize() throws Exception {
        return ReflectionUtils.getCacheSize();
    }

    public void testCantCreate() {
        try {
            ReflectionUtils.newInstance(NoDefaultCtor.class, null);
            TestReflectionUtils.fail((String)"invalid call should fail");
        }
        catch (RuntimeException rte) {
            TestReflectionUtils.assertEquals(NoSuchMethodException.class, rte.getCause().getClass());
        }
    }

    public void testCacheDoesntLeak() throws Exception {
        int iterations = 9999;
        for (int i = 0; i < iterations; ++i) {
            URLClassLoader loader = new URLClassLoader(new URL[0], ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> cl = Class.forName("org.apache.hadoop.util.TestReflectionUtils$LoadedInChild", false, loader);
            Object o = ReflectionUtils.newInstance(cl, null);
            TestReflectionUtils.assertEquals(cl, o.getClass());
        }
        System.gc();
        TestReflectionUtils.assertTrue((String)(this.cacheSize() + " too big"), (this.cacheSize() < iterations ? 1 : 0) != 0);
    }

    public void testSetConf() {
        JobConfigurableOb ob = new JobConfigurableOb();
        ReflectionUtils.setConf((Object)ob, (Configuration)new Configuration());
        TestReflectionUtils.assertFalse((boolean)ob.configured);
        ReflectionUtils.setConf((Object)ob, (Configuration)new JobConf());
        TestReflectionUtils.assertTrue((boolean)ob.configured);
    }

    private static class JobConfigurableOb
    implements JobConfigurable {
        boolean configured;

        private JobConfigurableOb() {
        }

        public void configure(JobConf job) {
            this.configured = true;
        }
    }

    public static class NoDefaultCtor {
        public NoDefaultCtor(int x) {
        }
    }

    private static class LoadedInChild {
        private LoadedInChild() {
        }
    }
}

