/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class AllocateRequestPBImpl
extends ProtoBase<YarnServiceProtos.AllocateRequestProto>
implements AllocateRequest {
    YarnServiceProtos.AllocateRequestProto proto = YarnServiceProtos.AllocateRequestProto.getDefaultInstance();
    YarnServiceProtos.AllocateRequestProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationAttemptId applicationAttemptID = null;
    private List<ResourceRequest> ask = null;
    private List<ContainerId> release = null;

    public AllocateRequestPBImpl() {
        this.builder = YarnServiceProtos.AllocateRequestProto.newBuilder();
    }

    public AllocateRequestPBImpl(YarnServiceProtos.AllocateRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public YarnServiceProtos.AllocateRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationAttemptID != null) {
            this.builder.setApplicationAttemptId(this.convertToProtoFormat(this.applicationAttemptID));
        }
        if (this.ask != null) {
            this.addAsksToProto();
        }
        if (this.release != null) {
            this.addReleasesToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.AllocateRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        YarnServiceProtos.AllocateRequestProtoOrBuilder p;
        YarnServiceProtos.AllocateRequestProtoOrBuilder allocateRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.applicationAttemptID != null) {
            return this.applicationAttemptID;
        }
        if (!p.hasApplicationAttemptId()) {
            return null;
        }
        this.applicationAttemptID = this.convertFromProtoFormat(p.getApplicationAttemptId());
        return this.applicationAttemptID;
    }

    @Override
    public void setApplicationAttemptId(ApplicationAttemptId appAttemptId) {
        this.maybeInitBuilder();
        if (appAttemptId == null) {
            this.builder.clearApplicationAttemptId();
        }
        this.applicationAttemptID = appAttemptId;
    }

    @Override
    public int getResponseId() {
        YarnServiceProtos.AllocateRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    @Override
    public void setResponseId(int id) {
        this.maybeInitBuilder();
        this.builder.setResponseId(id);
    }

    @Override
    public float getProgress() {
        YarnServiceProtos.AllocateRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getProgress();
    }

    @Override
    public void setProgress(float progress) {
        this.maybeInitBuilder();
        this.builder.setProgress(progress);
    }

    @Override
    public List<ResourceRequest> getAskList() {
        this.initAsks();
        return this.ask;
    }

    @Override
    public ResourceRequest getAsk(int index) {
        this.initAsks();
        return this.ask.get(index);
    }

    @Override
    public int getAskCount() {
        this.initAsks();
        return this.ask.size();
    }

    private void initAsks() {
        if (this.ask != null) {
            return;
        }
        YarnServiceProtos.AllocateRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ResourceRequestProto> list = p.getAskList();
        this.ask = new ArrayList<ResourceRequest>();
        for (YarnProtos.ResourceRequestProto c : list) {
            this.ask.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllAsks(List<ResourceRequest> ask) {
        if (ask == null) {
            return;
        }
        this.initAsks();
        this.ask.addAll(ask);
    }

    private void addAsksToProto() {
        this.maybeInitBuilder();
        this.builder.clearAsk();
        if (this.ask == null) {
            return;
        }
        Iterable<YarnProtos.ResourceRequestProto> iterable = new Iterable<YarnProtos.ResourceRequestProto>(){

            @Override
            public Iterator<YarnProtos.ResourceRequestProto> iterator() {
                return new Iterator<YarnProtos.ResourceRequestProto>(){
                    Iterator<ResourceRequest> iter;
                    {
                        this.iter = AllocateRequestPBImpl.this.ask.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ResourceRequestProto next() {
                        return AllocateRequestPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllAsk((Iterable<? extends YarnProtos.ResourceRequestProto>)iterable);
    }

    @Override
    public void addAsk(ResourceRequest ask) {
        this.initAsks();
        this.ask.add(ask);
    }

    @Override
    public void removeAsk(int index) {
        this.initAsks();
        this.ask.remove(index);
    }

    @Override
    public void clearAsks() {
        this.initAsks();
        this.ask.clear();
    }

    @Override
    public List<ContainerId> getReleaseList() {
        this.initReleases();
        return this.release;
    }

    @Override
    public ContainerId getRelease(int index) {
        this.initReleases();
        return this.release.get(index);
    }

    @Override
    public int getReleaseCount() {
        this.initReleases();
        return this.release.size();
    }

    private void initReleases() {
        if (this.release != null) {
            return;
        }
        YarnServiceProtos.AllocateRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerIdProto> list = p.getReleaseList();
        this.release = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.release.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllReleases(List<ContainerId> release) {
        if (release == null) {
            return;
        }
        this.initReleases();
        this.release.addAll(release);
    }

    private void addReleasesToProto() {
        this.maybeInitBuilder();
        this.builder.clearRelease();
        if (this.release == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    Iterator<ContainerId> iter;
                    {
                        this.iter = AllocateRequestPBImpl.this.release.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return AllocateRequestPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllRelease((Iterable<? extends YarnProtos.ContainerIdProto>)iterable);
    }

    @Override
    public void addRelease(ContainerId release) {
        this.initReleases();
        this.release.add(release);
    }

    @Override
    public void removeRelease(int index) {
        this.initReleases();
        this.release.remove(index);
    }

    @Override
    public void clearReleases() {
        this.initReleases();
        this.release.clear();
    }

    private ApplicationAttemptIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationAttemptIdProto p) {
        return new ApplicationAttemptIdPBImpl(p);
    }

    private YarnProtos.ApplicationAttemptIdProto convertToProtoFormat(ApplicationAttemptId t) {
        return ((ApplicationAttemptIdPBImpl)t).getProto();
    }

    private ResourceRequestPBImpl convertFromProtoFormat(YarnProtos.ResourceRequestProto p) {
        return new ResourceRequestPBImpl(p);
    }

    private YarnProtos.ResourceRequestProto convertToProtoFormat(ResourceRequest t) {
        return ((ResourceRequestPBImpl)t).getProto();
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }
}

