/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.NodeAttributeOpCode;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.util.constraint.PlacementConstraintParseException;
import org.apache.hadoop.yarn.util.constraint.PlacementConstraintParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestPlacementConstraintParser {
    TestPlacementConstraintParser() {
    }

    @Test
    void testTargetExpressionParser() throws PlacementConstraintParseException {
        String expressionStr = "NOTIN, NODE, foo";
        PlacementConstraintParser.TargetConstraintParser parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((Object)"node", (Object)single.getScope());
        Assertions.assertEquals((int)0, (int)single.getMinCardinality());
        Assertions.assertEquals((int)0, (int)single.getMaxCardinality());
        this.verifyConstraintToString(expressionStr, constraint);
        expressionStr = "notin, node, foo";
        parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((Object)"node", (Object)single.getScope());
        Assertions.assertEquals((int)0, (int)single.getMinCardinality());
        Assertions.assertEquals((int)0, (int)single.getMaxCardinality());
        this.verifyConstraintToString(expressionStr, constraint);
        expressionStr = "IN, NODE, foo";
        parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((Object)"node", (Object)single.getScope());
        Assertions.assertEquals((int)1, (int)single.getMinCardinality());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)single.getMaxCardinality());
        this.verifyConstraintToString(expressionStr, constraint);
        expressionStr = "NOTIN, NODE, foo, bar, exp";
        parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((Object)"node", (Object)single.getScope());
        Assertions.assertEquals((int)0, (int)single.getMinCardinality());
        Assertions.assertEquals((int)0, (int)single.getMaxCardinality());
        Assertions.assertEquals((int)3, (int)single.getTargetExpressions().size());
        HashSet expectedTargetExpressions = Sets.newHashSet((Object[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"}), PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"}), PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"exp"})});
        Assertions.assertTrue((boolean)Sets.difference((Set)expectedTargetExpressions, (Set)single.getTargetExpressions()).isEmpty());
        this.verifyConstraintToString(expressionStr, constraint);
        parser = new PlacementConstraintParser.TargetConstraintParser("XYZ, NODE, foo");
        try {
            parser.parse();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof PlacementConstraintParseException));
            Assertions.assertTrue((boolean)e.getMessage().contains("expecting in or notin"));
        }
    }

    @Test
    void testCardinalityConstraintParser() throws PlacementConstraintParseException {
        String expressionExpr = "cardinality, NODE, foo, 0, 1";
        PlacementConstraintParser.CardinalityConstraintParser parser = new PlacementConstraintParser.CardinalityConstraintParser(expressionExpr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((Object)"node", (Object)single.getScope());
        Assertions.assertEquals((int)0, (int)single.getMinCardinality());
        Assertions.assertEquals((int)1, (int)single.getMaxCardinality());
        Assertions.assertEquals((int)1, (int)single.getTargetExpressions().size());
        PlacementConstraint.TargetExpression exp = (PlacementConstraint.TargetExpression)single.getTargetExpressions().iterator().next();
        Assertions.assertEquals((Object)"ALLOCATION_TAG", (Object)exp.getTargetType().toString());
        Assertions.assertEquals((int)1, (int)exp.getTargetValues().size());
        Assertions.assertEquals((Object)"foo", exp.getTargetValues().iterator().next());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "cardinality,RACK,foo,bar,moo,0,1";
        parser = new PlacementConstraintParser.CardinalityConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((Object)"rack", (Object)single.getScope());
        Assertions.assertEquals((int)0, (int)single.getMinCardinality());
        Assertions.assertEquals((int)1, (int)single.getMaxCardinality());
        Assertions.assertEquals((int)3, (int)single.getTargetExpressions().size());
        HashSet expectedTargetExpressions = Sets.newHashSet((Object[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"}), PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"}), PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"moo"})});
        Assertions.assertTrue((boolean)Sets.difference((Set)expectedTargetExpressions, (Set)single.getTargetExpressions()).isEmpty());
        this.verifyConstraintToString(expressionExpr, constraint);
        try {
            parser = new PlacementConstraintParser.CardinalityConstraintParser("cardinality,NOWHERE,foo,bar,moo,0,1");
            parser.parse();
            Assertions.fail((String)"Expecting a parsing failure!");
        }
        catch (PlacementConstraintParseException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("expecting scope to node or rack, but met NOWHERE"));
        }
        try {
            parser = new PlacementConstraintParser.CardinalityConstraintParser("cardinality,NODE,0,1");
            parser.parse();
            Assertions.fail((String)"Expecting a parsing failure!");
        }
        catch (PlacementConstraintParseException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("at least 5 elements, but only 4 is given"));
        }
    }

    @Test
    void testAndConstraintParser() throws PlacementConstraintParseException {
        String expressionExpr = "AND(NOTIN,NODE,foo:NOTIN,NODE,bar)";
        PlacementConstraintParser.ConjunctionConstraintParser parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.And));
        PlacementConstraint.And and = (PlacementConstraint.And)constraint;
        Assertions.assertEquals((int)2, (int)and.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "AND(NOTIN,NODE,foo:cardinality,NODE,foo,0,1)";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.And));
        Assertions.assertEquals((int)2, (int)and.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "AND(NOTIN,NODE,foo:AND(NOTIN,NODE,foo:cardinality,NODE,foo,0,1))";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.And));
        and = (PlacementConstraint.And)constraint;
        Assertions.assertTrue((boolean)(and.getChildren().get(0) instanceof PlacementConstraint.SingleConstraint));
        Assertions.assertTrue((boolean)(and.getChildren().get(1) instanceof PlacementConstraint.And));
        and = (PlacementConstraint.And)and.getChildren().get(1);
        Assertions.assertEquals((int)2, (int)and.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
    }

    @Test
    void testOrConstraintParser() throws PlacementConstraintParseException {
        String expressionExpr = "OR(NOTIN,NODE,foo:NOTIN,NODE,bar)";
        PlacementConstraintParser.ConjunctionConstraintParser parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.Or));
        PlacementConstraint.Or or = (PlacementConstraint.Or)constraint;
        Assertions.assertEquals((int)2, (int)or.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "OR(NOTIN,NODE,foo:cardinality,NODE,foo,0,1)";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.Or));
        Assertions.assertEquals((int)2, (int)or.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "OR(NOTIN,NODE,foo:OR(NOTIN,NODE,foo:cardinality,NODE,foo,0,1))";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.Or));
        or = (PlacementConstraint.Or)constraint;
        Assertions.assertTrue((boolean)(or.getChildren().get(0) instanceof PlacementConstraint.SingleConstraint));
        Assertions.assertTrue((boolean)(or.getChildren().get(1) instanceof PlacementConstraint.Or));
        or = (PlacementConstraint.Or)or.getChildren().get(1);
        Assertions.assertEquals((int)2, (int)or.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
    }

    @Test
    void testMultipleConstraintsTokenizer() throws PlacementConstraintParseException {
        PlacementConstraintParser.MultipleConstraintsTokenizer ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("foo(1),A1,A2,A3:bar(2),B1,B2:moo(3),C1,C2");
        TokenizerTester mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "foo(1),A1,A2,A3", "bar(2),B1,B2", "moo(3),C1,C2");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("foo(1),AND(A2:A3):bar(2),OR(B1:AND(B2:B3)):moo(3),C1,C2");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "foo(1),AND(A2:A3)", "bar(2),OR(B1:AND(B2:B3))", "moo(3),C1,C2");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:B:C");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "B", "C");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:AND(B:C):D");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "AND(B:C)", "D");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:AND(B:OR(C:D)):E");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "AND(B:OR(C:D))", "E");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:AND(B:OR(C:D)):E");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "AND(B:OR(C:D))", "E");
        mp.verify();
        PlacementConstraintParser.SourceTagsTokenizer st = new PlacementConstraintParser.SourceTagsTokenizer("A(4)");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)st, "A", "4");
        mp.verify();
        try {
            st = new PlacementConstraintParser.SourceTagsTokenizer("A(B)");
            mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)st, "A", "B");
            mp.verify();
            Assertions.fail((String)"Expecting a parsing failure");
        }
        catch (PlacementConstraintParseException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Value of the expression must be an integer"));
        }
    }

    @Test
    void testParsePlacementSpec() throws PlacementConstraintParseException {
        String[] invalidSpecs;
        Map result = PlacementConstraintParser.parsePlacementSpec((String)"foo(3)");
        Assertions.assertEquals((int)1, (int)result.size());
        PlacementConstraintParser.SourceTags tag1 = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assertions.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assertions.assertEquals((int)3, (int)tag1.getNumOfAllocations());
        PlacementConstraint expectedPc1 = null;
        PlacementConstraint actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals(expectedPc1, (Object)actualPc1);
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo(3),notin,node,foo");
        Assertions.assertEquals((int)1, (int)result.size());
        tag1 = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assertions.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assertions.assertEquals((int)3, (int)tag1.getNumOfAllocations());
        expectedPc1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1);
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo(3),NOTIN,NODE,foo");
        Assertions.assertEquals((int)1, (int)result.size());
        tag1 = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assertions.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assertions.assertEquals((int)3, (int)tag1.getNumOfAllocations());
        expectedPc1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1);
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo(10),cardinality,node,foo,bar,0,100");
        Assertions.assertEquals((int)1, (int)result.size());
        tag1 = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assertions.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assertions.assertEquals((int)10, (int)tag1.getNumOfAllocations());
        PlacementConstraint.TargetExpression[] targetExpressions = new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"}), PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})};
        expectedPc1 = PlacementConstraints.targetCardinality((String)"node", (int)0, (int)100, (PlacementConstraint.TargetExpression[])targetExpressions).build();
        Assertions.assertEquals((Object)expectedPc1, result.values().iterator().next());
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo(3),notin,node,foo:bar(2),in,node,foo");
        Assertions.assertEquals((int)2, (int)result.size());
        Iterator keyIt = result.keySet().iterator();
        tag1 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assertions.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assertions.assertEquals((int)3, (int)tag1.getNumOfAllocations());
        PlacementConstraintParser.SourceTags tag2 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assertions.assertEquals((Object)"bar", (Object)tag2.getTag());
        Assertions.assertEquals((int)2, (int)tag2.getNumOfAllocations());
        Iterator valueIt = result.values().iterator();
        expectedPc1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        PlacementConstraint expectedPc2 = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        Assertions.assertEquals((Object)expectedPc1, valueIt.next());
        Assertions.assertEquals((Object)expectedPc2, valueIt.next());
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo(1000),and(notin,node,bar:in,node,foo)");
        Assertions.assertEquals((int)1, (int)result.size());
        keyIt = result.keySet().iterator();
        tag1 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assertions.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assertions.assertEquals((int)1000, (int)tag1.getNumOfAllocations());
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        expectedPc1 = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})}), PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})})}).build();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1);
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo(1000),and(notin,node,bar:or(in,node,foo:in,node,moo)):bar(200),notin,node,foo");
        Assertions.assertEquals((int)2, (int)result.size());
        keyIt = result.keySet().iterator();
        tag1 = (PlacementConstraintParser.SourceTags)keyIt.next();
        tag2 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assertions.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assertions.assertEquals((int)1000, (int)tag1.getNumOfAllocations());
        Assertions.assertEquals((Object)"bar", (Object)tag2.getTag());
        Assertions.assertEquals((int)200, (int)tag2.getNumOfAllocations());
        valueIt = result.values().iterator();
        actualPc1 = (PlacementConstraint)valueIt.next();
        PlacementConstraint actualPc2 = (PlacementConstraint)valueIt.next();
        expectedPc1 = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})}), PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}), PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"moo"})})})}).build();
        Assertions.assertEquals((Object)actualPc1, (Object)expectedPc1);
        expectedPc2 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        Assertions.assertEquals((Object)expectedPc2, (Object)actualPc2);
        for (String spec : invalidSpecs = new String[]{"foo(3", "foo),bar", "foobar", "),java=1.7,1.8"}) {
            try {
                result = PlacementConstraintParser.parsePlacementSpec((String)spec);
                Assertions.fail((String)"Expected a failure!");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)(e instanceof PlacementConstraintParseException));
            }
        }
    }

    private void verifyConstraintToString(String inputExpr, PlacementConstraint.AbstractConstraint constraint) {
        String constrainExpr = constraint.toString();
        System.out.println("Input:    " + inputExpr.toLowerCase().replaceAll(" ", ""));
        System.out.println("ToString: " + constrainExpr);
        try {
            PlacementConstraintParser.parseExpression((String)constrainExpr);
        }
        catch (PlacementConstraintParseException e) {
            Assertions.fail((String)("The parser is unable to parse the expression: " + constrainExpr + ", caused by: " + e.getMessage()));
        }
    }

    @Test
    void testParseNodeAttributeSpec() throws PlacementConstraintParseException {
        Map result = PlacementConstraintParser.parsePlacementSpec((String)"xyz(4),rm.yarn.io/foo=true");
        Assertions.assertEquals((int)1, (int)result.size());
        PlacementConstraint.TargetExpression target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"true"});
        PlacementConstraint.AbstractConstraint expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        PlacementConstraint actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        result = PlacementConstraintParser.parsePlacementSpec((String)"xyz(3),rm.yarn.io/foo!=abc");
        Assertions.assertEquals((int)1, (int)result.size());
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"abc"});
        expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.NE, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        result = PlacementConstraintParser.parsePlacementSpec((String)"xyz(1),rm.yarn.io/foo!=abc:zxy(1),rm.yarn.io/bar=true");
        Assertions.assertEquals((int)2, (int)result.size());
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"abc"});
        expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.NE, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/bar", (String[])new String[]{"true"});
        PlacementConstraint.AbstractConstraint expectedPc2 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        Iterator valueIt = result.values().iterator();
        actualPc1 = (PlacementConstraint)valueIt.next();
        PlacementConstraint actualPc2 = (PlacementConstraint)valueIt.next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        Assertions.assertEquals((Object)expectedPc2, (Object)actualPc2.getConstraintExpr());
        result = PlacementConstraintParser.parsePlacementSpec((String)"rm.yarn.io/foo=true");
        Assertions.assertEquals((int)1, (int)result.size());
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"true"});
        expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        PlacementConstraintParser.SourceTags actualSourceTags = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assertions.assertTrue((boolean)actualSourceTags.isEmpty());
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        result = PlacementConstraintParser.parsePlacementSpec((String)"java=1.7,1.8");
        Assertions.assertEquals((int)1, (int)result.size());
        TreeSet<String> constraintEntities = new TreeSet<String>();
        constraintEntities.add("1.7");
        constraintEntities.add("1.8");
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"java", (String[])constraintEntities.toArray(new String[constraintEntities.size()]));
        expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        actualSourceTags = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assertions.assertTrue((boolean)actualSourceTags.isEmpty());
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assertions.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        try {
            PlacementConstraintParser.parsePlacementSpec((String)"rm.yarn.io/foo=true:xyz(1),notin,node,xyz");
            Assertions.fail((String)"Expected a failure!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof PlacementConstraintParseException));
        }
    }

    @Test
    public void testParseIllegalExprShouldThrowException() {
        try {
            PlacementConstraintParser.parseExpression((String)"rm.yarn.io/foo=true,rm.yarn.io/bar=true");
            Assertions.fail((String)"Expected a failure!");
        }
        catch (PlacementConstraintParseException placementConstraintParseException) {
            // empty catch block
        }
    }

    @Test
    void testParseAllocationTagNameSpace() throws PlacementConstraintParseException {
        Map result = PlacementConstraintParser.parsePlacementSpec((String)"foo(2),notin,node,not-self/bar,all/moo");
        Assertions.assertEquals((int)1, (int)result.size());
        HashSet expectedTargetExpressions = Sets.newHashSet((Object[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)"not-self", (String[])new String[]{"bar"}), PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)"all", (String[])new String[]{"moo"})});
        PlacementConstraint.AbstractConstraint constraint = ((PlacementConstraint)result.values().iterator().next()).getConstraintExpr();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((int)2, (int)single.getTargetExpressions().size());
        Assertions.assertTrue((boolean)Sets.difference((Set)expectedTargetExpressions, (Set)single.getTargetExpressions()).isEmpty());
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo(2),notin,node,moo");
        Assertions.assertEquals((int)1, (int)result.size());
        PlacementConstraint.TargetExpression expectedTargetExpression = PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)"self", (String[])new String[]{"moo"});
        constraint = ((PlacementConstraint)result.values().iterator().next()).getConstraintExpr();
        Assertions.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assertions.assertEquals((int)1, (int)single.getTargetExpressions().size());
        Assertions.assertEquals((Object)expectedTargetExpression, single.getTargetExpressions().iterator().next());
        boolean caughtException = false;
        try {
            result = PlacementConstraintParser.parsePlacementSpec((String)"foo(2),notin,node,bar/moo");
        }
        catch (PlacementConstraintParseException e) {
            caughtException = true;
        }
        Assertions.assertTrue((boolean)caughtException, (String)"PlacementConstraintParseException is expected");
    }

    private static class TokenizerTester {
        private PlacementConstraintParser.ConstraintTokenizer tokenizer;
        private String[] expectedExtractions;

        protected TokenizerTester(PlacementConstraintParser.ConstraintTokenizer tk, String ... expctedStrings) {
            this.tokenizer = tk;
            this.expectedExtractions = expctedStrings;
        }

        void verify() throws PlacementConstraintParseException {
            this.tokenizer.validate();
            int i = 0;
            while (this.tokenizer.hasMoreElements()) {
                String current = (String)this.tokenizer.nextElement();
                Assertions.assertTrue((i < this.expectedExtractions.length ? 1 : 0) != 0);
                Assertions.assertEquals((Object)this.expectedExtractions[i], (Object)current);
                ++i;
            }
        }
    }
}

