/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.applications.distributedshell.TestDSAppMaster;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDSAppMaster {
    @Test
    public void testDSAppMasterAllocateHandler() throws Exception {
        TestAppMaster master = new TestAppMaster();
        int targetContainers = 2;
        AMRMClientAsync mockClient = (AMRMClientAsync)Mockito.mock(AMRMClientAsync.class);
        master.setAmRMClient(mockClient);
        master.setNumTotalContainers(targetContainers);
        ((AMRMClientAsync)Mockito.doNothing().when((Object)mockClient)).addContainerRequest((AMRMClient.ContainerRequest)Matchers.any(AMRMClient.ContainerRequest.class));
        ApplicationMaster.RMCallbackHandler handler = master.getRMCallbackHandler();
        ArrayList<Container> containers = new ArrayList<Container>(1);
        ContainerId id1 = BuilderUtils.newContainerId((int)1, (int)1, (long)1L, (long)1L);
        containers.add(this.generateContainer(id1));
        master.numRequestedContainers.set(targetContainers);
        handler.onContainersAllocated(containers);
        Assert.assertEquals((String)"Wrong container allocation count", (long)1L, (long)master.getAllocatedContainers());
        Mockito.verifyZeroInteractions((Object[])new Object[]{mockClient});
        Assert.assertEquals((String)"Incorrect number of threads launched", (long)1L, (long)TestAppMaster.access$000((TestAppMaster)master));
        Assert.assertEquals((String)"Incorrect YARN Shell IDs", Arrays.asList("1"), (Object)master.yarnShellIds);
        containers.clear();
        ContainerId id2 = BuilderUtils.newContainerId((int)1, (int)1, (long)1L, (long)2L);
        containers.add(this.generateContainer(id2));
        ContainerId id3 = BuilderUtils.newContainerId((int)1, (int)1, (long)1L, (long)3L);
        containers.add(this.generateContainer(id3));
        ContainerId id4 = BuilderUtils.newContainerId((int)1, (int)1, (long)1L, (long)4L);
        containers.add(this.generateContainer(id4));
        handler.onContainersAllocated(containers);
        Assert.assertEquals((String)"Wrong final container allocation count", (long)4L, (long)master.getAllocatedContainers());
        Assert.assertEquals((String)"Incorrect number of threads launched", (long)4L, (long)TestAppMaster.access$000((TestAppMaster)master));
        Assert.assertEquals((String)"Incorrect YARN Shell IDs", Arrays.asList("1", "2", "3", "4"), (Object)master.yarnShellIds);
        ArrayList<ContainerStatus> status = new ArrayList<ContainerStatus>();
        status.add(this.generateContainerStatus(id1, 0));
        status.add(this.generateContainerStatus(id2, 0));
        status.add(this.generateContainerStatus(id3, -100));
        status.add(this.generateContainerStatus(id4, -100));
        handler.onContainersCompleted(status);
        Assert.assertEquals((String)"Unexpected number of completed containers", (long)targetContainers, (long)master.getNumCompletedContainers());
        Assert.assertTrue((String)"Master didn't finish containers as expected", (boolean)master.getDone());
        status = new ArrayList();
        ContainerId id5 = BuilderUtils.newContainerId((int)1, (int)1, (long)1L, (long)5L);
        status.add(this.generateContainerStatus(id5, -100));
        Assert.assertEquals((String)"Unexpected number of completed containers", (long)targetContainers, (long)master.getNumCompletedContainers());
        Assert.assertTrue((String)"Master didn't finish containers as expected", (boolean)master.getDone());
        status.add(this.generateContainerStatus(id5, 0));
        Assert.assertEquals((String)"Unexpected number of completed containers", (long)targetContainers, (long)master.getNumCompletedContainers());
        Assert.assertTrue((String)"Master didn't finish containers as expected", (boolean)master.getDone());
    }

    private Container generateContainer(ContainerId cid) {
        return Container.newInstance((ContainerId)cid, (NodeId)NodeId.newInstance((String)"host", (int)5000), (String)"host:80", (Resource)Resource.newInstance((int)1024, (int)1), (Priority)Priority.newInstance((int)0), null);
    }

    private ContainerStatus generateContainerStatus(ContainerId id, int exitStatus) {
        return ContainerStatus.newInstance((ContainerId)id, (ContainerState)ContainerState.COMPLETE, (String)"", (int)exitStatus);
    }

    @Test
    public void testTimelineClientInDSAppMasterV1() throws Exception {
        this.runTimelineClientInDSAppMaster(true, false);
    }

    @Test
    public void testTimelineClientInDSAppMasterV2() throws Exception {
        this.runTimelineClientInDSAppMaster(false, true);
    }

    @Test
    public void testTimelineClientInDSAppMasterV1V2() throws Exception {
        this.runTimelineClientInDSAppMaster(true, true);
    }

    @Test
    public void testTimelineClientInDSAppMasterDisabled() throws Exception {
        this.runTimelineClientInDSAppMaster(false, false);
    }

    private void runTimelineClientInDSAppMaster(boolean v1Enabled, boolean v2Enabled) throws Exception {
        ApplicationMaster appMaster = this.createAppMasterWithStartedTimelineService(v1Enabled, v2Enabled);
        this.validateAppMasterTimelineService(v1Enabled, v2Enabled, appMaster);
    }

    private void validateAppMasterTimelineService(boolean v1Enabled, boolean v2Enabled, ApplicationMaster appMaster) {
        if (v1Enabled) {
            Assert.assertEquals((Object)appMaster.appSubmitterUgi, (Object)((TimelineClientImpl)appMaster.timelineClient).getUgi());
        } else {
            Assert.assertNull((Object)appMaster.timelineClient);
        }
        if (v2Enabled) {
            Assert.assertNotNull((Object)appMaster.timelineV2Client);
        } else {
            Assert.assertNull((Object)appMaster.timelineV2Client);
        }
    }

    private ApplicationMaster createAppMasterWithStartedTimelineService(boolean v1Enabled, boolean v2Enabled) throws Exception {
        ApplicationMaster appMaster = new ApplicationMaster();
        appMaster.appSubmitterUgi = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"bar"});
        Configuration conf = this.getTimelineServiceConf(v1Enabled, v2Enabled);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        appMaster.appAttemptID = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        appMaster.startTimelineClient(conf);
        return appMaster;
    }

    private Configuration getTimelineServiceConf(boolean v1Enabled, boolean v2Enabled) {
        YarnConfiguration conf = new YarnConfiguration(new Configuration(false));
        Assert.assertFalse((boolean)YarnConfiguration.timelineServiceEnabled((Configuration)conf));
        if (v1Enabled || v2Enabled) {
            conf.setBoolean("yarn.timeline-service.enabled", true);
        }
        if (v1Enabled) {
            conf.setFloat("yarn.timeline-service.version", 1.0f);
        }
        if (v2Enabled) {
            conf.setFloat("yarn.timeline-service.version", 2.0f);
            conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        }
        if (v1Enabled && v2Enabled) {
            conf.set("yarn.timeline-service.version", "1.0");
            conf.set("yarn.timeline-service.versions", "1.0,2.0f");
        }
        return conf;
    }
}

