/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.applications.distributedshell.Client;
import org.apache.hadoop.yarn.applications.distributedshell.ContainerLaunchFailAppMaster;
import org.apache.hadoop.yarn.applications.distributedshell.DistributedShellTimelinePlugin;
import org.apache.hadoop.yarn.applications.distributedshell.TestDSFailedAppMaster;
import org.apache.hadoop.yarn.applications.distributedshell.TestDSSleepingAppMaster;
import org.apache.hadoop.yarn.applications.distributedshell.TestDistributedShell;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.TestTimelineClient;
import org.apache.hadoop.yarn.client.api.impl.TimelineWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.PluginStoreTestUtils;
import org.apache.hadoop.yarn.server.timeline.TimelineVersion;
import org.apache.hadoop.yarn.server.timeline.TimelineVersionWatcher;
import org.apache.hadoop.yarn.server.timelineservice.collector.PerNodeTimelineCollectorsAuxService;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.LinuxResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestDistributedShell {
    private static final Log LOG = LogFactory.getLog(TestDistributedShell.class);
    protected MiniYARNCluster yarnCluster = null;
    protected MiniDFSCluster hdfsCluster = null;
    private FileSystem fs = null;
    private TimelineWriter spyTimelineWriter;
    protected YarnConfiguration conf = null;
    private String timelineV2StorageDir = null;
    private static final int NUM_NMS = 1;
    private static final float DEFAULT_TIMELINE_VERSION = 1.0f;
    private static final String TIMELINE_AUX_SERVICE_NAME = "timeline_collector";
    protected static final String APPMASTER_JAR = JarFinder.getJar(ApplicationMaster.class);
    @Rule
    public TimelineVersionWatcher timelineVersionWatcher = new TimelineVersionWatcher();
    @Rule
    public Timeout globalTimeout = new Timeout(90000);
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setup() throws Exception {
        this.setupInternal(1, this.timelineVersionWatcher.getTimelineVersion());
    }

    protected void setupInternal(int numNodeManager) throws Exception {
        this.setupInternal(numNodeManager, 1.0f);
    }

    private void setupInternal(int numNodeManager, float timelineVersion) throws Exception {
        LOG.info((Object)"Starting up YARN cluster");
        this.conf = new YarnConfiguration();
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 128);
        this.conf.setLong("yarn.dispatcher.drain-events.timeout", 1000L);
        this.conf.set("yarn.log.dir", "target");
        this.conf.setBoolean("yarn.timeline-service.enabled", true);
        this.conf.set("yarn.nodemanager.aux-services", "");
        this.conf.setBoolean("yarn.system-metrics-publisher.enabled", true);
        this.conf.set("yarn.nodemanager.vmem-pmem-ratio", "8");
        this.conf.setBoolean("yarn.node-labels.enabled", true);
        this.conf.set("mapreduce.jobhistory.address", "0.0.0.0:" + ServerSocketUtil.getPort((int)10021, (int)10));
        this.conf.set("yarn.nodemanager.container-monitor.resource-calculator.class", LinuxResourceCalculatorPlugin.class.getName());
        this.conf.set("yarn.nodemanager.container-monitor.process-tree.class", ProcfsBasedProcessTree.class.getName());
        this.conf.setBoolean("yarn.nodemanager.pmem-check-enabled", true);
        this.conf.setBoolean("yarn.nodemanager.vmem-check-enabled", true);
        this.conf.setBoolean("yarn.minicluster.control-resource-monitoring", true);
        this.conf.setBoolean("yarn.resourcemanager.system-metrics-publisher.enabled", true);
        if (timelineVersion == 1.0f) {
            this.conf.setFloat("yarn.timeline-service.version", 1.0f);
            this.conf.set("fs.defaultFS", "file:///");
        } else if (timelineVersion == 1.5f) {
            if (this.hdfsCluster == null) {
                HdfsConfiguration hdfsConfig = new HdfsConfiguration();
                this.hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
            }
            this.fs = this.hdfsCluster.getFileSystem();
            PluginStoreTestUtils.prepareFileSystemForPluginStore((FileSystem)this.fs);
            PluginStoreTestUtils.prepareConfiguration((YarnConfiguration)this.conf, (MiniDFSCluster)this.hdfsCluster);
            this.conf.set("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classes", DistributedShellTimelinePlugin.class.getName());
        } else if (timelineVersion == 2.0f) {
            this.conf.setFloat("yarn.timeline-service.version", 2.0f);
            this.conf.set("yarn.nodemanager.aux-services", TIMELINE_AUX_SERVICE_NAME);
            this.conf.set("yarn.nodemanager.aux-services.timeline_collector.class", PerNodeTimelineCollectorsAuxService.class.getName());
            this.conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter.class);
            this.timelineV2StorageDir = this.tmpFolder.newFolder().getAbsolutePath();
            this.conf.set("yarn.timeline-service.fs-writer.root-dir", this.timelineV2StorageDir);
        } else {
            Assert.fail((String)("Wrong timeline version number: " + timelineVersion));
        }
        if (this.yarnCluster == null) {
            this.yarnCluster = new MiniYARNCluster(TestDistributedShell.class.getSimpleName(), 1, numNodeManager, 1, 1);
            this.yarnCluster.init((Configuration)this.conf);
            this.yarnCluster.start();
            this.conf.set("yarn.timeline-service.webapp.address", MiniYARNCluster.getHostname() + ":" + this.yarnCluster.getApplicationHistoryServer().getPort());
            this.waitForNMsToRegister();
            URL url = Thread.currentThread().getContextClassLoader().getResource("yarn-site.xml");
            if (url == null) {
                throw new RuntimeException("Could not find 'yarn-site.xml' dummy file in classpath");
            }
            Configuration yarnClusterConfig = this.yarnCluster.getConfig();
            yarnClusterConfig.set("yarn.application.classpath", new File(url.getPath()).getParent());
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            yarnClusterConfig.writeXml((OutputStream)bytesOut);
            bytesOut.close();
            FileOutputStream os = new FileOutputStream(new File(url.getPath()));
            ((OutputStream)os).write(bytesOut.toByteArray());
            ((OutputStream)os).close();
        }
        FileContext fsContext = FileContext.getLocalFSFileContext();
        fsContext.delete(new Path(this.conf.get("yarn.timeline-service.leveldb-timeline-store.path")), true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOG.info((Object)("setup thread sleep interrupted. message=" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws IOException {
        if (this.yarnCluster != null) {
            try {
                this.yarnCluster.stop();
            }
            finally {
                this.yarnCluster = null;
            }
        }
        if (this.hdfsCluster != null) {
            try {
                this.hdfsCluster.shutdown();
            }
            finally {
                this.hdfsCluster = null;
            }
        }
        FileContext fsContext = FileContext.getLocalFSFileContext();
        fsContext.delete(new Path(this.conf.get("yarn.timeline-service.leveldb-timeline-store.path")), true);
    }

    @Test
    public void testDSShellWithDomain() throws Exception {
        this.testDSShell(true);
    }

    @Test
    public void testDSShellWithoutDomain() throws Exception {
        this.testDSShell(false);
    }

    @Test
    @TimelineVersion(value=1.5f)
    public void testDSShellWithoutDomainV1_5() throws Exception {
        this.testDSShell(false);
    }

    @Test
    @TimelineVersion(value=1.5f)
    public void testDSShellWithDomainV1_5() throws Exception {
        this.testDSShell(true);
    }

    @Test
    @TimelineVersion(value=2.0f)
    public void testDSShellWithoutDomainV2() throws Exception {
        this.testDSShell(false);
    }

    public void testDSShell(boolean haveDomain) throws Exception {
        this.testDSShell(haveDomain, true);
    }

    @Test
    @TimelineVersion(value=2.0f)
    public void testDSShellWithoutDomainV2DefaultFlow() throws Exception {
        this.testDSShell(false, true);
    }

    @Test
    @TimelineVersion(value=2.0f)
    public void testDSShellWithoutDomainV2CustomizedFlow() throws Exception {
        this.testDSShell(false, false);
    }

    public void testDSShell(boolean haveDomain, boolean defaultFlow) throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        if (haveDomain) {
            String[] domainArgs = new String[]{"--domain", "TEST_DOMAIN", "--view_acls", "reader_user reader_group", "--modify_acls", "writer_user writer_group", "--create"};
            args = this.mergeArgs(args, domainArgs);
        }
        boolean isTestingTimelineV2 = false;
        if (this.timelineVersionWatcher.getTimelineVersion() == 2.0f) {
            isTestingTimelineV2 = true;
            if (!defaultFlow) {
                String[] flowArgs = new String[]{"--flow_name", "test_flow_name", "--flow_version", "test_flow_version", "--flow_run_id", "12345678"};
                args = this.mergeArgs(args, flowArgs);
            }
            LOG.info((Object)"Setup: Using timeline v2!");
        }
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        AtomicBoolean result = new AtomicBoolean(false);
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init(new Configuration(this.yarnCluster.getConfig()));
        yarnClient.start();
        String hostName = NetUtils.getHostname();
        boolean verified = false;
        String errorMessage = "";
        ApplicationId appId = null;
        ApplicationReport appReport = null;
        while (!verified) {
            List apps = yarnClient.getApplications();
            if (apps.size() == 0) {
                Thread.sleep(10L);
                continue;
            }
            appReport = (ApplicationReport)apps.get(0);
            appId = appReport.getApplicationId();
            if (appReport.getHost().equals("N/A")) {
                Thread.sleep(10L);
                continue;
            }
            errorMessage = "Expected host name to start with '" + hostName + "', was '" + appReport.getHost() + "'. Expected rpc port to be '-1', was '" + appReport.getRpcPort() + "'.";
            if (this.checkHostname(appReport.getHost()) && appReport.getRpcPort() == -1) {
                verified = true;
            }
            if (appReport.getYarnApplicationState() != YarnApplicationState.FINISHED || appReport.getFinalApplicationStatus() == FinalApplicationStatus.UNDEFINED) continue;
            break;
        }
        Assert.assertTrue((String)errorMessage, (boolean)verified);
        t.join();
        LOG.info((Object)("Client run completed for testDSShell. Result=" + result));
        Assert.assertTrue((boolean)result.get());
        if (this.timelineVersionWatcher.getTimelineVersion() == 1.5f) {
            RemoteIterator iterApps;
            long scanInterval = this.conf.getLong("yarn.timeline-service.entity-group-fs-store.scan-interval-seconds", 60L);
            Path doneDir = new Path("/tmp/entity-file-history/done");
            while (!(iterApps = this.fs.listStatusIterator(doneDir)).hasNext()) {
                Thread.sleep(scanInterval * 2L);
            }
        }
        Object domain = null;
        if (!isTestingTimelineV2) {
            this.checkTimelineV1(haveDomain);
        } else {
            this.checkTimelineV2(haveDomain, appId, defaultFlow, appReport);
        }
    }

    private void checkTimelineV1(boolean haveDomain) throws Exception {
        TimelineDomain domain = null;
        if (haveDomain) {
            domain = this.yarnCluster.getApplicationHistoryServer().getTimelineStore().getDomain("TEST_DOMAIN");
            Assert.assertNotNull((Object)domain);
            Assert.assertEquals((Object)"reader_user reader_group", (Object)domain.getReaders());
            Assert.assertEquals((Object)"writer_user writer_group", (Object)domain.getWriters());
        }
        TimelineEntities entitiesAttempts = this.yarnCluster.getApplicationHistoryServer().getTimelineStore().getEntities(ApplicationMaster.DSEntity.DS_APP_ATTEMPT.toString(), null, null, null, null, null, null, null, null, null);
        Assert.assertNotNull((Object)entitiesAttempts);
        Assert.assertEquals((long)1L, (long)entitiesAttempts.getEntities().size());
        Assert.assertEquals((long)2L, (long)((TimelineEntity)entitiesAttempts.getEntities().get(0)).getEvents().size());
        Assert.assertEquals((Object)((TimelineEntity)entitiesAttempts.getEntities().get(0)).getEntityType().toString(), (Object)ApplicationMaster.DSEntity.DS_APP_ATTEMPT.toString());
        if (haveDomain) {
            Assert.assertEquals((Object)domain.getId(), (Object)((TimelineEntity)entitiesAttempts.getEntities().get(0)).getDomainId());
        } else {
            Assert.assertEquals((Object)"DEFAULT", (Object)((TimelineEntity)entitiesAttempts.getEntities().get(0)).getDomainId());
        }
        String currAttemptEntityId = ((TimelineEntity)entitiesAttempts.getEntities().get(0)).getEntityId();
        ApplicationAttemptId attemptId = ApplicationAttemptId.fromString((String)currAttemptEntityId);
        NameValuePair primaryFilter = new NameValuePair("appId", (Object)attemptId.getApplicationId().toString());
        TimelineEntities entities = this.yarnCluster.getApplicationHistoryServer().getTimelineStore().getEntities(ApplicationMaster.DSEntity.DS_CONTAINER.toString(), null, null, null, null, null, primaryFilter, null, null, null);
        Assert.assertNotNull((Object)entities);
        Assert.assertEquals((long)2L, (long)entities.getEntities().size());
        Assert.assertEquals((Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType().toString(), (Object)ApplicationMaster.DSEntity.DS_CONTAINER.toString());
        String entityId = ((TimelineEntity)entities.getEntities().get(0)).getEntityId();
        TimelineEntity entity = this.yarnCluster.getApplicationHistoryServer().getTimelineStore().getEntity(entityId, ApplicationMaster.DSEntity.DS_CONTAINER.toString(), null);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)entityId, (Object)entity.getEntityId());
        if (haveDomain) {
            Assert.assertEquals((Object)domain.getId(), (Object)((TimelineEntity)entities.getEntities().get(0)).getDomainId());
        } else {
            Assert.assertEquals((Object)"DEFAULT", (Object)((TimelineEntity)entities.getEntities().get(0)).getDomainId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTimelineV2(boolean haveDomain, ApplicationId appId, boolean defaultFlow, ApplicationReport appReport) throws Exception {
        LOG.info((Object)"Started checkTimelineV2 ");
        String tmpRoot = this.timelineV2StorageDir + File.separator + "entities" + File.separator;
        File tmpRootFolder = new File(tmpRoot);
        try {
            Assert.assertTrue((boolean)tmpRootFolder.isDirectory());
            String basePath = tmpRoot + "yarn_cluster" + File.separator + UserGroupInformation.getCurrentUser().getShortUserName() + (defaultFlow ? File.separator + appReport.getName() + File.separator + "1" + File.separator + appReport.getStartTime() + File.separator : File.separator + "test_flow_name" + File.separator + "test_flow_version" + File.separator + "12345678" + File.separator) + appId.toString();
            LOG.info((Object)("basePath: " + basePath));
            String appTimestampFileName = "appattempt_" + appId.getClusterTimestamp() + "_000" + appId.getId() + "_000001" + ".thist";
            File dsAppAttemptEntityFile = this.verifyEntityTypeFileExists(basePath, "DS_APP_ATTEMPT", appTimestampFileName);
            this.verifyEntityForTimelineV2(dsAppAttemptEntityFile, ApplicationMaster.DSEvent.DS_APP_ATTEMPT_START.toString(), 1L, 1, 0L, true);
            this.verifyEntityForTimelineV2(dsAppAttemptEntityFile, ApplicationMaster.DSEvent.DS_APP_ATTEMPT_END.toString(), 1L, 40, 50L, true);
            String containerTimestampFileName = "container_" + appId.getClusterTimestamp() + "_000" + appId.getId() + "_01_000002.thist";
            File dsContainerEntityFile = this.verifyEntityTypeFileExists(basePath, "DS_CONTAINER", containerTimestampFileName);
            this.verifyEntityForTimelineV2(dsContainerEntityFile, ApplicationMaster.DSEvent.DS_CONTAINER_START.toString(), 1L, 1, 0L, true);
            this.verifyEntityForTimelineV2(dsContainerEntityFile, ApplicationMaster.DSEvent.DS_CONTAINER_END.toString(), 1L, 40, 50L, true);
            String containerMetricsTimestampFileName = "container_" + appId.getClusterTimestamp() + "_000" + appId.getId() + "_01_000001" + ".thist";
            File containerEntityFile = this.verifyEntityTypeFileExists(basePath, TimelineEntityType.YARN_CONTAINER.toString(), containerMetricsTimestampFileName);
            this.verifyEntityForTimelineV2(containerEntityFile, "YARN_CONTAINER_CREATED", 1L, 1, 0L, true);
            this.verifyEntityForTimelineV2(containerEntityFile, "YARN_CONTAINER_FINISHED", 1L, 40, 50L, true);
            String appMetricsTimestampFileName = "application_" + appId.getClusterTimestamp() + "_000" + appId.getId() + ".thist";
            File appEntityFile = this.verifyEntityTypeFileExists(basePath, TimelineEntityType.YARN_APPLICATION.toString(), appMetricsTimestampFileName);
            this.verifyEntityForTimelineV2(appEntityFile, "YARN_APPLICATION_CREATED", 1L, 1, 0L, false);
            this.verifyEntityForTimelineV2(appEntityFile, "YARN_APPLICATION_FINISHED", 1L, 40, 50L, false);
            String appAttemptMetricsTimestampFileName = "appattempt_" + appId.getClusterTimestamp() + "_000" + appId.getId() + "_000001" + ".thist";
            File appAttemptEntityFile = this.verifyEntityTypeFileExists(basePath, TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), appAttemptMetricsTimestampFileName);
            this.verifyEntityForTimelineV2(appAttemptEntityFile, "YARN_APPLICATION_ATTEMPT_REGISTERED", 1L, 1, 0L, true);
            this.verifyEntityForTimelineV2(appAttemptEntityFile, "YARN_APPLICATION_ATTEMPT_FINISHED", 1L, 1, 0L, true);
        }
        finally {
            FileUtils.deleteDirectory((File)tmpRootFolder.getParentFile());
        }
    }

    private File verifyEntityTypeFileExists(String basePath, String entityType, String entityfileName) {
        String outputDirPathForEntity = basePath + File.separator + entityType + File.separator;
        File outputDirForEntity = new File(outputDirPathForEntity);
        Assert.assertTrue((boolean)outputDirForEntity.isDirectory());
        String entityFilePath = outputDirPathForEntity + entityfileName;
        File entityFile = new File(entityFilePath);
        Assert.assertTrue((boolean)entityFile.exists());
        return entityFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyEntityForTimelineV2(File entityFile, String expectedEvent, long numOfExpectedEvent, int checkTimes, long sleepTime, boolean checkIdPrefix) throws IOException, InterruptedException {
        long actualCount = 0L;
        for (int i = 0; i < checkTimes; ++i) {
            BufferedReader reader = null;
            String strLine = null;
            actualCount = 0L;
            try {
                reader = new BufferedReader(new FileReader(entityFile));
                long idPrefix = -1L;
                while ((strLine = reader.readLine()) != null) {
                    String entityLine = strLine.trim();
                    if (entityLine.isEmpty()) continue;
                    if (entityLine.contains(expectedEvent)) {
                        ++actualCount;
                    }
                    if (!checkIdPrefix) continue;
                    org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = (org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity)FileSystemTimelineReaderImpl.getTimelineRecordFromJSON((String)entityLine, org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity.class);
                    Assert.assertTrue((String)"Entity ID prefix expected to be > 0", (entity.getIdPrefix() > 0L ? 1 : 0) != 0);
                    if (idPrefix == -1L) {
                        idPrefix = entity.getIdPrefix();
                        continue;
                    }
                    Assert.assertEquals((String)"Entity ID prefix should be same across each publish of same entity", (long)idPrefix, (long)entity.getIdPrefix());
                }
            }
            finally {
                reader.close();
            }
            if (numOfExpectedEvent == actualCount) break;
            if (sleepTime <= 0L || i >= checkTimes - 1) continue;
            Thread.sleep(sleepTime);
        }
        Assert.assertEquals((String)("Unexpected number of " + expectedEvent + " event published."), (long)numOfExpectedEvent, (long)actualCount);
    }

    private String[] mergeArgs(String[] args, String[] newArgs) {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        argsList.addAll(Arrays.asList(newArgs));
        return argsList.toArray(new String[argsList.size()]);
    }

    private boolean checkHostname(String appHostname) throws Exception {
        String hostname = NetUtils.getHostname();
        if (hostname.equals(appHostname)) {
            return true;
        }
        Assert.assertTrue((String)("Unknown format for hostname " + appHostname), (boolean)appHostname.contains("/"));
        Assert.assertTrue((String)("Unknown format for hostname " + hostname), (boolean)hostname.contains("/"));
        String[] appHostnameParts = appHostname.split("/");
        String[] hostnameParts = hostname.split("/");
        return this.compareFQDNs(appHostnameParts[0], hostnameParts[0]) && this.checkIPs(hostnameParts[0], hostnameParts[1], appHostnameParts[1]);
    }

    private boolean compareFQDNs(String appHostname, String hostname) throws Exception {
        if (appHostname.equals(hostname)) {
            return true;
        }
        String appFQDN = InetAddress.getByName(appHostname).getCanonicalHostName();
        String localFQDN = InetAddress.getByName(hostname).getCanonicalHostName();
        return appFQDN.equals(localFQDN);
    }

    private boolean checkIPs(String hostname, String localIP, String appIP) throws Exception {
        InetAddress[] addresses;
        if (localIP.equals(appIP)) {
            return true;
        }
        boolean appIPCheck = false;
        boolean localIPCheck = false;
        for (InetAddress ia : addresses = InetAddress.getAllByName(hostname)) {
            if (ia.getHostAddress().equals(appIP)) {
                appIPCheck = true;
                continue;
            }
            if (!ia.getHostAddress().equals(localIP)) continue;
            localIPCheck = true;
        }
        return appIPCheck && localIPCheck;
    }

    private String getSleepCommand(int sec) {
        return Shell.WINDOWS ? "ping -n " + (sec + 1) + " 127.0.0.1 >nul" : "sleep " + sec;
    }

    @Test
    public void testDSRestartWithPreviousRunningContainers() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "1", "--shell_command", this.getSleepCommand(8), "--master_memory", "512", "--container_memory", "128", "--keep_containers_across_application_attempts"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(TestDSFailedAppMaster.class.getName(), new Configuration(this.yarnCluster.getConfig()));
        client.init(args);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDSAttemptFailuresValidityIntervalSucess() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "1", "--shell_command", this.getSleepCommand(8), "--master_memory", "512", "--container_memory", "128", "--attempt_failures_validity_interval", "2500"};
        LOG.info((Object)"Initializing DS Client");
        Configuration conf = this.yarnCluster.getConfig();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        Client client = new Client(TestDSSleepingAppMaster.class.getName(), new Configuration(conf));
        client.init(args);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDSAttemptFailuresValidityIntervalFailed() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "1", "--shell_command", this.getSleepCommand(8), "--master_memory", "512", "--container_memory", "128", "--attempt_failures_validity_interval", "15000"};
        LOG.info((Object)"Initializing DS Client");
        Configuration conf = this.yarnCluster.getConfig();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        Client client = new Client(TestDSSleepingAppMaster.class.getName(), new Configuration(conf));
        client.init(args);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testDSShellWithCustomLogPropertyFile() throws Exception {
        File basedir = new File("target", TestDistributedShell.class.getName());
        File tmpDir = new File(basedir, "tmpDir");
        tmpDir.mkdirs();
        File customLogProperty = new File(tmpDir, "custom_log4j.properties");
        if (customLogProperty.exists()) {
            customLogProperty.delete();
        }
        if (!customLogProperty.createNewFile()) {
            Assert.fail((String)"Can not create custom log4j property file.");
        }
        PrintWriter fileWriter = new PrintWriter(customLogProperty);
        fileWriter.write("log4j.rootLogger=debug,stdout");
        fileWriter.close();
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "3", "--shell_command", "echo", "--shell_args", "HADOOP", "--log_properties", customLogProperty.getAbsolutePath(), "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        Log LOG_Client = LogFactory.getLog(Client.class);
        Assert.assertTrue((boolean)LOG_Client.isInfoEnabled());
        Assert.assertFalse((boolean)LOG_Client.isDebugEnabled());
        Log LOG_AM = LogFactory.getLog(ApplicationMaster.class);
        Assert.assertTrue((boolean)LOG_AM.isInfoEnabled());
        Assert.assertFalse((boolean)LOG_AM.isDebugEnabled());
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertTrue((this.verifyContainerLog(3, null, true, "DEBUG") > 10 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)LOG_Client.isInfoEnabled());
        Assert.assertTrue((boolean)LOG_Client.isDebugEnabled());
        Assert.assertTrue((boolean)LOG_AM.isInfoEnabled());
        Assert.assertTrue((boolean)LOG_AM.isDebugEnabled());
    }

    public void testDSShellWithCommands() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", "\"echo output_ignored;echo output_expected\"", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        ArrayList<String> expectedContent = new ArrayList<String>();
        expectedContent.add("output_expected");
        this.verifyContainerLog(2, expectedContent, false, "");
    }

    @Test
    public void testDSShellWithMultipleArgs() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "4", "--shell_command", "echo", "--shell_args", "HADOOP YARN MAPREDUCE HDFS", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        ArrayList<String> expectedContent = new ArrayList<String>();
        expectedContent.add("HADOOP YARN MAPREDUCE HDFS");
        this.verifyContainerLog(4, expectedContent, false, "");
    }

    @Test
    public void testDSShellWithShellScript() throws Exception {
        File basedir = new File("target", TestDistributedShell.class.getName());
        File tmpDir = new File(basedir, "tmpDir");
        tmpDir.mkdirs();
        File customShellScript = new File(tmpDir, "custom_script.sh");
        if (customShellScript.exists()) {
            customShellScript.delete();
        }
        if (!customShellScript.createNewFile()) {
            Assert.fail((String)"Can not create custom shell script file.");
        }
        PrintWriter fileWriter = new PrintWriter(customShellScript);
        fileWriter.write("echo testDSShellWithShellScript");
        fileWriter.close();
        System.out.println(customShellScript.getAbsolutePath());
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "1", "--shell_script", customShellScript.getAbsolutePath(), "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        ArrayList<String> expectedContent = new ArrayList<String>();
        expectedContent.add("testDSShellWithShellScript");
        this.verifyContainerLog(1, expectedContent, false, "");
    }

    @Test
    public void testDSShellWithInvalidArgs() throws Exception {
        String[] args;
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        LOG.info((Object)"Initializing DS Client with no args");
        try {
            client.init(new String[0]);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No args"));
        }
        LOG.info((Object)"Initializing DS Client with no jar file");
        try {
            args = new String[]{"--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No jar"));
        }
        LOG.info((Object)"Initializing DS Client with no shell command");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No shell command"));
        }
        LOG.info((Object)"Initializing DS Client with invalid no. of containers");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "-1", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("Invalid no. of containers"));
        }
        LOG.info((Object)"Initializing DS Client with invalid no. of vcores");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "-2", "--container_memory", "128", "--container_vcores", "1"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("Invalid virtual cores specified"));
        }
        LOG.info((Object)"Initializing DS Client with --shell_command and --shell_script");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1", "--shell_script", "test.sh"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("Can not specify shell_command option and shell_script option at the same time"));
        }
        LOG.info((Object)"Initializing DS Client without --shell_command and --shell_script");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No shell command or shell script specified to be executed by application master"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDSTimelineClientWithConnectionRefuse() throws Exception {
        ApplicationMaster am = new ApplicationMaster();
        2 client = new /* Unavailable Anonymous Inner Class!! */;
        client.init((Configuration)this.conf);
        client.start();
        TestTimelineClient.mockEntityClientResponse((TimelineWriter)this.spyTimelineWriter, null, (boolean)false, (boolean)true);
        try {
            UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)ugi.getShortUserName()).thenReturn((Object)"user1");
            am.publishContainerEndEvent((TimelineClient)client, ContainerStatus.newInstance((ContainerId)BuilderUtils.newContainerId((int)1, (int)1, (long)1L, (long)1L), (ContainerState)ContainerState.COMPLETE, (String)"", (int)1), "domainId", ugi);
        }
        finally {
            client.stop();
        }
    }

    protected void waitForNMsToRegister() throws Exception {
        for (int sec = 60; sec >= 0 && this.yarnCluster.getResourceManager().getRMContext().getRMNodes().size() < 1; --sec) {
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testContainerLaunchFailureHandling() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(ContainerLaunchFailAppMaster.class.getName(), new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testDebugFlag() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1", "--debug"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        Assert.assertTrue((boolean)client.init(args));
        LOG.info((Object)"Running DS Client");
        Assert.assertTrue((boolean)client.run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyContainerLog(int containerNum, List<String> expectedContent, boolean count, String expectedWord) {
        File logFolder = new File(this.yarnCluster.getNodeManager(0).getConfig().get("yarn.nodemanager.log-dirs", "/tmp/logs"));
        File[] listOfFiles = logFolder.listFiles();
        int currentContainerLogFileIndex = -1;
        for (int i = listOfFiles.length - 1; i >= 0; --i) {
            if (listOfFiles[i].listFiles().length != containerNum + 1) continue;
            currentContainerLogFileIndex = i;
            break;
        }
        Assert.assertTrue((currentContainerLogFileIndex != -1 ? 1 : 0) != 0);
        File[] containerFiles = listOfFiles[currentContainerLogFileIndex].listFiles();
        int numOfWords = 0;
        for (int i = 0; i < containerFiles.length; ++i) {
            for (File output : containerFiles[i].listFiles()) {
                if (!output.getName().trim().contains("stdout")) continue;
                BufferedReader br = null;
                ArrayList<String> stdOutContent = new ArrayList<String>();
                try {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(output));
                    int numOfline = 0;
                    while ((sCurrentLine = br.readLine()) != null) {
                        if (count) {
                            if (!sCurrentLine.contains(expectedWord)) continue;
                            ++numOfWords;
                            continue;
                        }
                        if (!output.getName().trim().equals("stdout")) continue;
                        if (!Shell.WINDOWS) {
                            Assert.assertEquals((String)("The current is" + sCurrentLine), (Object)expectedContent.get(numOfline), (Object)sCurrentLine.trim());
                            ++numOfline;
                            continue;
                        }
                        stdOutContent.add(sCurrentLine.trim());
                    }
                    if (!Shell.WINDOWS || count || !output.getName().trim().equals("stdout")) continue;
                    Assert.assertTrue((boolean)stdOutContent.containsAll(expectedContent));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return numOfWords;
    }

    static /* synthetic */ TimelineWriter access$002(TestDistributedShell x0, TimelineWriter x1) {
        x0.spyTimelineWriter = x1;
        return x0.spyTimelineWriter;
    }

    static /* synthetic */ TimelineWriter access$000(TestDistributedShell x0) {
        return x0.spyTimelineWriter;
    }
}

