/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.YarnClient;
import org.apache.hadoop.yarn.client.cli.ApplicationCLI;
import org.apache.hadoop.yarn.client.cli.NodeCLI;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestYarnCLI {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private YarnClient client = (YarnClient)Mockito.mock(YarnClient.class);
    ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;

    @Before
    public void setup() {
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysOutStream));
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysErrStream));
    }

    @Test
    public void testGetApplicationReport() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)1234L, (int)5);
        ApplicationReport newApplicationReport = BuilderUtils.newApplicationReport((ApplicationId)applicationId, (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A");
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)newApplicationReport);
        int result = cli.run(new String[]{"-status", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplicationReport(applicationId);
        String appReportStr = "Application Report : \n\tApplication-Id : application_1234_0005\n\tApplication-Name : appname\n\tUser : user\n\tQueue : queue\n\tStart-Time : 0\n\tFinish-Time : 0\n\tState : FINISHED\n\tFinal-State : SUCCEEDED\n\tTracking-URL : N/A\n\tDiagnostics : diagnostics\n";
        junit.framework.Assert.assertEquals((String)appReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
    }

    @Test
    public void testGetAllApplications() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)1234L, (int)5);
        ApplicationReport newApplicationReport = BuilderUtils.newApplicationReport((ApplicationId)applicationId, (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A");
        ArrayList<ApplicationReport> applicationReports = new ArrayList<ApplicationReport>();
        applicationReports.add(newApplicationReport);
        Mockito.when((Object)this.client.getApplicationList()).thenReturn(applicationReports);
        int result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplicationList();
        StringBuffer appsReportStrBuf = new StringBuffer();
        appsReportStrBuf.append("Total Applications:1\n");
        appsReportStrBuf.append("                Application-Id\t    Application-Name\t      User\t     Queue\t             State\t       Final-State\t                       Tracking-URL\n");
        appsReportStrBuf.append("         application_1234_0005\t             appname\t      user\t     queue\t          FINISHED\t         SUCCEEDED\t                                N/A\n");
        junit.framework.Assert.assertEquals((String)appsReportStrBuf.toString(), (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testKillApplication() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)1234L, (int)5);
        int result = cli.run(new String[]{"-kill", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).killApplication((ApplicationId)Matchers.any(ApplicationId.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Killing application application_1234_0005");
    }

    @Test
    public void testListClusterNodes() throws Exception {
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports()).thenReturn((Object)this.getNodeReports(3));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        int result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports();
        StringBuffer nodesReportStr = new StringBuffer();
        nodesReportStr.append("Total Nodes:3");
        nodesReportStr.append("\n         Node-Id\tNode-Http-Address\tHealth-Status(isNodeHealthy)\tRunning-Containers");
        nodesReportStr.append("\n         host0:0\t       host1:8888\t                     false\t                 0");
        nodesReportStr.append("\n         host1:0\t       host1:8888\t                     false\t                 0");
        nodesReportStr.append("\n         host2:0\t       host1:8888\t                     false\t                 0\n");
        junit.framework.Assert.assertEquals((String)nodesReportStr.toString(), (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testNodeStatus() throws Exception {
        NodeId nodeId = BuilderUtils.newNodeId((String)"host0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports()).thenReturn((Object)this.getNodeReports(3));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports();
        String nodeStatusStr = "Node Report : \n\tNode-Id : host0:0\n\tRack : rack1\n\tNode-Http-Address : host1:8888\n\tHealth-Status(isNodeHealthy) : false\n\tLast-Last-Health-Update : 0\n\tHealth-Report : null\n\tContainers : 0\n\tMemory-Used : 0M\n\tMemory-Capacity : 0";
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println(nodeStatusStr);
    }

    @Test
    public void testAbsentNodeStatus() throws Exception {
        NodeId nodeId = BuilderUtils.newNodeId((String)"Absenthost0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports()).thenReturn((Object)this.getNodeReports(0));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports();
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Could not find the node report for node id : " + nodeId.toString());
    }

    @Test
    public void testAppCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new ApplicationCLI());
    }

    @Test
    public void testNodeCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new NodeCLI());
    }

    private void verifyUsageInfo(YarnCLI cli) throws Exception {
        cli.setSysErrPrintStream(this.sysErr);
        cli.run(new String[0]);
        ((PrintStream)Mockito.verify((Object)this.sysErr)).println("Invalid Command Usage : ");
    }

    private List<NodeReport> getNodeReports(int noOfNodes) {
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>();
        for (int i = 0; i < noOfNodes; ++i) {
            NodeReport nodeReport = TestYarnCLI.newNodeReport((NodeId)BuilderUtils.newNodeId((String)("host" + i), (int)0), (String)"host1:8888", (String)"rack1", (Resource)((Resource)Records.newRecord(Resource.class)), (Resource)((Resource)Records.newRecord(Resource.class)), (int)0, (NodeHealthStatus)((NodeHealthStatus)Records.newRecord(NodeHealthStatus.class)));
            nodeReports.add(nodeReport);
        }
        return nodeReports;
    }

    private static NodeReport newNodeReport(NodeId nodeId, String httpAddress, String rackName, Resource used, Resource capability, int numContainers, NodeHealthStatus nodeHealthStatus) {
        NodeReport nodeReport = (NodeReport)recordFactory.newRecordInstance(NodeReport.class);
        nodeReport.setNodeId(nodeId);
        nodeReport.setHttpAddress(httpAddress);
        nodeReport.setRackName(rackName);
        nodeReport.setUsed(used);
        nodeReport.setCapability(capability);
        nodeReport.setNumContainers(numContainers);
        nodeReport.setNodeHealthStatus(nodeHealthStatus);
        return nodeReport;
    }

    private ApplicationCLI createAndGetAppCLI() {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        return cli;
    }
}

