/*
 * Decompiled with CFR 0.152.
 */
package org.hadoop.yarn.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.Records;
import org.hadoop.yarn.client.YarnClient;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public class YarnClientImpl
extends AbstractService
implements YarnClient {
    private static final Log LOG = LogFactory.getLog(YarnClientImpl.class);
    protected ClientRMProtocol rmClient;
    protected InetSocketAddress rmAddress;
    private static final String ROOT = "root";

    public YarnClientImpl() {
        super(YarnClientImpl.class.getName());
    }

    private static InetSocketAddress getRmAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public synchronized void init(Configuration conf) {
        this.rmAddress = YarnClientImpl.getRmAddress((Configuration)conf);
        super.init(conf);
    }

    public synchronized void start() {
        YarnRPC rpc = YarnRPC.create((Configuration)this.getConfig());
        this.rmClient = (ClientRMProtocol)rpc.getProxy(ClientRMProtocol.class, this.rmAddress, this.getConfig());
        LOG.debug((Object)("Connecting to ResourceManager at " + this.rmAddress));
        super.start();
    }

    public synchronized void stop() {
        RPC.stopProxy((Object)this.rmClient);
        super.stop();
    }

    public GetNewApplicationResponse getNewApplication() throws YarnRemoteException {
        GetNewApplicationRequest request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        return this.rmClient.getNewApplication(request);
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnRemoteException {
        ApplicationId applicationId = appContext.getApplicationId();
        appContext.setApplicationId(applicationId);
        SubmitApplicationRequest request = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        request.setApplicationSubmissionContext(appContext);
        this.rmClient.submitApplication(request);
        LOG.info((Object)("Submitted application " + applicationId + " to ResourceManager" + " at " + this.rmAddress));
        return applicationId;
    }

    public void killApplication(ApplicationId applicationId) throws YarnRemoteException {
        LOG.info((Object)("Killing application " + applicationId));
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(applicationId);
        this.rmClient.forceKillApplication(request);
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnRemoteException {
        GetApplicationReportRequest request = (GetApplicationReportRequest)Records.newRecord(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        GetApplicationReportResponse response = this.rmClient.getApplicationReport(request);
        return response.getApplicationReport();
    }

    public List<ApplicationReport> getApplicationList() throws YarnRemoteException {
        GetAllApplicationsRequest request = (GetAllApplicationsRequest)Records.newRecord(GetAllApplicationsRequest.class);
        GetAllApplicationsResponse response = this.rmClient.getAllApplications(request);
        return response.getApplicationList();
    }

    public YarnClusterMetrics getYarnClusterMetrics() throws YarnRemoteException {
        GetClusterMetricsRequest request = (GetClusterMetricsRequest)Records.newRecord(GetClusterMetricsRequest.class);
        GetClusterMetricsResponse response = this.rmClient.getClusterMetrics(request);
        return response.getClusterMetrics();
    }

    public List<NodeReport> getNodeReports() throws YarnRemoteException {
        GetClusterNodesRequest request = (GetClusterNodesRequest)Records.newRecord(GetClusterNodesRequest.class);
        GetClusterNodesResponse response = this.rmClient.getClusterNodes(request);
        return response.getNodeReports();
    }

    public DelegationToken getRMDelegationToken(Text renewer) throws YarnRemoteException {
        GetDelegationTokenRequest rmDTRequest = (GetDelegationTokenRequest)Records.newRecord(GetDelegationTokenRequest.class);
        rmDTRequest.setRenewer(renewer.toString());
        GetDelegationTokenResponse response = this.rmClient.getDelegationToken(rmDTRequest);
        return response.getRMDelegationToken();
    }

    private GetQueueInfoRequest getQueueInfoRequest(String queueName, boolean includeApplications, boolean includeChildQueues, boolean recursive) {
        GetQueueInfoRequest request = (GetQueueInfoRequest)Records.newRecord(GetQueueInfoRequest.class);
        request.setQueueName(queueName);
        request.setIncludeApplications(includeApplications);
        request.setIncludeChildQueues(includeChildQueues);
        request.setRecursive(recursive);
        return request;
    }

    public QueueInfo getQueueInfo(String queueName) throws YarnRemoteException {
        GetQueueInfoRequest request = this.getQueueInfoRequest(queueName, true, false, false);
        Records.newRecord(GetQueueInfoRequest.class);
        return this.rmClient.getQueueInfo(request).getQueueInfo();
    }

    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnRemoteException {
        GetQueueUserAclsInfoRequest request = (GetQueueUserAclsInfoRequest)Records.newRecord(GetQueueUserAclsInfoRequest.class);
        return this.rmClient.getQueueUserAcls(request).getUserAclsInfoList();
    }

    public List<QueueInfo> getAllQueues() throws YarnRemoteException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest("root", false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, true);
        return queues;
    }

    public List<QueueInfo> getRootQueueInfos() throws YarnRemoteException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest("root", false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, false);
        return queues;
    }

    public List<QueueInfo> getChildQueueInfos(String parent) throws YarnRemoteException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo parentQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(parent, false, true, false)).getQueueInfo();
        this.getChildQueues(parentQueue, queues, true);
        return queues;
    }

    private void getChildQueues(QueueInfo parent, List<QueueInfo> queues, boolean recursive) {
        List childQueues = parent.getChildQueues();
        for (QueueInfo child : childQueues) {
            queues.add(child);
            if (!recursive) continue;
            this.getChildQueues(child, queues, recursive);
        }
    }
}

