/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ApplicationCLI
extends YarnCLI {
    private static final String APPLICATIONS_PATTERN = "%30s\t%20s\t%10s\t%10s\t%18s\t%18s\t%35s\n";

    public static void main(String[] args) throws Exception {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])args);
        cli.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("status", true, "Prints the status of the application.");
        opts.addOption("list", false, "Lists all the Applications from RM.");
        opts.addOption("kill", true, "Kills the application.");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        int exitCode = -1;
        if (cliParser.hasOption("status")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.printApplicationReport(cliParser.getOptionValue("status"));
        } else if (cliParser.hasOption("list")) {
            this.listAllApplications();
        } else if (cliParser.hasOption("kill")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.killApplication(cliParser.getOptionValue("kill"));
        } else {
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(opts);
        }
        return 0;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("application", opts);
    }

    private void listAllApplications() throws YarnRemoteException {
        PrintWriter writer = new PrintWriter(this.sysout);
        List appsReport = this.client.getApplicationList();
        writer.println("Total Applications:" + appsReport.size());
        writer.printf(APPLICATIONS_PATTERN, "Application-Id", "Application-Name", "User", "Queue", "State", "Final-State", "Tracking-URL");
        for (ApplicationReport appReport : appsReport) {
            writer.printf(APPLICATIONS_PATTERN, appReport.getApplicationId(), appReport.getName(), appReport.getUser(), appReport.getQueue(), appReport.getYarnApplicationState(), appReport.getFinalApplicationStatus(), appReport.getOriginalTrackingUrl());
        }
        writer.flush();
    }

    private void killApplication(String applicationId) throws YarnRemoteException {
        ApplicationId appId = ConverterUtils.toApplicationId((String)applicationId);
        this.sysout.println("Killing application " + applicationId);
        this.client.killApplication(appId);
    }

    private void printApplicationReport(String applicationId) throws YarnRemoteException {
        ApplicationReport appReport = this.client.getApplicationReport(ConverterUtils.toApplicationId((String)applicationId));
        StringBuffer appReportStr = new StringBuffer();
        if (appReport != null) {
            appReportStr.append("Application Report : ");
            appReportStr.append("\n\tApplication-Id : ");
            appReportStr.append(appReport.getApplicationId());
            appReportStr.append("\n\tApplication-Name : ");
            appReportStr.append(appReport.getName());
            appReportStr.append("\n\tUser : ");
            appReportStr.append(appReport.getUser());
            appReportStr.append("\n\tQueue : ");
            appReportStr.append(appReport.getQueue());
            appReportStr.append("\n\tStart-Time : ");
            appReportStr.append(appReport.getStartTime());
            appReportStr.append("\n\tFinish-Time : ");
            appReportStr.append(appReport.getFinishTime());
            appReportStr.append("\n\tState : ");
            appReportStr.append(appReport.getYarnApplicationState());
            appReportStr.append("\n\tFinal-State : ");
            appReportStr.append(appReport.getFinalApplicationStatus());
            appReportStr.append("\n\tTracking-URL : ");
            appReportStr.append(appReport.getOriginalTrackingUrl());
            appReportStr.append("\n\tDiagnostics : ");
            appReportStr.append(appReport.getDiagnostics());
        } else {
            appReportStr.append("Application with id '" + applicationId + "' doesn't exist in RM.");
        }
        this.sysout.println(appReportStr.toString());
    }
}

