/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.AMRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.AMResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.AMRMClient;
import org.apache.hadoop.yarn.client.AMRMClientImpl;
import org.apache.hadoop.yarn.client.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestAMRMClient {
    Configuration conf = null;
    MiniYARNCluster yarnCluster = null;
    YarnClientImpl yarnClient = null;
    List<NodeReport> nodeReports = null;
    ApplicationAttemptId attemptId = null;
    int nodeCount = 3;

    @Before
    public void setup() throws YarnRemoteException {
        ApplicationReport appReport;
        this.conf = new YarnConfiguration();
        this.yarnCluster = new MiniYARNCluster(TestAMRMClient.class.getName(), this.nodeCount, 1, 1);
        this.yarnCluster.init(this.conf);
        this.yarnCluster.start();
        this.yarnClient = new YarnClientImpl();
        this.yarnClient.init(this.conf);
        this.yarnClient.start();
        this.nodeReports = this.yarnClient.getNodeReports();
        GetNewApplicationResponse newApp = this.yarnClient.getNewApplication();
        ApplicationId appId = newApp.getApplicationId();
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appContext.setApplicationId(appId);
        appContext.setApplicationName("Test");
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(0);
        appContext.setPriority(pri);
        appContext.setQueue("default");
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        appContext.setAMContainerSpec(amContainer);
        appContext.setUnmanagedAM(true);
        SubmitApplicationRequest appRequest = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        appRequest.setApplicationSubmissionContext(appContext);
        this.yarnClient.submitApplication(appContext);
        while ((appReport = this.yarnClient.getApplicationReport(appId)).getYarnApplicationState() != YarnApplicationState.ACCEPTED) {
        }
        this.attemptId = appReport.getCurrentApplicationAttemptId();
    }

    @After
    public void tearDown() {
        if (this.yarnClient != null && this.yarnClient.getServiceState() == Service.STATE.STARTED) {
            this.yarnClient.stop();
        }
        if (this.yarnCluster != null && this.yarnCluster.getServiceState() == Service.STATE.STARTED) {
            this.yarnCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAMRMClient() throws YarnRemoteException {
        AMRMClientImpl amClient = null;
        try {
            amClient = new AMRMClientImpl(this.attemptId);
            amClient.init(this.conf);
            amClient.start();
            amClient.registerApplicationMaster("Host", 10000, "");
            this.testAllocation(amClient);
            amClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        }
        finally {
            if (amClient != null && amClient.getServiceState() == Service.STATE.STARTED) {
                amClient.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAllocation(AMRMClientImpl amClient) throws YarnRemoteException {
        Resource capability = (Resource)Records.newRecord(Resource.class);
        Priority priority = (Priority)Records.newRecord(Priority.class);
        priority.setPriority(0);
        capability.setMemory(1024);
        String node = ((NodeReport)this.nodeReports.get(0)).getNodeId().getHost();
        String rack = ((NodeReport)this.nodeReports.get(0)).getRackName();
        String[] nodes = new String[]{node};
        String[] racks = new String[]{rack};
        Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority, 1));
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority, 3));
        amClient.removeContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority, 2));
        int containersRequestedNode = ((ResourceRequest)((Map)((Map)amClient.remoteRequestsTable.get(priority)).get(node)).get(capability)).getNumContainers();
        int containersRequestedRack = ((ResourceRequest)((Map)((Map)amClient.remoteRequestsTable.get(priority)).get(rack)).get(capability)).getNumContainers();
        int containersRequestedAny = ((ResourceRequest)((Map)((Map)amClient.remoteRequestsTable.get(priority)).get("*")).get(capability)).getNumContainers();
        Assert.assertTrue((containersRequestedNode == 2 ? 1 : 0) != 0);
        Assert.assertTrue((containersRequestedRack == 2 ? 1 : 0) != 0);
        Assert.assertTrue((containersRequestedAny == 2 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.ask.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
        int allocatedContainerCount = 0;
        int iterationsLeft = 2;
        TreeSet<ContainerId> releases = new TreeSet<ContainerId>();
        while (allocatedContainerCount < containersRequestedAny && iterationsLeft-- > 0) {
            AllocateResponse allocResponse = amClient.allocate(0.1f);
            Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.nodeCount == amClient.getClusterNodeCount() ? 1 : 0) != 0);
            AMResponse amResponse = allocResponse.getAMResponse();
            allocatedContainerCount += amResponse.getAllocatedContainers().size();
            for (Container container : amResponse.getAllocatedContainers()) {
                ContainerId rejectContainerId = container.getId();
                releases.add(rejectContainerId);
                amClient.releaseAssignedContainer(rejectContainerId);
            }
            if (allocatedContainerCount >= containersRequestedAny) continue;
            this.sleep(1000);
        }
        Assert.assertTrue((allocatedContainerCount == containersRequestedAny ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
        amClient.removeContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority, 2));
        Assert.assertTrue((amClient.ask.size() == 3 ? 1 : 0) != 0);
        ResourceRequest snoopRequest = (ResourceRequest)amClient.ask.iterator().next();
        Assert.assertTrue((snoopRequest.getNumContainers() == 0 ? 1 : 0) != 0);
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority, 2));
        snoopRequest = (ResourceRequest)amClient.ask.iterator().next();
        Assert.assertTrue((snoopRequest.getNumContainers() == 2 ? 1 : 0) != 0);
        AMRMProtocol realRM = amClient.rmClient;
        try {
            AMRMProtocol mockRM = (AMRMProtocol)Mockito.mock(AMRMProtocol.class);
            Mockito.when((Object)mockRM.allocate((AllocateRequest)Mockito.any(AllocateRequest.class))).thenAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */);
            amClient.rmClient = mockRM;
            amClient.allocate(0.1f);
        }
        catch (Exception ioe) {
        }
        finally {
            amClient.rmClient = realRM;
        }
        Assert.assertTrue((amClient.release.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.ask.size() == 3 ? 1 : 0) != 0);
        snoopRequest = (ResourceRequest)amClient.ask.iterator().next();
        Assert.assertTrue((snoopRequest.getNumContainers() == 0 ? 1 : 0) != 0);
        iterationsLeft = 2;
        while (!releases.isEmpty() || iterationsLeft-- > 0) {
            AllocateResponse allocResponse = amClient.allocate(0.1f);
            AMResponse amResponse = allocResponse.getAMResponse();
            Assert.assertTrue((amResponse.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
            if (amResponse.getCompletedContainersStatuses().size() > 0) {
                for (ContainerStatus cStatus : amResponse.getCompletedContainersStatuses()) {
                    if (!releases.contains(cStatus.getContainerId())) continue;
                    Assert.assertTrue((cStatus.getState() == ContainerState.COMPLETE ? 1 : 0) != 0);
                    Assert.assertTrue((cStatus.getExitStatus() == -100 ? 1 : 0) != 0);
                    releases.remove(cStatus.getContainerId());
                }
            }
            if (iterationsLeft <= 0) continue;
            this.sleep(1000);
        }
        Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
    }

    private void sleep(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

