/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.YarnClient;
import org.apache.hadoop.yarn.client.cli.ApplicationCLI;
import org.apache.hadoop.yarn.client.cli.NodeCLI;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestYarnCLI {
    private YarnClient client = (YarnClient)Mockito.mock(YarnClient.class);
    ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;

    @Before
    public void setup() {
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysOutStream));
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysErrStream));
    }

    @Test
    public void testGetApplicationReport() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)1234L, (int)5);
        ApplicationReport newApplicationReport = BuilderUtils.newApplicationReport((ApplicationId)applicationId, (ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A");
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)newApplicationReport);
        int result = cli.run(new String[]{"-status", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplicationReport(applicationId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Application Report : ");
        pw.println("\tApplication-Id : application_1234_0005");
        pw.println("\tApplication-Name : appname");
        pw.println("\tUser : user");
        pw.println("\tQueue : queue");
        pw.println("\tStart-Time : 0");
        pw.println("\tFinish-Time : 0");
        pw.println("\tState : FINISHED");
        pw.println("\tFinal-State : SUCCEEDED");
        pw.println("\tTracking-URL : N/A");
        pw.println("\tDiagnostics : diagnostics");
        pw.close();
        String appReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
    }

    @Test
    public void testGetAllApplications() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)1234L, (int)5);
        ApplicationReport newApplicationReport = BuilderUtils.newApplicationReport((ApplicationId)applicationId, (ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A");
        ArrayList<ApplicationReport> applicationReports = new ArrayList<ApplicationReport>();
        applicationReports.add(newApplicationReport);
        Mockito.when((Object)this.client.getApplicationList()).thenReturn(applicationReports);
        int result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplicationList();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Total Applications:1");
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.println("Final-State\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t      user\t     queue\t          FINISHED\t         ");
        pw.println("SUCCEEDED\t                                N/A");
        pw.close();
        String appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testKillApplication() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)1234L, (int)5);
        int result = cli.run(new String[]{"-kill", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).killApplication((ApplicationId)Matchers.any(ApplicationId.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Killing application application_1234_0005");
    }

    @Test
    public void testListClusterNodes() throws Exception {
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports()).thenReturn((Object)this.getNodeReports(3));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        int result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Total Nodes:3");
        pw.print("         Node-Id\tNode-State\tNode-Http-Address\t");
        pw.println("Health-Status(isNodeHealthy)\tRunning-Containers");
        pw.print("         host0:0\t   RUNNING\t       host1:8888");
        pw.println("\t                     false\t                 0");
        pw.print("         host1:0\t   RUNNING\t       host1:8888");
        pw.println("\t                     false\t                 0");
        pw.print("         host2:0\t   RUNNING\t       host1:8888");
        pw.println("\t                     false\t                 0");
        pw.close();
        String nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testNodeStatus() throws Exception {
        NodeId nodeId = BuilderUtils.newNodeId((String)"host0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports()).thenReturn((Object)this.getNodeReports(3));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Node Report : ");
        pw.println("\tNode-Id : host0:0");
        pw.println("\tRack : rack1");
        pw.println("\tNode-State : RUNNING");
        pw.println("\tNode-Http-Address : host1:8888");
        pw.println("\tHealth-Status(isNodeHealthy) : false");
        pw.println("\tLast-Health-Update : " + DateFormatUtils.format((Date)new Date(0L), (String)"E dd/MMM/yy hh:mm:ss:SSzz"));
        pw.println("\tHealth-Report : null");
        pw.println("\tContainers : 0");
        pw.println("\tMemory-Used : 0M");
        pw.println("\tMemory-Capacity : 0");
        pw.close();
        String nodeStatusStr = baos.toString("UTF-8");
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println(nodeStatusStr);
    }

    @Test
    public void testAbsentNodeStatus() throws Exception {
        NodeId nodeId = BuilderUtils.newNodeId((String)"Absenthost0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports()).thenReturn((Object)this.getNodeReports(0));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports();
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Could not find the node report for node id : " + nodeId.toString());
    }

    @Test
    public void testAppCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new ApplicationCLI());
    }

    @Test
    public void testNodeCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new NodeCLI());
    }

    private void verifyUsageInfo(YarnCLI cli) throws Exception {
        cli.setSysErrPrintStream(this.sysErr);
        cli.run(new String[0]);
        ((PrintStream)Mockito.verify((Object)this.sysErr)).println("Invalid Command Usage : ");
    }

    private List<NodeReport> getNodeReports(int noOfNodes) {
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>();
        for (int i = 0; i < noOfNodes; ++i) {
            NodeReport nodeReport = BuilderUtils.newNodeReport((NodeId)BuilderUtils.newNodeId((String)("host" + i), (int)0), (NodeState)NodeState.RUNNING, (String)"host1:8888", (String)"rack1", (Resource)((Resource)Records.newRecord(Resource.class)), (Resource)((Resource)Records.newRecord(Resource.class)), (int)0, (NodeHealthStatus)((NodeHealthStatus)Records.newRecord(NodeHealthStatus.class)));
            nodeReports.add(nodeReport);
        }
        return nodeReports;
    }

    private ApplicationCLI createAndGetAppCLI() {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        return cli;
    }
}

