/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Token;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class NMTokenCache {
    private static ConcurrentHashMap<String, Token> nmTokens = new ConcurrentHashMap();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static Token getNMToken(String nodeAddr) {
        return (Token)nmTokens.get(nodeAddr);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void setNMToken(String nodeAddr, Token token) {
        nmTokens.put(nodeAddr, token);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static boolean containsNMToken(String nodeAddr) {
        return nmTokens.containsKey(nodeAddr);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static int numberOfNMTokensInCache() {
        return nmTokens.size();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void removeNMToken(String nodeAddr) {
        nmTokens.remove(nodeAddr);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void clearCache() {
        nmTokens.clear();
    }
}

