/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CyclicBarrier;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.async.impl.TestNMClientAsync;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.junit.After;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestNMClientAsync {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private NMClientAsyncImpl asyncClient;
    private NodeId nodeId;
    private Token containerToken;

    @After
    public void teardown() {
        ServiceOperations.stop((Service)this.asyncClient);
    }

    @Test(timeout=10000L)
    public void testNMClientAsync() throws Exception {
        ContainerLaunchContext clc;
        Container container;
        int i;
        Configuration conf = new Configuration();
        conf.setInt("yarn.client.nodemanager-client-async.thread-pool-max-size", 10);
        int expectedSuccess = 40;
        int expectedFailure = 40;
        this.asyncClient = new MockNMClientAsync1(this, expectedSuccess, expectedFailure);
        this.asyncClient.init(conf);
        Assert.assertEquals((String)"The max thread pool size is not correctly set", (int)10, (int)this.asyncClient.maxThreadPoolSize);
        this.asyncClient.start();
        for (i = 0; i < expectedSuccess + expectedFailure; ++i) {
            if (i == expectedSuccess) {
                while (!((TestCallbackHandler1)this.asyncClient.getCallbackHandler()).isAllSuccessCallsExecuted()) {
                    Thread.sleep(10L);
                }
                this.asyncClient.setClient(this.mockNMClient(1));
            }
            container = this.mockContainer(i);
            clc = (ContainerLaunchContext)this.recordFactory.newRecordInstance(ContainerLaunchContext.class);
            this.asyncClient.startContainerAsync(container, clc);
        }
        while (!((TestCallbackHandler1)this.asyncClient.getCallbackHandler()).isStartAndQueryFailureCallsExecuted()) {
            Thread.sleep(10L);
        }
        this.asyncClient.setClient(this.mockNMClient(2));
        TestCallbackHandler1.access$002((TestCallbackHandler1)((TestCallbackHandler1)this.asyncClient.getCallbackHandler()), (boolean)false);
        for (i = 0; i < expectedFailure; ++i) {
            container = this.mockContainer(expectedSuccess + expectedFailure + i);
            clc = (ContainerLaunchContext)this.recordFactory.newRecordInstance(ContainerLaunchContext.class);
            this.asyncClient.startContainerAsync(container, clc);
        }
        while (!((TestCallbackHandler1)this.asyncClient.getCallbackHandler()).isStopFailureCallsExecuted()) {
            Thread.sleep(10L);
        }
        for (String errorMsg : TestCallbackHandler1.access$100((TestCallbackHandler1)((TestCallbackHandler1)this.asyncClient.getCallbackHandler()))) {
            System.out.println(errorMsg);
        }
        Assert.assertEquals((String)"Error occurs in CallbackHandler", (int)0, (int)TestCallbackHandler1.access$100((TestCallbackHandler1)((TestCallbackHandler1)this.asyncClient.getCallbackHandler())).size());
        for (String errorMsg : MockNMClientAsync1.access$200((MockNMClientAsync1)((MockNMClientAsync1)this.asyncClient))) {
            System.out.println(errorMsg);
        }
        Assert.assertEquals((String)"Error occurs in ContainerEventProcessor", (int)0, (int)MockNMClientAsync1.access$200((MockNMClientAsync1)((MockNMClientAsync1)this.asyncClient)).size());
        while (this.asyncClient.containers.size() > 0) {
            Thread.sleep(10L);
        }
        this.asyncClient.stop();
        Assert.assertFalse((String)"The thread of Container Management Event Dispatcher is still alive", (boolean)this.asyncClient.eventDispatcherThread.isAlive());
        Assert.assertTrue((String)"The thread pool is not shut down", (boolean)this.asyncClient.threadPool.isShutdown());
    }

    private NMClient mockNMClient(int mode) throws YarnException, IOException {
        NMClient client = (NMClient)Mockito.mock(NMClient.class);
        switch (mode) {
            case 0: {
                Mockito.when((Object)client.startContainer((Container)Matchers.any(Container.class), (ContainerLaunchContext)Matchers.any(ContainerLaunchContext.class))).thenReturn(Collections.emptyMap());
                Mockito.when((Object)client.getContainerStatus((ContainerId)Matchers.any(ContainerId.class), (NodeId)Matchers.any(NodeId.class))).thenReturn(this.recordFactory.newRecordInstance(ContainerStatus.class));
                ((NMClient)Mockito.doNothing().when((Object)client)).stopContainer((ContainerId)Matchers.any(ContainerId.class), (NodeId)Matchers.any(NodeId.class));
                break;
            }
            case 1: {
                ((NMClient)Mockito.doThrow((Throwable)RPCUtil.getRemoteException((String)"Start Exception")).when((Object)client)).startContainer((Container)Matchers.any(Container.class), (ContainerLaunchContext)Matchers.any(ContainerLaunchContext.class));
                ((NMClient)Mockito.doThrow((Throwable)RPCUtil.getRemoteException((String)"Query Exception")).when((Object)client)).getContainerStatus((ContainerId)Matchers.any(ContainerId.class), (NodeId)Matchers.any(NodeId.class));
                ((NMClient)Mockito.doThrow((Throwable)RPCUtil.getRemoteException((String)"Stop Exception")).when((Object)client)).stopContainer((ContainerId)Matchers.any(ContainerId.class), (NodeId)Matchers.any(NodeId.class));
                break;
            }
            case 2: {
                Mockito.when((Object)client.startContainer((Container)Matchers.any(Container.class), (ContainerLaunchContext)Matchers.any(ContainerLaunchContext.class))).thenReturn(Collections.emptyMap());
                Mockito.when((Object)client.getContainerStatus((ContainerId)Matchers.any(ContainerId.class), (NodeId)Matchers.any(NodeId.class))).thenReturn(this.recordFactory.newRecordInstance(ContainerStatus.class));
                ((NMClient)Mockito.doThrow((Throwable)RPCUtil.getRemoteException((String)"Stop Exception")).when((Object)client)).stopContainer((ContainerId)Matchers.any(ContainerId.class), (NodeId)Matchers.any(NodeId.class));
            }
        }
        return client;
    }

    @Test(timeout=10000L)
    public void testOutOfOrder() throws Exception {
        CyclicBarrier barrierA = new CyclicBarrier(2);
        CyclicBarrier barrierB = new CyclicBarrier(2);
        CyclicBarrier barrierC = new CyclicBarrier(2);
        this.asyncClient = new MockNMClientAsync2(this, barrierA, barrierB, barrierC);
        this.asyncClient.init(new Configuration());
        this.asyncClient.start();
        Container container = this.mockContainer(1);
        ContainerLaunchContext clc = (ContainerLaunchContext)this.recordFactory.newRecordInstance(ContainerLaunchContext.class);
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        barrierA.await();
        this.asyncClient.stopContainerAsync(container.getId(), container.getNodeId());
        barrierC.await();
        Assert.assertFalse((String)"Starting and stopping should be out of order", (boolean)TestCallbackHandler2.access$600((TestCallbackHandler2)((TestCallbackHandler2)this.asyncClient.getCallbackHandler())).get());
    }

    private Container mockContainer(int i) {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)attemptId, (int)i);
        this.nodeId = NodeId.newInstance((String)"localhost", (int)0);
        this.containerToken = (Token)this.recordFactory.newRecordInstance(Token.class);
        return Container.newInstance((ContainerId)containerId, (NodeId)this.nodeId, null, null, null, (Token)this.containerToken);
    }

    static /* synthetic */ NMClient access$300(TestNMClientAsync x0, int x1) throws YarnException, IOException {
        return x0.mockNMClient(x1);
    }

    static /* synthetic */ NodeId access$400(TestNMClientAsync x0) {
        return x0.nodeId;
    }

    static /* synthetic */ NMClientAsyncImpl access$500(TestNMClientAsync x0) {
        return x0.asyncClient;
    }
}

