/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.client.api.impl.TestYarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestYarnClient {
    @Test
    public void test() {
    }

    @Test
    public void testClientStop() {
        Configuration conf = new Configuration();
        ResourceManager rm = new ResourceManager();
        rm.init(conf);
        rm.start();
        YarnClient client = YarnClient.createYarnClient();
        client.init(conf);
        client.start();
        client.stop();
    }

    @Test(timeout=30000L)
    public void testSubmitApplication() {
        Configuration conf = new Configuration();
        conf.setLong("yarn.client.app-submission.poll-interval", 100L);
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        YarnApplicationState[] exitStates = new YarnApplicationState[]{YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING, YarnApplicationState.FINISHED, YarnApplicationState.FAILED, YarnApplicationState.KILLED};
        for (int i = 0; i < exitStates.length; ++i) {
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
            ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)i);
            Mockito.when((Object)context.getApplicationId()).thenReturn((Object)applicationId);
            client.setYarnApplicationState(exitStates[i]);
            try {
                client.submitApplication(context);
            }
            catch (YarnException e) {
                Assert.fail((String)"Exception is not expected.");
            }
            catch (IOException e) {
                Assert.fail((String)"Exception is not expected.");
            }
            ((ApplicationReport)Mockito.verify((Object)MockYarnClient.access$000((MockYarnClient)client), (VerificationMode)Mockito.times((int)(4 * i + 4)))).getYarnApplicationState();
        }
        client.stop();
    }

    @Test(timeout=30000L)
    public void testApplicationType() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        RMApp app = rm.submitApp(2000);
        RMApp app1 = rm.submitApp(200, "name", "user", new HashMap(), false, "default", -1, null, "MAPREDUCE");
        Assert.assertEquals((String)"YARN", (String)app.getApplicationType());
        Assert.assertEquals((String)"MAPREDUCE", (String)app1.getApplicationType());
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testApplicationTypeLimit() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        RMApp app1 = rm.submitApp(200, "name", "user", new HashMap(), false, "default", -1, null, "MAPREDUCE-LENGTH-IS-20");
        Assert.assertEquals((String)"MAPREDUCE-LENGTH-IS-", (String)app1.getApplicationType());
        rm.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplications() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("YARN");
        appTypes.add("NON-YARN");
        List reports = client.getApplications(appTypes);
        Assert.assertEquals((int)reports.size(), (int)2);
        Assert.assertTrue((((ApplicationReport)reports.get(0)).getApplicationType().equals("YARN") && ((ApplicationReport)reports.get(1)).getApplicationType().equals("NON-YARN") || ((ApplicationReport)reports.get(1)).getApplicationType().equals("YARN") && ((ApplicationReport)reports.get(0)).getApplicationType().equals("NON-YARN") ? 1 : 0) != 0);
        for (ApplicationReport report : reports) {
            Assert.assertTrue((boolean)expectedReports.contains(report));
        }
        reports = client.getApplications();
        Assert.assertEquals((Object)reports, (Object)expectedReports);
        client.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAMMRTokens() throws Exception {
        MiniYARNCluster cluster = new MiniYARNCluster("testMRAMTokens", 1, 1, 1);
        YarnClient rmClient = null;
        try {
            cluster.init((Configuration)new YarnConfiguration());
            cluster.start();
            Configuration yarnConf = cluster.getConfig();
            rmClient = YarnClient.createYarnClient();
            rmClient.init(yarnConf);
            rmClient.start();
            ApplicationId appId = this.createApp(rmClient, false);
            this.waitTillAccepted(rmClient, appId);
            Assert.assertNull((Object)rmClient.getAMRMToken(appId));
            appId = this.createApp(rmClient, true);
            this.waitTillAccepted(rmClient, appId);
            Assert.assertNotNull((Object)rmClient.getAMRMToken(appId));
            UserGroupInformation other = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[0]);
            appId = (ApplicationId)other.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            Assert.assertNull((Object)rmClient.getAMRMToken(appId));
        }
        finally {
            if (rmClient != null) {
                rmClient.stop();
            }
            cluster.stop();
        }
    }

    private ApplicationId createApp(YarnClient rmClient, boolean unmanaged) throws Exception {
        YarnClientApplication newApp = rmClient.createApplication();
        ApplicationId appId = newApp.getNewApplicationResponse().getApplicationId();
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appContext.setApplicationId(appId);
        appContext.setApplicationName("test");
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(1);
        appContext.setPriority(pri);
        appContext.setQueue("default");
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        appContext.setAMContainerSpec(amContainer);
        appContext.setResource(Resource.newInstance((int)1024, (int)1));
        appContext.setUnmanagedAM(unmanaged);
        rmClient.submitApplication(appContext);
        return appId;
    }

    private void waitTillAccepted(YarnClient rmClient, ApplicationId appId) throws Exception {
        try {
            long start = System.currentTimeMillis();
            ApplicationReport report = rmClient.getApplicationReport(appId);
            while (YarnApplicationState.ACCEPTED != report.getYarnApplicationState()) {
                if (System.currentTimeMillis() - start > 20000L) {
                    throw new Exception("App '" + appId + "' time out, failed to reach ACCEPTED state");
                }
                Thread.sleep(200L);
                report = rmClient.getApplicationReport(appId);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    static /* synthetic */ ApplicationId access$100(TestYarnClient x0, YarnClient x1, boolean x2) throws Exception {
        return x0.createApp(x1, x2);
    }

    static /* synthetic */ void access$200(TestYarnClient x0, YarnClient x1, ApplicationId x2) throws Exception {
        x0.waitTillAccepted(x1, x2);
    }
}

