/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.cli.ApplicationCLI;
import org.apache.hadoop.yarn.client.cli.NodeCLI;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestYarnCLI {
    private YarnClient client = (YarnClient)Mockito.mock(YarnClient.class);
    ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;

    @Before
    public void setup() {
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysOutStream));
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysErrStream));
    }

    @Test
    public void testGetApplicationReport() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationReport newApplicationReport = ApplicationReport.newInstance((ApplicationId)applicationId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.53789f, (String)"YARN", null);
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)newApplicationReport);
        int result = cli.run(new String[]{"-status", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplicationReport(applicationId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Application Report : ");
        pw.println("\tApplication-Id : application_1234_0005");
        pw.println("\tApplication-Name : appname");
        pw.println("\tApplication-Type : YARN");
        pw.println("\tUser : user");
        pw.println("\tQueue : queue");
        pw.println("\tStart-Time : 0");
        pw.println("\tFinish-Time : 0");
        pw.println("\tProgress : 53.79%");
        pw.println("\tState : FINISHED");
        pw.println("\tFinal-State : SUCCEEDED");
        pw.println("\tTracking-URL : N/A");
        pw.println("\tRPC Port : 124");
        pw.println("\tAM Host : host");
        pw.println("\tDiagnostics : diagnostics");
        pw.close();
        String appReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
    }

    @Test
    public void testGetApplicationReportException() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenThrow(new Throwable[]{new ApplicationNotFoundException("Application with id '" + applicationId + "' doesn't exist in RM.")});
        try {
            cli.run(new String[]{"-status", applicationId.toString()});
            junit.framework.Assert.fail();
        }
        catch (Exception ex) {
            junit.framework.Assert.assertTrue((boolean)(ex instanceof ApplicationNotFoundException));
            junit.framework.Assert.assertEquals((String)("Application with id '" + applicationId + "' doesn't exist in RM."), (String)ex.getMessage());
        }
    }

    @Test
    public void testGetApplications() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationReport newApplicationReport = ApplicationReport.newInstance((ApplicationId)applicationId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.53789f, (String)"YARN", null);
        ArrayList<ApplicationReport> applicationReports = new ArrayList<ApplicationReport>();
        applicationReports.add(newApplicationReport);
        ApplicationId applicationId2 = ApplicationId.newInstance((long)1234L, (int)6);
        ApplicationReport newApplicationReport2 = ApplicationReport.newInstance((ApplicationId)applicationId2, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId2, (int)2), (String)"user2", (String)"queue2", (String)"appname2", (String)"host2", (int)125, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics2", (String)"url2", (long)2L, (long)2L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.63789f, (String)"NON-YARN", null);
        applicationReports.add(newApplicationReport2);
        ApplicationId applicationId3 = ApplicationId.newInstance((long)1234L, (int)7);
        ApplicationReport newApplicationReport3 = ApplicationReport.newInstance((ApplicationId)applicationId3, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId3, (int)3), (String)"user3", (String)"queue3", (String)"appname3", (String)"host3", (int)126, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics3", (String)"url3", (long)3L, (long)3L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.73789f, (String)"MAPREDUCE", null);
        applicationReports.add(newApplicationReport3);
        HashSet<String> appType1 = new HashSet<String>();
        appType1.add("YARN");
        Mockito.when((Object)this.client.getApplications(appType1)).thenReturn((Object)this.getApplicationReports(applicationReports, appType1));
        int result = cli.run(new String[]{"-list", "-appTypes", "YARN"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Total Applications:1");
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t                YARN\t      user\t     ");
        pw.print("queue\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         53.79%");
        pw.println("\t                                N/A");
        pw.close();
        String appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet<String> appType2 = new HashSet<String>();
        appType2.add("YARN");
        appType2.add("FOO-YARN");
        Mockito.when((Object)this.client.getApplications(appType2)).thenReturn((Object)this.getApplicationReports(applicationReports, appType2));
        cli.run(new String[]{"-list", "-appTypes", "YARN , ,, ,FOO-YARN", ",,,,, YARN,,"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType2);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Applications:1");
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t                YARN\t      user\t     ");
        pw.print("queue\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         53.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)2))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet<String> appType3 = new HashSet<String>();
        appType3.add("YARN");
        appType3.add("NON-YARN");
        Mockito.when((Object)this.client.getApplications(appType3)).thenReturn((Object)this.getApplicationReports(applicationReports, appType3));
        result = cli.run(new String[]{"-list", "-appTypes", "YARN,NON-YARN"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType3);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Applications:2");
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t                YARN\t      user\t     ");
        pw.print("queue\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         53.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0006\t            ");
        pw.print("appname2\t            NON-YARN\t     user2\t    ");
        pw.print("queue2\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         63.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)3))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet appType4 = new HashSet();
        Mockito.when((Object)this.client.getApplications(appType4)).thenReturn((Object)this.getApplicationReports(applicationReports, appType4));
        result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType4);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Applications:3");
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t                YARN\t      user\t     ");
        pw.print("queue\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         53.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0006\t            ");
        pw.print("appname2\t            NON-YARN\t     user2\t    ");
        pw.print("queue2\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         63.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0007\t            ");
        pw.print("appname3\t           MAPREDUCE\t     user3\t    ");
        pw.print("queue3\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         73.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)4))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    private List<ApplicationReport> getApplicationReports(List<ApplicationReport> applicationReports, Set<String> appTypes) {
        ArrayList<ApplicationReport> appReports = new ArrayList<ApplicationReport>();
        boolean bypassFilter = appTypes.isEmpty();
        for (ApplicationReport appReport : applicationReports) {
            if (!bypassFilter && !appTypes.contains(appReport.getApplicationType())) continue;
            appReports.add(appReport);
        }
        return appReports;
    }

    @Test(timeout=10000L)
    public void testHelpCommand() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationCLI spyCli = (ApplicationCLI)Mockito.spy((Object)cli);
        int result = spyCli.run(new String[]{"-help"});
        junit.framework.Assert.assertTrue((result == 0 ? 1 : 0) != 0);
        ((ApplicationCLI)Mockito.verify((Object)spyCli)).printUsage((Options)Matchers.any(Options.class));
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        result = cli.run(new String[]{"-kill", applicationId.toString(), "args"});
        ((ApplicationCLI)Mockito.verify((Object)spyCli)).printUsage((Options)Matchers.any(Options.class));
        NodeId nodeId = NodeId.newInstance((String)"host0", (int)0);
        result = cli.run(new String[]{"-status", nodeId.toString(), "args"});
        ((ApplicationCLI)Mockito.verify((Object)spyCli)).printUsage((Options)Matchers.any(Options.class));
    }

    @Test
    public void testKillApplication() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        int result = cli.run(new String[]{"-kill", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).killApplication((ApplicationId)Matchers.any(ApplicationId.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Killing application application_1234_0005");
    }

    @Test
    public void testListClusterNodes() throws Exception {
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports(new NodeState[]{NodeState.RUNNING})).thenReturn((Object)this.getNodeReports(3));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        int result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(new NodeState[]{NodeState.RUNNING});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Total Nodes:3");
        pw.print("         Node-Id\tNode-State\tNode-Http-Address\t");
        pw.println("Running-Containers");
        pw.print("         host0:0\t   RUNNING\t       host1:8888");
        pw.println("\t                 0");
        pw.print("         host1:0\t   RUNNING\t       host1:8888");
        pw.println("\t                 0");
        pw.print("         host2:0\t   RUNNING\t       host1:8888");
        pw.println("\t                 0");
        pw.close();
        String nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testNodeStatus() throws Exception {
        NodeId nodeId = NodeId.newInstance((String)"host0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports(new NodeState[0])).thenReturn((Object)this.getNodeReports(3));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(new NodeState[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Node Report : ");
        pw.println("\tNode-Id : host0:0");
        pw.println("\tRack : rack1");
        pw.println("\tNode-State : RUNNING");
        pw.println("\tNode-Http-Address : host1:8888");
        pw.println("\tLast-Health-Update : " + DateFormatUtils.format((Date)new Date(0L), (String)"E dd/MMM/yy hh:mm:ss:SSzz"));
        pw.println("\tHealth-Report : ");
        pw.println("\tContainers : 0");
        pw.println("\tMemory-Used : 0MB");
        pw.println("\tMemory-Capacity : 0MB");
        pw.println("\tCPU-Used : 0 vcores");
        pw.println("\tCPU-Capacity : 0 vcores");
        pw.close();
        String nodeStatusStr = baos.toString("UTF-8");
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println(nodeStatusStr);
    }

    @Test
    public void testAbsentNodeStatus() throws Exception {
        NodeId nodeId = NodeId.newInstance((String)"Absenthost0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports(new NodeState[0])).thenReturn((Object)this.getNodeReports(0));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(new NodeState[0]);
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Could not find the node report for node id : " + nodeId.toString());
    }

    @Test
    public void testAppCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new ApplicationCLI());
    }

    @Test
    public void testNodeCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new NodeCLI());
    }

    private void verifyUsageInfo(YarnCLI cli) throws Exception {
        cli.setSysErrPrintStream(this.sysErr);
        cli.run(new String[0]);
        ((PrintStream)Mockito.verify((Object)this.sysErr)).println("Invalid Command Usage : ");
    }

    private List<NodeReport> getNodeReports(int noOfNodes) {
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>();
        for (int i = 0; i < noOfNodes; ++i) {
            NodeReport nodeReport = NodeReport.newInstance((NodeId)NodeId.newInstance((String)("host" + i), (int)0), (NodeState)NodeState.RUNNING, (String)"host1:8888", (String)"rack1", (Resource)((Resource)Records.newRecord(Resource.class)), (Resource)((Resource)Records.newRecord(Resource.class)), (int)0, (String)"", (long)0L);
            nodeReports.add(nodeReport);
        }
        return nodeReports;
    }

    private ApplicationCLI createAndGetAppCLI() {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        return cli;
    }
}

