/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mortbay.log.Log;

public class TestAMRMClient {
    static Configuration conf = null;
    static MiniYARNCluster yarnCluster = null;
    static YarnClient yarnClient = null;
    static List<NodeReport> nodeReports = null;
    static ApplicationAttemptId attemptId = null;
    static int nodeCount = 3;
    static Resource capability;
    static Priority priority;
    static Priority priority2;
    static String node;
    static String rack;
    static String[] nodes;
    static String[] racks;
    private static final int DEFAULT_ITERATION = 3;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 100);
        yarnCluster = new MiniYARNCluster(TestAMRMClient.class.getName(), nodeCount, 1, 1);
        yarnCluster.init(conf);
        yarnCluster.start();
        yarnClient = YarnClient.createYarnClient();
        yarnClient.init(conf);
        yarnClient.start();
        nodeReports = yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
        priority = Priority.newInstance((int)1);
        priority2 = Priority.newInstance((int)2);
        capability = Resource.newInstance((int)1024, (int)1);
        node = ((NodeReport)nodeReports.get(0)).getNodeId().getHost();
        rack = ((NodeReport)nodeReports.get(0)).getRackName();
        nodes = new String[]{node};
        racks = new String[]{rack};
    }

    @Before
    public void startApp() throws Exception {
        ApplicationReport appReport;
        ApplicationSubmissionContext appContext = yarnClient.createApplication().getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        appContext.setApplicationName("Test");
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(0);
        appContext.setPriority(pri);
        appContext.setQueue("default");
        ContainerLaunchContext amContainer = BuilderUtils.newContainerLaunchContext(Collections.emptyMap(), new HashMap(), Arrays.asList("sleep", "100"), new HashMap(), null, new HashMap());
        appContext.setAMContainerSpec(amContainer);
        appContext.setResource(Resource.newInstance((int)1024, (int)1));
        SubmitApplicationRequest appRequest = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        appRequest.setApplicationSubmissionContext(appContext);
        yarnClient.submitApplication(appContext);
        RMAppAttempt appAttempt = null;
        while ((appReport = yarnClient.getApplicationReport(appId)).getYarnApplicationState() != YarnApplicationState.ACCEPTED) {
        }
        attemptId = appReport.getCurrentApplicationAttemptId();
        appAttempt = ((RMApp)yarnCluster.getResourceManager().getRMContext().getRMApps().get(attemptId.getApplicationId())).getCurrentAppAttempt();
        while (appAttempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED) {
        }
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)UserGroupInformation.getCurrentUser().getUserName()));
        UserGroupInformation.getCurrentUser().addToken(appAttempt.getAMRMToken());
    }

    @After
    public void cancelApp() throws YarnException, IOException {
        yarnClient.killApplication(attemptId.getApplicationId());
        attemptId = null;
    }

    @AfterClass
    public static void tearDown() {
        if (yarnClient != null && yarnClient.getServiceState() == Service.STATE.STARTED) {
            yarnClient.stop();
        }
        if (yarnCluster != null && yarnCluster.getServiceState() == Service.STATE.STARTED) {
            yarnCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAMRMClientMatchingFit() throws YarnException, IOException {
        AMRMClient amClient = null;
        try {
            amClient = AMRMClient.createAMRMClient();
            amClient.init(conf);
            amClient.start();
            amClient.registerApplicationMaster("Host", 10000, "");
            Resource capability1 = Resource.newInstance((int)1024, (int)2);
            Resource capability2 = Resource.newInstance((int)1024, (int)1);
            Resource capability3 = Resource.newInstance((int)1000, (int)2);
            Resource capability4 = Resource.newInstance((int)2000, (int)1);
            Resource capability5 = Resource.newInstance((int)1000, (int)3);
            Resource capability6 = Resource.newInstance((int)2000, (int)1);
            Resource capability7 = Resource.newInstance((int)2000, (int)1);
            AMRMClient.ContainerRequest storedContainer1 = new AMRMClient.ContainerRequest(capability1, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer2 = new AMRMClient.ContainerRequest(capability2, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer3 = new AMRMClient.ContainerRequest(capability3, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer4 = new AMRMClient.ContainerRequest(capability4, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer5 = new AMRMClient.ContainerRequest(capability5, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer6 = new AMRMClient.ContainerRequest(capability6, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer7 = new AMRMClient.ContainerRequest(capability7, nodes, racks, priority2, false);
            amClient.addContainerRequest(storedContainer1);
            amClient.addContainerRequest(storedContainer2);
            amClient.addContainerRequest(storedContainer3);
            amClient.addContainerRequest(storedContainer4);
            amClient.addContainerRequest(storedContainer5);
            amClient.addContainerRequest(storedContainer6);
            amClient.addContainerRequest(storedContainer7);
            Resource testCapability1 = Resource.newInstance((int)1024, (int)2);
            List matches = amClient.getMatchingRequests(priority, node, testCapability1);
            this.verifyMatches(matches, 1);
            AMRMClient.ContainerRequest storedRequest = (AMRMClient.ContainerRequest)((Collection)matches.get(0)).iterator().next();
            Assert.assertTrue((storedContainer1 == storedRequest ? 1 : 0) != 0);
            amClient.removeContainerRequest(storedContainer1);
            Resource testCapability2 = Resource.newInstance((int)2000, (int)1);
            matches = amClient.getMatchingRequests(priority, node, testCapability2);
            this.verifyMatches(matches, 2);
            int i = 0;
            for (AMRMClient.ContainerRequest storedRequest1 : (Collection)matches.get(0)) {
                if (i++ == 0) {
                    Assert.assertTrue((storedContainer4 == storedRequest1 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((storedContainer6 == storedRequest1 ? 1 : 0) != 0);
            }
            amClient.removeContainerRequest(storedContainer6);
            Resource testCapability3 = Resource.newInstance((int)4000, (int)4);
            matches = amClient.getMatchingRequests(priority, node, testCapability3);
            assert (matches.size() == 4);
            Resource testCapability4 = Resource.newInstance((int)1024, (int)2);
            matches = amClient.getMatchingRequests(priority, node, testCapability4);
            assert (matches.size() == 2);
            for (Collection testSet : matches) {
                Assert.assertTrue((testSet.size() == 1 ? 1 : 0) != 0);
                AMRMClient.ContainerRequest testRequest = (AMRMClient.ContainerRequest)testSet.iterator().next();
                Assert.assertTrue((testRequest != storedContainer4 ? 1 : 0) != 0);
                Assert.assertTrue((testRequest != storedContainer5 ? 1 : 0) != 0);
                assert (testRequest == storedContainer2 || testRequest == storedContainer3);
            }
            Resource testCapability5 = Resource.newInstance((int)512, (int)4);
            matches = amClient.getMatchingRequests(priority, node, testCapability5);
            assert (matches.size() == 0);
            Resource testCapability7 = Resource.newInstance((int)2000, (int)1);
            matches = amClient.getMatchingRequests(priority2, "*", testCapability7);
            assert (matches.size() == 0);
            matches = amClient.getMatchingRequests(priority2, node, testCapability7);
            assert (matches.size() == 1);
            amClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        }
        finally {
            if (amClient != null && amClient.getServiceState() == Service.STATE.STARTED) {
                amClient.stop();
            }
        }
    }

    private void verifyMatches(List<? extends Collection<AMRMClient.ContainerRequest>> matches, int matchSize) {
        Assert.assertTrue((matches.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((matches.get(0).size() == matchSize ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAMRMClientMatchingFitInferredRack() throws YarnException, IOException {
        AMRMClientImpl amClient = null;
        try {
            amClient = new AMRMClientImpl();
            amClient.init(conf);
            amClient.start();
            amClient.registerApplicationMaster("Host", 10000, "");
            Resource capability = Resource.newInstance((int)1024, (int)2);
            AMRMClient.ContainerRequest storedContainer1 = new AMRMClient.ContainerRequest(capability, nodes, null, priority);
            amClient.addContainerRequest(storedContainer1);
            List matches = amClient.getMatchingRequests(priority, node, capability);
            this.verifyMatches(matches, 1);
            AMRMClient.ContainerRequest storedRequest = (AMRMClient.ContainerRequest)((Collection)matches.get(0)).iterator().next();
            Assert.assertTrue((storedContainer1 == storedRequest ? 1 : 0) != 0);
            matches = amClient.getMatchingRequests(priority, rack, capability);
            this.verifyMatches(matches, 1);
            storedRequest = (AMRMClient.ContainerRequest)((Collection)matches.get(0)).iterator().next();
            Assert.assertTrue((storedContainer1 == storedRequest ? 1 : 0) != 0);
            amClient.removeContainerRequest(storedContainer1);
            matches = amClient.getMatchingRequests(priority, rack, capability);
            Assert.assertTrue((boolean)matches.isEmpty());
            amClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        }
        finally {
            if (amClient != null && amClient.getServiceState() == Service.STATE.STARTED) {
                amClient.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAMRMClientMatchStorage() throws YarnException, IOException {
        AMRMClientImpl amClient = null;
        try {
            AllocateResponse allocResponse;
            amClient = (AMRMClientImpl)AMRMClient.createAMRMClient();
            amClient.init(conf);
            amClient.start();
            amClient.registerApplicationMaster("Host", 10000, "");
            Priority priority1 = (Priority)Records.newRecord(Priority.class);
            priority1.setPriority(2);
            AMRMClient.ContainerRequest storedContainer1 = new AMRMClient.ContainerRequest(capability, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer2 = new AMRMClient.ContainerRequest(capability, nodes, racks, priority);
            AMRMClient.ContainerRequest storedContainer3 = new AMRMClient.ContainerRequest(capability, null, null, priority1);
            amClient.addContainerRequest(storedContainer1);
            amClient.addContainerRequest(storedContainer2);
            amClient.addContainerRequest(storedContainer3);
            int containersRequestedAny = ((AMRMClientImpl.ResourceRequestInfo)((TreeMap)((Map)amClient.remoteRequestsTable.get((Object)TestAMRMClient.priority)).get((Object)"*")).get((Object)TestAMRMClient.capability)).remoteRequest.getNumContainers();
            Assert.assertTrue((containersRequestedAny == 2 ? 1 : 0) != 0);
            containersRequestedAny = ((AMRMClientImpl.ResourceRequestInfo)((TreeMap)((Map)amClient.remoteRequestsTable.get((Object)priority1)).get((Object)"*")).get((Object)TestAMRMClient.capability)).remoteRequest.getNumContainers();
            Assert.assertTrue((containersRequestedAny == 1 ? 1 : 0) != 0);
            List matches = amClient.getMatchingRequests(priority, node, capability);
            this.verifyMatches(matches, 2);
            matches = amClient.getMatchingRequests(priority, rack, capability);
            this.verifyMatches(matches, 2);
            matches = amClient.getMatchingRequests(priority, "*", capability);
            this.verifyMatches(matches, 2);
            matches = amClient.getMatchingRequests(priority1, rack, capability);
            Assert.assertTrue((boolean)matches.isEmpty());
            matches = amClient.getMatchingRequests(priority1, "*", capability);
            this.verifyMatches(matches, 1);
            amClient.removeContainerRequest(storedContainer3);
            matches = amClient.getMatchingRequests(priority, node, capability);
            this.verifyMatches(matches, 2);
            amClient.removeContainerRequest(storedContainer2);
            matches = amClient.getMatchingRequests(priority, node, capability);
            this.verifyMatches(matches, 1);
            matches = amClient.getMatchingRequests(priority, rack, capability);
            this.verifyMatches(matches, 1);
            AMRMClient.ContainerRequest storedRequest = (AMRMClient.ContainerRequest)((Collection)matches.get(0)).iterator().next();
            Assert.assertTrue((storedContainer1 == storedRequest ? 1 : 0) != 0);
            amClient.removeContainerRequest(storedContainer1);
            matches = amClient.getMatchingRequests(priority, "*", capability);
            Assert.assertTrue((boolean)matches.isEmpty());
            matches = amClient.getMatchingRequests(priority1, "*", capability);
            Assert.assertTrue((boolean)matches.isEmpty());
            Assert.assertTrue((boolean)amClient.remoteRequestsTable.isEmpty());
            amClient.addContainerRequest(storedContainer1);
            amClient.addContainerRequest(storedContainer3);
            int allocatedContainerCount = 0;
            int iterationsLeft = 3;
            while (allocatedContainerCount < 2 && iterationsLeft-- > 0) {
                Log.info((String)(" == alloc " + allocatedContainerCount + " it left " + iterationsLeft));
                allocResponse = amClient.allocate(0.1f);
                Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((nodeCount == amClient.getClusterNodeCount() ? 1 : 0) != 0);
                allocatedContainerCount += allocResponse.getAllocatedContainers().size();
                for (Container container : allocResponse.getAllocatedContainers()) {
                    AMRMClient.ContainerRequest expectedRequest = container.getPriority().equals((Object)storedContainer1.getPriority()) ? storedContainer1 : storedContainer3;
                    matches = amClient.getMatchingRequests(container.getPriority(), "*", container.getResource());
                    this.verifyMatches(matches, 1);
                    AMRMClient.ContainerRequest matchedRequest = (AMRMClient.ContainerRequest)((Collection)matches.get(0)).iterator().next();
                    Assert.assertTrue((matchedRequest == expectedRequest ? 1 : 0) != 0);
                    amClient.removeContainerRequest(matchedRequest);
                    amClient.releaseAssignedContainer(container.getId());
                }
                if (allocatedContainerCount >= containersRequestedAny) continue;
                this.sleep(100);
            }
            Assert.assertTrue((allocatedContainerCount == 2 ? 1 : 0) != 0);
            allocResponse = amClient.allocate(0.1f);
            Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((allocResponse.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)amClient.remoteRequestsTable.isEmpty());
            amClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        }
        finally {
            if (amClient != null && amClient.getServiceState() == Service.STATE.STARTED) {
                amClient.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAllocationWithBlacklist() throws YarnException, IOException {
        AMRMClientImpl amClient = null;
        try {
            amClient = (AMRMClientImpl)AMRMClient.createAMRMClient();
            amClient.init(conf);
            amClient.start();
            amClient.registerApplicationMaster("Host", 10000, "");
            Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
            AMRMClient.ContainerRequest storedContainer1 = new AMRMClient.ContainerRequest(capability, nodes, racks, priority);
            amClient.addContainerRequest(storedContainer1);
            Assert.assertTrue((amClient.ask.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
            ArrayList<String> localNodeBlacklist = new ArrayList<String>();
            localNodeBlacklist.add(node);
            amClient.updateBlacklist(localNodeBlacklist, null);
            int allocatedContainerCount = this.getAllocatedContainersNumber(amClient, 3);
            Assert.assertTrue((allocatedContainerCount == 0 ? 1 : 0) != 0);
            amClient.updateBlacklist(null, localNodeBlacklist);
            AMRMClient.ContainerRequest storedContainer2 = new AMRMClient.ContainerRequest(capability, nodes, racks, priority);
            amClient.addContainerRequest(storedContainer2);
            allocatedContainerCount = this.getAllocatedContainersNumber(amClient, 3);
            Assert.assertEquals((long)allocatedContainerCount, (long)2L);
            Assert.assertTrue((boolean)amClient.blacklistAdditions.isEmpty());
            Assert.assertTrue((boolean)amClient.blacklistRemovals.isEmpty());
            AMRMClient.ContainerRequest invalidContainerRequest = new AMRMClient.ContainerRequest(Resource.newInstance((int)-1024, (int)1), nodes, racks, priority);
            amClient.addContainerRequest(invalidContainerRequest);
            amClient.updateBlacklist(localNodeBlacklist, null);
            try {
                amClient.allocate(0.1f);
                Assert.fail((String)"there should be an exception here.");
            }
            catch (Exception e) {
                Assert.assertEquals((long)amClient.blacklistAdditions.size(), (long)1L);
            }
        }
        finally {
            if (amClient != null && amClient.getServiceState() == Service.STATE.STARTED) {
                amClient.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAMRMClientWithBlacklist() throws YarnException, IOException {
        AMRMClientImpl amClient = null;
        try {
            amClient = (AMRMClientImpl)AMRMClient.createAMRMClient();
            amClient.init(conf);
            amClient.start();
            amClient.registerApplicationMaster("Host", 10000, "");
            String[] nodes = new String[]{"node1", "node2", "node3"};
            ArrayList<String> nodeList01 = new ArrayList<String>();
            nodeList01.add(nodes[0]);
            nodeList01.add(nodes[1]);
            amClient.updateBlacklist(nodeList01, null);
            Assert.assertEquals((long)amClient.blacklistAdditions.size(), (long)2L);
            Assert.assertEquals((long)amClient.blacklistRemovals.size(), (long)0L);
            ArrayList<String> nodeList02 = new ArrayList<String>();
            nodeList02.add(nodes[0]);
            nodeList02.add(nodes[2]);
            amClient.updateBlacklist(nodeList02, null);
            Assert.assertEquals((long)amClient.blacklistAdditions.size(), (long)3L);
            Assert.assertEquals((long)amClient.blacklistRemovals.size(), (long)0L);
            ArrayList<String> nodeList12 = new ArrayList<String>();
            nodeList12.add(nodes[1]);
            nodeList12.add(nodes[2]);
            amClient.updateBlacklist(null, nodeList12);
            Assert.assertEquals((long)amClient.blacklistAdditions.size(), (long)1L);
            Assert.assertEquals((long)amClient.blacklistRemovals.size(), (long)2L);
            ArrayList<String> nodeList1 = new ArrayList<String>();
            nodeList1.add(nodes[1]);
            amClient.updateBlacklist(nodeList1, null);
            Assert.assertEquals((long)amClient.blacklistAdditions.size(), (long)2L);
            Assert.assertEquals((long)amClient.blacklistRemovals.size(), (long)1L);
        }
        finally {
            if (amClient != null && amClient.getServiceState() == Service.STATE.STARTED) {
                amClient.stop();
            }
        }
    }

    private int getAllocatedContainersNumber(AMRMClientImpl<AMRMClient.ContainerRequest> amClient, int iterationsLeft) throws YarnException, IOException {
        int allocatedContainerCount = 0;
        while (iterationsLeft-- > 0) {
            Log.info((String)(" == alloc " + allocatedContainerCount + " it left " + iterationsLeft));
            AllocateResponse allocResponse = amClient.allocate(0.1f);
            Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((nodeCount == amClient.getClusterNodeCount() ? 1 : 0) != 0);
            if ((allocatedContainerCount += allocResponse.getAllocatedContainers().size()) != 0) continue;
            this.sleep(100);
        }
        return allocatedContainerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAMRMClient() throws YarnException, IOException {
        AMRMClient amClient = null;
        try {
            amClient = AMRMClient.createAMRMClient();
            amClient.init(conf);
            amClient.start();
            amClient.registerApplicationMaster("Host", 10000, "");
            this.testAllocation((AMRMClientImpl)amClient);
            amClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        }
        finally {
            if (amClient != null && amClient.getServiceState() == Service.STATE.STARTED) {
                amClient.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAllocation(AMRMClientImpl<AMRMClient.ContainerRequest> amClient) throws YarnException, IOException {
        Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        amClient.removeContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        amClient.removeContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        int containersRequestedNode = ((AMRMClientImpl.ResourceRequestInfo)((TreeMap)((Map)amClient.remoteRequestsTable.get((Object)TestAMRMClient.priority)).get((Object)TestAMRMClient.node)).get((Object)TestAMRMClient.capability)).remoteRequest.getNumContainers();
        int containersRequestedRack = ((AMRMClientImpl.ResourceRequestInfo)((TreeMap)((Map)amClient.remoteRequestsTable.get((Object)TestAMRMClient.priority)).get((Object)TestAMRMClient.rack)).get((Object)TestAMRMClient.capability)).remoteRequest.getNumContainers();
        int containersRequestedAny = ((AMRMClientImpl.ResourceRequestInfo)((TreeMap)((Map)amClient.remoteRequestsTable.get((Object)TestAMRMClient.priority)).get((Object)"*")).get((Object)TestAMRMClient.capability)).remoteRequest.getNumContainers();
        Assert.assertTrue((containersRequestedNode == 2 ? 1 : 0) != 0);
        Assert.assertTrue((containersRequestedRack == 2 ? 1 : 0) != 0);
        Assert.assertTrue((containersRequestedAny == 2 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.ask.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
        int allocatedContainerCount = 0;
        int iterationsLeft = 3;
        TreeSet<ContainerId> releases = new TreeSet<ContainerId>();
        NMTokenCache.clearCache();
        junit.framework.Assert.assertEquals((int)0, (int)NMTokenCache.numberOfNMTokensInCache());
        HashMap<String, Token> receivedNMTokens = new HashMap<String, Token>();
        while (allocatedContainerCount < containersRequestedAny && iterationsLeft-- > 0) {
            AllocateResponse allocResponse = amClient.allocate(0.1f);
            Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((nodeCount == amClient.getClusterNodeCount() ? 1 : 0) != 0);
            allocatedContainerCount += allocResponse.getAllocatedContainers().size();
            for (Container container : allocResponse.getAllocatedContainers()) {
                ContainerId rejectContainerId = container.getId();
                releases.add(rejectContainerId);
                amClient.releaseAssignedContainer(rejectContainerId);
            }
            for (NMToken token : allocResponse.getNMTokens()) {
                String nodeID = token.getNodeId().toString();
                if (receivedNMTokens.containsKey(nodeID)) {
                    junit.framework.Assert.fail((String)("Received token again for : " + nodeID));
                }
                receivedNMTokens.put(nodeID, token.getToken());
            }
            if (allocatedContainerCount >= containersRequestedAny) continue;
            this.sleep(100);
        }
        junit.framework.Assert.assertTrue((receivedNMTokens.size() > 0 && receivedNMTokens.size() <= nodeCount ? 1 : 0) != 0);
        Assert.assertTrue((allocatedContainerCount == containersRequestedAny ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
        amClient.removeContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        amClient.removeContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        Assert.assertTrue((amClient.ask.size() == 3 ? 1 : 0) != 0);
        ResourceRequest snoopRequest = (ResourceRequest)amClient.ask.iterator().next();
        Assert.assertTrue((snoopRequest.getNumContainers() == 0 ? 1 : 0) != 0);
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        amClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        snoopRequest = (ResourceRequest)amClient.ask.iterator().next();
        Assert.assertTrue((snoopRequest.getNumContainers() == 2 ? 1 : 0) != 0);
        ApplicationMasterProtocol realRM = amClient.rmClient;
        try {
            ApplicationMasterProtocol mockRM = (ApplicationMasterProtocol)Mockito.mock(ApplicationMasterProtocol.class);
            Mockito.when((Object)mockRM.allocate((AllocateRequest)Matchers.any(AllocateRequest.class))).thenAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */);
            amClient.rmClient = mockRM;
            amClient.allocate(0.1f);
        }
        catch (Exception ioe) {
        }
        finally {
            amClient.rmClient = realRM;
        }
        Assert.assertTrue((amClient.release.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.ask.size() == 3 ? 1 : 0) != 0);
        snoopRequest = (ResourceRequest)amClient.ask.iterator().next();
        Assert.assertTrue((snoopRequest.getNumContainers() == 0 ? 1 : 0) != 0);
        iterationsLeft = 3;
        while (!releases.isEmpty() || iterationsLeft-- > 0) {
            AllocateResponse allocResponse = amClient.allocate(0.1f);
            Assert.assertTrue((allocResponse.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
            if (allocResponse.getCompletedContainersStatuses().size() > 0) {
                for (ContainerStatus cStatus : allocResponse.getCompletedContainersStatuses()) {
                    if (!releases.contains(cStatus.getContainerId())) continue;
                    Assert.assertTrue((cStatus.getState() == ContainerState.COMPLETE ? 1 : 0) != 0);
                    Assert.assertTrue((cStatus.getExitStatus() == -100 ? 1 : 0) != 0);
                    releases.remove(cStatus.getContainerId());
                }
            }
            if (iterationsLeft <= 0) continue;
            this.sleep(100);
        }
        Assert.assertTrue((amClient.ask.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((amClient.release.size() == 0 ? 1 : 0) != 0);
    }

    private void sleep(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

