/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationCLI
extends YarnCLI {
    private static final String APPLICATIONS_PATTERN = "%30s\t%20s\t%20s\t%10s\t%10s\t%18s\t%18s\t%15s\t%35s" + System.getProperty("line.separator");
    private static final String APP_TYPE_CMD = "appTypes";
    private static final String APP_STATE_CMD = "appStates";
    private static final String ALLSTATES_OPTION = "ALL";
    private boolean allAppStates;

    public static void main(String[] args) throws Exception {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])args);
        cli.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("status", true, "Prints the status of the application.");
        opts.addOption("list", false, "List applications from the RM. Supports optional use of -appTypes to filter applications based on application type, and -appStates to filter applications based on application state");
        opts.addOption("kill", true, "Kills the application.");
        opts.addOption("help", false, "Displays help for all commands.");
        Option appTypeOpt = new Option(APP_TYPE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application types.");
        appTypeOpt.setValueSeparator(',');
        appTypeOpt.setArgs(-2);
        appTypeOpt.setArgName("Types");
        opts.addOption(appTypeOpt);
        Option appStateOpt = new Option(APP_STATE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application states. " + this.getAllValidApplicationStates());
        appStateOpt.setValueSeparator(',');
        appStateOpt.setArgs(-2);
        appStateOpt.setArgName("States");
        opts.addOption(appStateOpt);
        opts.getOption("kill").setArgName("Application ID");
        opts.getOption("status").setArgName("Application ID");
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(opts);
            return exitCode;
        }
        if (cliParser.hasOption("status")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.printApplicationReport(cliParser.getOptionValue("status"));
        } else if (cliParser.hasOption("list")) {
            String[] states;
            String[] types;
            this.allAppStates = false;
            HashSet<String> appTypes = new HashSet<String>();
            if (cliParser.hasOption(APP_TYPE_CMD) && (types = cliParser.getOptionValues(APP_TYPE_CMD)) != null) {
                for (String type : types) {
                    if (type.trim().isEmpty()) continue;
                    appTypes.add(type.toUpperCase().trim());
                }
            }
            EnumSet<YarnApplicationState> appStates = EnumSet.noneOf(YarnApplicationState.class);
            if (cliParser.hasOption(APP_STATE_CMD) && (states = cliParser.getOptionValues(APP_STATE_CMD)) != null) {
                for (String state : states) {
                    if (state.trim().isEmpty()) continue;
                    if (state.trim().equalsIgnoreCase(ALLSTATES_OPTION)) {
                        this.allAppStates = true;
                        break;
                    }
                    try {
                        appStates.add(YarnApplicationState.valueOf((String)state.toUpperCase().trim()));
                    }
                    catch (IllegalArgumentException ex) {
                        this.sysout.println("The application state " + state + " is invalid.");
                        this.sysout.println(this.getAllValidApplicationStates());
                        return exitCode;
                    }
                }
            }
            this.listApplications(appTypes, appStates);
        } else if (cliParser.hasOption("kill")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.killApplication(cliParser.getOptionValue("kill"));
        } else {
            if (cliParser.hasOption("help")) {
                this.printUsage(opts);
                return 0;
            }
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(opts);
        }
        return 0;
    }

    @VisibleForTesting
    void printUsage(Options opts) {
        new HelpFormatter().printHelp("application", opts);
    }

    private void listApplications(Set<String> appTypes, EnumSet<YarnApplicationState> appStates) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(this.sysout);
        if (this.allAppStates) {
            for (YarnApplicationState appState : YarnApplicationState.values()) {
                appStates.add(appState);
            }
        } else if (appStates.isEmpty()) {
            appStates.add(YarnApplicationState.RUNNING);
            appStates.add(YarnApplicationState.ACCEPTED);
            appStates.add(YarnApplicationState.SUBMITTED);
        }
        List<ApplicationReport> appsReport = this.client.getApplications(appTypes, appStates);
        writer.println("Total number of applications (application-types: " + appTypes + " and states: " + appStates + ")" + ":" + appsReport.size());
        writer.printf(APPLICATIONS_PATTERN, "Application-Id", "Application-Name", "Application-Type", "User", "Queue", "State", "Final-State", "Progress", "Tracking-URL");
        for (ApplicationReport appReport : appsReport) {
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            writer.printf(APPLICATIONS_PATTERN, appReport.getApplicationId(), appReport.getName(), appReport.getApplicationType(), appReport.getUser(), appReport.getQueue(), appReport.getYarnApplicationState(), appReport.getFinalApplicationStatus(), progress, appReport.getOriginalTrackingUrl());
        }
        writer.flush();
    }

    private void killApplication(String applicationId) throws YarnException, IOException {
        ApplicationId appId = ConverterUtils.toApplicationId((String)applicationId);
        ApplicationReport appReport = this.client.getApplicationReport(appId);
        if (appReport.getYarnApplicationState() == YarnApplicationState.FINISHED || appReport.getYarnApplicationState() == YarnApplicationState.KILLED || appReport.getYarnApplicationState() == YarnApplicationState.FAILED) {
            this.sysout.println("Application " + applicationId + " has already finished ");
        } else {
            this.sysout.println("Killing application " + applicationId);
            this.client.killApplication(appId);
        }
    }

    private void printApplicationReport(String applicationId) throws YarnException, IOException {
        ApplicationReport appReport = this.client.getApplicationReport(ConverterUtils.toApplicationId((String)applicationId));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter appReportStr = new PrintWriter(baos);
        if (appReport != null) {
            appReportStr.println("Application Report : ");
            appReportStr.print("\tApplication-Id : ");
            appReportStr.println(appReport.getApplicationId());
            appReportStr.print("\tApplication-Name : ");
            appReportStr.println(appReport.getName());
            appReportStr.print("\tApplication-Type : ");
            appReportStr.println(appReport.getApplicationType());
            appReportStr.print("\tUser : ");
            appReportStr.println(appReport.getUser());
            appReportStr.print("\tQueue : ");
            appReportStr.println(appReport.getQueue());
            appReportStr.print("\tStart-Time : ");
            appReportStr.println(appReport.getStartTime());
            appReportStr.print("\tFinish-Time : ");
            appReportStr.println(appReport.getFinishTime());
            appReportStr.print("\tProgress : ");
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            appReportStr.println(progress);
            appReportStr.print("\tState : ");
            appReportStr.println(appReport.getYarnApplicationState());
            appReportStr.print("\tFinal-State : ");
            appReportStr.println(appReport.getFinalApplicationStatus());
            appReportStr.print("\tTracking-URL : ");
            appReportStr.println(appReport.getOriginalTrackingUrl());
            appReportStr.print("\tRPC Port : ");
            appReportStr.println(appReport.getRpcPort());
            appReportStr.print("\tAM Host : ");
            appReportStr.println(appReport.getHost());
            appReportStr.print("\tDiagnostics : ");
            appReportStr.print(appReport.getDiagnostics());
        } else {
            appReportStr.print("Application with id '" + applicationId + "' doesn't exist in RM.");
        }
        appReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
    }

    private String getAllValidApplicationStates() {
        StringBuilder sb = new StringBuilder();
        sb.append("The valid application state can be one of the following: ");
        sb.append("ALL,");
        for (YarnApplicationState appState : YarnApplicationState.values()) {
            sb.append(appState + ",");
        }
        String output = sb.toString();
        return output.substring(0, output.length() - 1);
    }
}

