/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.InvalidContainerRequestException;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.client.api.impl.TestAMRMClientContainerRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestAMRMClientContainerRequest {
    @Test
    public void testFillInRacks() {
        AMRMClientImpl client = new AMRMClientImpl();
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        client.init(conf);
        Resource capability = Resource.newInstance((int)1024, (int)1);
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, new String[]{"host1", "host2"}, new String[]{"/rack2"}, Priority.newInstance((int)1));
        client.addContainerRequest(request);
        this.verifyResourceRequest(client, request, "host1", true);
        this.verifyResourceRequest(client, request, "host2", true);
        this.verifyResourceRequest(client, request, "/rack1", true);
        this.verifyResourceRequest(client, request, "/rack2", true);
        this.verifyResourceRequest(client, request, "*", true);
    }

    @Test
    public void testDisableLocalityRelaxation() {
        AMRMClientImpl client = new AMRMClientImpl();
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        client.init(conf);
        Resource capability = Resource.newInstance((int)1024, (int)1);
        AMRMClient.ContainerRequest nodeLevelRequest = new AMRMClient.ContainerRequest(capability, new String[]{"host1", "host2"}, null, Priority.newInstance((int)1), false);
        client.addContainerRequest(nodeLevelRequest);
        this.verifyResourceRequest(client, nodeLevelRequest, "*", false);
        this.verifyResourceRequest(client, nodeLevelRequest, "/rack1", false);
        this.verifyResourceRequest(client, nodeLevelRequest, "host1", true);
        this.verifyResourceRequest(client, nodeLevelRequest, "host2", true);
        AMRMClient.ContainerRequest nodeLevelRequest2 = new AMRMClient.ContainerRequest(capability, new String[]{"host2", "host3"}, null, Priority.newInstance((int)1), false);
        client.addContainerRequest(nodeLevelRequest2);
        AMRMClient.ContainerRequest rackLevelRequest = new AMRMClient.ContainerRequest(capability, null, new String[]{"/rack3", "/rack4"}, Priority.newInstance((int)2), false);
        client.addContainerRequest(rackLevelRequest);
        this.verifyResourceRequest(client, rackLevelRequest, "*", false);
        this.verifyResourceRequest(client, rackLevelRequest, "/rack3", true);
        this.verifyResourceRequest(client, rackLevelRequest, "/rack4", true);
        AMRMClient.ContainerRequest rackLevelRequest2 = new AMRMClient.ContainerRequest(capability, null, new String[]{"/rack4", "/rack5"}, Priority.newInstance((int)2), false);
        client.addContainerRequest(rackLevelRequest2);
        AMRMClient.ContainerRequest bothLevelRequest = new AMRMClient.ContainerRequest(capability, new String[]{"host3", "host4"}, new String[]{"rack1", "/otherrack"}, Priority.newInstance((int)3), false);
        client.addContainerRequest(bothLevelRequest);
        this.verifyResourceRequest(client, bothLevelRequest, "*", false);
        this.verifyResourceRequest(client, bothLevelRequest, "rack1", true);
        this.verifyResourceRequest(client, bothLevelRequest, "/otherrack", true);
        this.verifyResourceRequest(client, bothLevelRequest, "host3", true);
        this.verifyResourceRequest(client, bothLevelRequest, "host4", true);
        AMRMClient.ContainerRequest bothLevelRequest2 = new AMRMClient.ContainerRequest(capability, new String[]{"host4", "host5"}, new String[]{"rack1", "/otherrack2"}, Priority.newInstance((int)3), false);
        client.addContainerRequest(bothLevelRequest2);
    }

    @Test(expected=InvalidContainerRequestException.class)
    public void testDifferentLocalityRelaxationSamePriority() {
        AMRMClientImpl client = new AMRMClientImpl();
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        client.init(conf);
        Resource capability = Resource.newInstance((int)1024, (int)1);
        AMRMClient.ContainerRequest request1 = new AMRMClient.ContainerRequest(capability, new String[]{"host1", "host2"}, null, Priority.newInstance((int)1), false);
        client.addContainerRequest(request1);
        AMRMClient.ContainerRequest request2 = new AMRMClient.ContainerRequest(capability, new String[]{"host3"}, null, Priority.newInstance((int)1), true);
        client.addContainerRequest(request2);
    }

    @Test
    public void testInvalidValidWhenOldRemoved() {
        AMRMClientImpl client = new AMRMClientImpl();
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        client.init(conf);
        Resource capability = Resource.newInstance((int)1024, (int)1);
        AMRMClient.ContainerRequest request1 = new AMRMClient.ContainerRequest(capability, new String[]{"host1", "host2"}, null, Priority.newInstance((int)1), false);
        client.addContainerRequest(request1);
        client.removeContainerRequest(request1);
        AMRMClient.ContainerRequest request2 = new AMRMClient.ContainerRequest(capability, new String[]{"host3"}, null, Priority.newInstance((int)1), true);
        client.addContainerRequest(request2);
        client.removeContainerRequest(request2);
        AMRMClient.ContainerRequest request3 = new AMRMClient.ContainerRequest(capability, new String[]{"host1", "host2"}, null, Priority.newInstance((int)1), false);
        client.addContainerRequest(request3);
        client.removeContainerRequest(request3);
        AMRMClient.ContainerRequest request4 = new AMRMClient.ContainerRequest(capability, null, new String[]{"rack1"}, Priority.newInstance((int)1), true);
        client.addContainerRequest(request4);
    }

    @Test(expected=InvalidContainerRequestException.class)
    public void testLocalityRelaxationDifferentLevels() {
        AMRMClientImpl client = new AMRMClientImpl();
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        client.init(conf);
        Resource capability = Resource.newInstance((int)1024, (int)1);
        AMRMClient.ContainerRequest request1 = new AMRMClient.ContainerRequest(capability, new String[]{"host1", "host2"}, null, Priority.newInstance((int)1), false);
        client.addContainerRequest(request1);
        AMRMClient.ContainerRequest request2 = new AMRMClient.ContainerRequest(capability, null, new String[]{"rack1"}, Priority.newInstance((int)1), true);
        client.addContainerRequest(request2);
    }

    private void verifyResourceRequest(AMRMClientImpl<AMRMClient.ContainerRequest> client, AMRMClient.ContainerRequest request, String location, boolean expectedRelaxLocality) {
        ResourceRequest ask = ((AMRMClientImpl.ResourceRequestInfo)((TreeMap)((Map)client.remoteRequestsTable.get((Object)request.getPriority())).get((Object)location)).get((Object)request.getCapability())).remoteRequest;
        Assert.assertEquals((Object)location, (Object)ask.getResourceName());
        Assert.assertEquals((long)1L, (long)ask.getNumContainers());
        Assert.assertEquals((Object)expectedRelaxLocality, (Object)ask.getRelaxLocality());
    }
}

