/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.AMRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.FinishApplicationMasterRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.FinishApplicationMasterResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RegisterApplicationMasterRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RegisterApplicationMasterResponsePBImpl;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.ipc.ProtoOverHadoopRpcEngine;
import org.apache.hadoop.yarn.proto.AMRMProtocol;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class AMRMProtocolPBClientImpl
implements AMRMProtocol {
    private AMRMProtocol.AMRMProtocolService.BlockingInterface proxy;

    public AMRMProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, AMRMProtocol.AMRMProtocolService.BlockingInterface.class, ProtoOverHadoopRpcEngine.class);
        this.proxy = (AMRMProtocol.AMRMProtocolService.BlockingInterface)RPC.getProxy(AMRMProtocol.AMRMProtocolService.BlockingInterface.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    public AllocateResponse allocate(AllocateRequest request) throws YarnRemoteException {
        YarnServiceProtos.AllocateRequestProto requestProto = ((AllocateRequestPBImpl)request).getProto();
        try {
            return new AllocateResponsePBImpl(this.proxy.allocate(null, requestProto));
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof YarnRemoteException) {
                throw (YarnRemoteException)e.getCause();
            }
            if (e.getCause() instanceof UndeclaredThrowableException) {
                throw (UndeclaredThrowableException)e.getCause();
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnRemoteException {
        YarnServiceProtos.FinishApplicationMasterRequestProto requestProto = ((FinishApplicationMasterRequestPBImpl)request).getProto();
        try {
            return new FinishApplicationMasterResponsePBImpl(this.proxy.finishApplicationMaster(null, requestProto));
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof YarnRemoteException) {
                throw (YarnRemoteException)e.getCause();
            }
            if (e.getCause() instanceof UndeclaredThrowableException) {
                throw (UndeclaredThrowableException)e.getCause();
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnRemoteException {
        YarnServiceProtos.RegisterApplicationMasterRequestProto requestProto = ((RegisterApplicationMasterRequestPBImpl)request).getProto();
        try {
            return new RegisterApplicationMasterResponsePBImpl(this.proxy.registerApplicationMaster(null, requestProto));
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof YarnRemoteException) {
                throw (YarnRemoteException)e.getCause();
            }
            if (e.getCause() instanceof UndeclaredThrowableException) {
                throw (UndeclaredThrowableException)e.getCause();
            }
            throw new UndeclaredThrowableException(e);
        }
    }
}

