/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factories.impl.pb;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.factories.RpcServerFactory;
import org.apache.hadoop.yarn.ipc.ProtoOverHadoopRpcEngine;

public class RpcServerFactoryPBImpl
implements RpcServerFactory {
    private static final String PROTO_GEN_PACKAGE_NAME = "org.apache.hadoop.yarn.proto";
    private static final String PROTO_GEN_CLASS_SUFFIX = "Service";
    private static final String PB_IMPL_PACKAGE_SUFFIX = "impl.pb.service";
    private static final String PB_IMPL_CLASS_SUFFIX = "PBServiceImpl";
    private static final RpcServerFactoryPBImpl self = new RpcServerFactoryPBImpl();
    private Configuration localConf = new Configuration();
    private ConcurrentMap<Class<?>, Constructor<?>> serviceCache = new ConcurrentHashMap();
    private ConcurrentMap<Class<?>, Method> protoCache = new ConcurrentHashMap();

    public static RpcServerFactoryPBImpl get() {
        return self;
    }

    private RpcServerFactoryPBImpl() {
    }

    public Server getServer(Class<?> protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers) throws YarnException {
        return this.getServer(protocol, instance, addr, conf, secretManager, numHandlers, null);
    }

    @Override
    public Server getServer(Class<?> protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, String portRangeConfig) throws YarnException {
        Constructor constructor = (Constructor)this.serviceCache.get(protocol);
        if (constructor == null) {
            Class pbServiceImplClazz = null;
            try {
                pbServiceImplClazz = this.localConf.getClassByName(this.getPbServiceImplClassName(protocol));
            }
            catch (ClassNotFoundException e) {
                throw new YarnException("Failed to load class: [" + this.getPbServiceImplClassName(protocol) + "]", e);
            }
            try {
                constructor = pbServiceImplClazz.getConstructor(protocol);
                constructor.setAccessible(true);
                this.serviceCache.putIfAbsent(protocol, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new YarnException("Could not find constructor with params: " + Long.TYPE + ", " + InetSocketAddress.class + ", " + Configuration.class, e);
            }
        }
        Object service = null;
        try {
            service = constructor.newInstance(instance);
        }
        catch (InvocationTargetException e) {
            throw new YarnException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnException(e);
        }
        catch (InstantiationException e) {
            throw new YarnException(e);
        }
        Method method = (Method)this.protoCache.get(protocol);
        if (method == null) {
            Class protoClazz = null;
            try {
                protoClazz = this.localConf.getClassByName(this.getProtoClassName(protocol));
            }
            catch (ClassNotFoundException e) {
                throw new YarnException("Failed to load class: [" + this.getProtoClassName(protocol) + "]", e);
            }
            try {
                method = protoClazz.getMethod("newReflectiveBlockingService", service.getClass().getInterfaces()[0]);
                method.setAccessible(true);
                this.protoCache.putIfAbsent(protocol, method);
            }
            catch (NoSuchMethodException e) {
                throw new YarnException(e);
            }
        }
        try {
            return this.createServer(addr, conf, secretManager, numHandlers, (BlockingService)method.invoke(null, service), portRangeConfig);
        }
        catch (InvocationTargetException e) {
            throw new YarnException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnException(e);
        }
        catch (IOException e) {
            throw new YarnException(e);
        }
    }

    private String getProtoClassName(Class<?> clazz) {
        String srcClassName = this.getClassName(clazz);
        return "org.apache.hadoop.yarn.proto." + srcClassName + "$" + srcClassName + PROTO_GEN_CLASS_SUFFIX;
    }

    private String getPbServiceImplClassName(Class<?> clazz) {
        String srcPackagePart = this.getPackageName(clazz);
        String srcClassName = this.getClassName(clazz);
        String destPackagePart = srcPackagePart + "." + PB_IMPL_PACKAGE_SUFFIX;
        String destClassPart = srcClassName + PB_IMPL_CLASS_SUFFIX;
        return destPackagePart + "." + destClassPart;
    }

    private String getClassName(Class<?> clazz) {
        String fqName = clazz.getName();
        return fqName.substring(fqName.lastIndexOf(".") + 1, fqName.length());
    }

    private String getPackageName(Class<?> clazz) {
        return clazz.getPackage().getName();
    }

    private Server createServer(InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, BlockingService blockingService, String portRangeConfig) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, BlockingService.class, ProtoOverHadoopRpcEngine.class);
        RPC.Server server = RPC.getServer(BlockingService.class, (Object)blockingService, (String)addr.getHostName(), (int)addr.getPort(), (int)numHandlers, (boolean)false, (Configuration)conf, secretManager, (String)portRangeConfig);
        return server;
    }
}

