/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factory.providers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.factories.RpcClientFactory;
import org.apache.hadoop.yarn.factories.RpcServerFactory;
import org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl;
import org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl;

public class RpcFactoryProvider {
    private static final Log LOG = LogFactory.getLog(RpcFactoryProvider.class);

    private RpcFactoryProvider() {
    }

    public static RpcServerFactory getServerFactory(Configuration conf) {
        String serverFactoryClassName;
        if (conf == null) {
            conf = new Configuration();
        }
        if ((serverFactoryClassName = conf.get("yarn.ipc.server.factory.class")) == null) {
            if (conf.get("yarn.ipc.serializer.type", "protocolbuffers").equals("protocolbuffers")) {
                return RpcServerFactoryPBImpl.get();
            }
            throw new YarnException("Unknown serializer: [" + conf.get("yarn.ipc.serializer.type") + "]. Use keys: [" + "yarn.ipc.client.factory.class" + "][" + "yarn.ipc.server.factory.class" + "] to specify factories");
        }
        return (RpcServerFactory)RpcFactoryProvider.getFactoryClassInstance(serverFactoryClassName);
    }

    public static RpcClientFactory getClientFactory(Configuration conf) {
        String clientFactoryClassName = conf.get("yarn.ipc.client.factory.class");
        if (clientFactoryClassName == null) {
            if (conf.get("yarn.ipc.serializer.type", "protocolbuffers").equals("protocolbuffers")) {
                return RpcClientFactoryPBImpl.get();
            }
            throw new YarnException("Unknown serializer: [" + conf.get("yarn.ipc.serializer.type") + "]. Use keys: [" + "yarn.ipc.client.factory.class" + "][" + "yarn.ipc.server.factory.class" + "] to specify factories");
        }
        return (RpcClientFactory)RpcFactoryProvider.getFactoryClassInstance(clientFactoryClassName);
    }

    private static Object getFactoryClassInstance(String factoryClassName) {
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            Method method = clazz.getMethod("get", null);
            method.setAccessible(true);
            return method.invoke(null, null);
        }
        catch (ClassNotFoundException e) {
            throw new YarnException(e);
        }
        catch (NoSuchMethodException e) {
            throw new YarnException(e);
        }
        catch (InvocationTargetException e) {
            throw new YarnException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnException(e);
        }
    }
}

