/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.ApplicationTokenIdentifier;

public class ApplicationTokenSelector
implements TokenSelector<ApplicationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(ApplicationTokenSelector.class);

    public Token<ApplicationTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug((Object)("Looking for a token with service " + service.toString()));
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug((Object)("Token kind is " + token.getKind().toString() + " and the token's service name is " + token.getService()));
            if (!ApplicationTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
            return token;
        }
        return null;
    }
}

