/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;

public class RMDelegationTokenRenewer
extends TokenRenewer {
    private static final Log LOG = LogFactory.getLog(RMDelegationTokenRenewer.class);

    public boolean handleKind(Text kind) {
        return RMDelegationTokenIdentifier.KIND_NAME.equals((Object)kind);
    }

    public boolean isManaged(Token<?> token) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        ClientRMProtocol rm = this.getRMClient(conf, SecurityUtil.getTokenServiceAddr(token));
        try {
            DelegationToken dToken = BuilderUtils.newDelegationToken(token.getIdentifier(), token.getKind().toString(), token.getPassword(), token.getService().toString());
            RenewDelegationTokenRequest request = Records.newRecord(RenewDelegationTokenRequest.class);
            request.setDelegationToken(dToken);
            long l = rm.renewDelegationToken(request).getNextExpirationTime();
            return l;
        }
        finally {
            RPC.stopProxy((Object)rm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        ClientRMProtocol rm = this.getRMClient(conf, SecurityUtil.getTokenServiceAddr(token));
        try {
            DelegationToken dToken = BuilderUtils.newDelegationToken(token.getIdentifier(), token.getKind().toString(), token.getPassword(), token.getService().toString());
            CancelDelegationTokenRequest request = Records.newRecord(CancelDelegationTokenRequest.class);
            request.setDelegationToken(dToken);
            rm.cancelDelegationToken(request);
        }
        finally {
            RPC.stopProxy((Object)rm);
        }
    }

    private ClientRMProtocol getRMClient(Configuration conf, InetSocketAddress rmAddress) {
        YarnRPC rpc = YarnRPC.create(conf);
        LOG.debug((Object)("Connecting to ResourceManager at " + rmAddress));
        ClientRMProtocol rm = (ClientRMProtocol)rpc.getProxy(ClientRMProtocol.class, rmAddress, conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connected to ResourceManager at " + rmAddress));
        }
        return rm;
    }
}

