/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public class ClientTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_CLIENT_TOKEN");
    private Text appId;

    public ClientTokenIdentifier(ApplicationId id) {
        this.appId = new Text(Integer.toString(id.getId()));
    }

    public ClientTokenIdentifier() {
        this.appId = new Text();
    }

    public Text getApplicationID() {
        return this.appId;
    }

    public void write(DataOutput out) throws IOException {
        this.appId.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.appId.readFields(in);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        if (this.appId == null || "".equals(this.appId.toString())) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)this.appId.toString());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

