/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.client.ClientTokenIdentifier;

public class ClientTokenSelector
implements TokenSelector<ClientTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(ClientTokenSelector.class);

    public Token<ClientTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug((Object)("Looking for a token with service " + service.toString()));
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug((Object)("Token kind is " + token.getKind().toString() + " and the token's service name is " + token.getService()));
            if (!ClientTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
            return token;
        }
        return null;
    }
}

