/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.YarnVersionAnnotation;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YarnVersionInfo {
    private static final Log LOG = LogFactory.getLog(YarnVersionInfo.class);
    private static Package myPackage = YarnVersionAnnotation.class.getPackage();
    private static YarnVersionAnnotation version = myPackage.getAnnotation(YarnVersionAnnotation.class);

    static Package getPackage() {
        return myPackage;
    }

    public static String getVersion() {
        return version != null ? version.version() : "Unknown";
    }

    public static String getRevision() {
        return version != null ? version.revision() : "Unknown";
    }

    public static String getBranch() {
        return version != null ? version.branch() : "Unknown";
    }

    public static String getDate() {
        return version != null ? version.date() : "Unknown";
    }

    public static String getUser() {
        return version != null ? version.user() : "Unknown";
    }

    public static String getUrl() {
        return version != null ? version.url() : "Unknown";
    }

    public static String getSrcChecksum() {
        return version != null ? version.srcChecksum() : "Unknown";
    }

    public static String getBuildVersion() {
        return YarnVersionInfo.getVersion() + " from " + YarnVersionInfo.getRevision() + " by " + YarnVersionInfo.getUser() + " source checksum " + YarnVersionInfo.getSrcChecksum();
    }

    public static void main(String[] args) {
        LOG.debug((Object)("version: " + version));
        System.out.println("Yarn " + YarnVersionInfo.getVersion());
        System.out.println("Subversion " + YarnVersionInfo.getUrl() + " -r " + YarnVersionInfo.getRevision());
        System.out.println("Compiled by " + YarnVersionInfo.getUser() + " on " + YarnVersionInfo.getDate());
        System.out.println("From source with checksum " + YarnVersionInfo.getSrcChecksum());
    }
}

