/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientRMProxy<T>
extends RMProxy<T> {
    private static final Log LOG = LogFactory.getLog(ClientRMProxy.class);
    private static final ClientRMProxy INSTANCE = new ClientRMProxy();

    private ClientRMProxy() {
    }

    public static <T> T createRMProxy(Configuration configuration, Class<T> protocol) throws IOException {
        return (T)ClientRMProxy.createRMProxy((Configuration)configuration, protocol, (RMProxy)INSTANCE);
    }

    private static void setupTokens(InetSocketAddress resourceManagerAddress) throws IOException {
        for (Token token : UserGroupInformation.getCurrentUser().getTokens()) {
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)resourceManagerAddress);
        }
    }

    @InterfaceAudience.Private
    protected InetSocketAddress getRMAddress(YarnConfiguration conf, Class<?> protocol) throws IOException {
        if (protocol == ApplicationClientProtocol.class) {
            return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        }
        if (protocol == ResourceManagerAdministrationProtocol.class) {
            return conf.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
        }
        if (protocol == ApplicationMasterProtocol.class) {
            InetSocketAddress serviceAddr = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
            ClientRMProxy.setupTokens((InetSocketAddress)serviceAddr);
            return serviceAddr;
        }
        String message = "Unsupported protocol found when creating the proxy connection to ResourceManager: " + (protocol != null ? protocol.getClass().getName() : "null");
        LOG.error((Object)message);
        throw new IllegalStateException(message);
    }

    @InterfaceAudience.Private
    protected void checkAllowedProtocols(Class<?> protocol) {
        Preconditions.checkArgument((boolean)protocol.isAssignableFrom(ClientRMProtocols.class), (Object)"RM does not support this client protocol");
    }
}

