/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfiguredRMFailoverProxyProvider<T>
implements RMFailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(ConfiguredRMFailoverProxyProvider.class);
    private int currentProxyIndex = 0;
    Map<String, T> proxies = new HashMap();
    private RMProxy<T> rmProxy;
    private Class<T> protocol;
    protected YarnConfiguration conf;
    protected String[] rmServiceIds;

    public void init(Configuration configuration, RMProxy<T> rmProxy, Class<T> protocol) {
        this.rmProxy = rmProxy;
        this.protocol = protocol;
        this.rmProxy.checkAllowedProtocols(this.protocol);
        this.conf = new YarnConfiguration(configuration);
        Collection rmIds = HAUtil.getRMHAIds((Configuration)this.conf);
        this.rmServiceIds = rmIds.toArray(new String[rmIds.size()]);
        this.conf.set("yarn.resourcemanager.ha.id", this.rmServiceIds[this.currentProxyIndex]);
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt("yarn.client.failover-retries", 0));
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.conf.getInt("yarn.client.failover-retries-on-socket-timeouts", 0));
    }

    private T getProxyInternal() {
        try {
            InetSocketAddress rmAddress = this.rmProxy.getRMAddress(this.conf, this.protocol);
            return (T)RMProxy.getProxy((Configuration)this.conf, (Class)this.protocol, (InetSocketAddress)rmAddress);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Unable to create proxy to the ResourceManager " + this.rmServiceIds[this.currentProxyIndex]), (Throwable)ioe);
            return null;
        }
    }

    public synchronized T getProxy() {
        String rmId = this.rmServiceIds[this.currentProxyIndex];
        Object current = this.proxies.get(rmId);
        if (current == null) {
            current = this.getProxyInternal();
            this.proxies.put(rmId, current);
        }
        return (T)current;
    }

    public synchronized void performFailover(T currentProxy) {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.rmServiceIds.length;
        this.conf.set("yarn.resourcemanager.ha.id", this.rmServiceIds[this.currentProxyIndex]);
        LOG.info((Object)("Failing over to " + this.rmServiceIds[this.currentProxyIndex]));
    }

    public Class<T> getInterface() {
        return this.protocol;
    }

    public synchronized void close() throws IOException {
        for (Object proxy : this.proxies.values()) {
            if (proxy instanceof Closeable) {
                ((Closeable)proxy).close();
                continue;
            }
            RPC.stopProxy(proxy);
        }
    }
}

