/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AsyncDispatcher
extends AbstractService
implements Dispatcher {
    private static final Log LOG = LogFactory.getLog(AsyncDispatcher.class);
    private final BlockingQueue<Event> eventQueue;
    private volatile boolean stopped = false;
    private volatile boolean drainEventsOnStop = false;
    private volatile boolean drained = true;
    private Object waitForDrained = new Object();
    private volatile boolean blockNewEvents = false;
    private EventHandler handlerInstance = null;
    private Thread eventHandlingThread;
    protected final Map<Class<? extends Enum>, EventHandler> eventDispatchers;
    private boolean exitOnDispatchException;

    public AsyncDispatcher() {
        this(new LinkedBlockingQueue());
    }

    public AsyncDispatcher(BlockingQueue<Event> eventQueue) {
        super("Dispatcher");
        this.eventQueue = eventQueue;
        this.eventDispatchers = new HashMap();
    }

    Runnable createThread() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.exitOnDispatchException = conf.getBoolean("yarn.dispatcher.exit-on-error", false);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.eventHandlingThread = new Thread(this.createThread());
        this.eventHandlingThread.setName("AsyncDispatcher event handler");
        this.eventHandlingThread.start();
    }

    public void setDrainEventsOnStop() {
        this.drainEventsOnStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStop() throws Exception {
        if (this.drainEventsOnStop) {
            this.blockNewEvents = true;
            LOG.info((Object)"AsyncDispatcher is draining to stop, igonring any new events.");
            Object object = this.waitForDrained;
            synchronized (object) {
                while (!this.drained && this.eventHandlingThread.isAlive()) {
                    this.waitForDrained.wait(1000L);
                    LOG.info((Object)"Waiting for AsyncDispatcher to drain.");
                }
            }
        }
        this.stopped = true;
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
            try {
                this.eventHandlingThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Interrupted Exception while stopping", (Throwable)ie);
            }
        }
        super.serviceStop();
    }

    protected void dispatch(Event event) {
        block4: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Dispatching the event " + event.getClass().getName() + "." + event.toString()));
            }
            Class type = event.getType().getDeclaringClass();
            try {
                EventHandler handler = (EventHandler)this.eventDispatchers.get(type);
                if (handler == null) {
                    throw new Exception("No handler for registered for " + type);
                }
                handler.handle(event);
            }
            catch (Throwable t) {
                LOG.fatal((Object)"Error in dispatcher thread", t);
                if (!this.exitOnDispatchException || ShutdownHookManager.get().isShutdownInProgress()) break block4;
                LOG.info((Object)"Exiting, bbye..");
                System.exit(-1);
            }
        }
    }

    public void register(Class<? extends Enum> eventType, EventHandler handler) {
        EventHandler registeredHandler = (EventHandler)this.eventDispatchers.get(eventType);
        LOG.info((Object)("Registering " + eventType + " for " + handler.getClass()));
        if (registeredHandler == null) {
            this.eventDispatchers.put(eventType, handler);
        } else if (!(registeredHandler instanceof MultiListenerHandler)) {
            MultiListenerHandler multiHandler = new MultiListenerHandler();
            multiHandler.addHandler(registeredHandler);
            multiHandler.addHandler(handler);
            this.eventDispatchers.put(eventType, multiHandler);
        } else {
            MultiListenerHandler multiHandler = (MultiListenerHandler)registeredHandler;
            multiHandler.addHandler(handler);
        }
    }

    public EventHandler getEventHandler() {
        if (this.handlerInstance == null) {
            this.handlerInstance = new GenericEventHandler(this);
        }
        return this.handlerInstance;
    }

    static /* synthetic */ boolean access$000(AsyncDispatcher x0) {
        return x0.stopped;
    }

    static /* synthetic */ boolean access$102(AsyncDispatcher x0, boolean x1) {
        x0.drained = x1;
        return x0.drained;
    }

    static /* synthetic */ BlockingQueue access$200(AsyncDispatcher x0) {
        return x0.eventQueue;
    }

    static /* synthetic */ boolean access$300(AsyncDispatcher x0) {
        return x0.blockNewEvents;
    }

    static /* synthetic */ Object access$400(AsyncDispatcher x0) {
        return x0.waitForDrained;
    }

    static /* synthetic */ boolean access$100(AsyncDispatcher x0) {
        return x0.drained;
    }

    static /* synthetic */ Log access$500() {
        return LOG;
    }
}

