/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.factory.providers.RpcFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class HadoopYarnProtoRPC
extends YarnRPC {
    private static final Log LOG = LogFactory.getLog(HadoopYarnProtoRPC.class);

    public Object getProxy(Class protocol, InetSocketAddress addr, Configuration conf) {
        LOG.debug((Object)("Creating a HadoopYarnProtoRpc proxy for protocol " + protocol));
        return RpcFactoryProvider.getClientFactory((Configuration)conf).getClient(protocol, 1L, addr, conf);
    }

    public void stopProxy(Object proxy, Configuration conf) {
        RpcFactoryProvider.getClientFactory((Configuration)conf).stopClient(proxy);
    }

    public Server getServer(Class protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, String portRangeConfig) {
        LOG.debug((Object)("Creating a HadoopYarnProtoRpc server for protocol " + protocol + " with " + numHandlers + " handlers"));
        return RpcFactoryProvider.getServerFactory((Configuration)conf).getServer(protocol, instance, addr, conf, secretManager, numHandlers, portRangeConfig);
    }
}

