/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.TestContainerId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAggregatedLogFormat {
    private static final File testWorkDir = new File("target", "TestAggregatedLogFormat");
    private static final Configuration conf = new Configuration();
    private static final FileSystem fs;
    private static final char filler = 'x';
    private static final Log LOG;

    @Before
    @After
    public void cleanupTestDir() throws Exception {
        Path workDirPath = new Path(testWorkDir.getAbsolutePath());
        LOG.info((Object)("Cleaning test directory [" + workDirPath + "]"));
        fs.delete(workDirPath, true);
    }

    @Test
    public void testReadAcontainerLogs1() throws Exception {
        Configuration conf = new Configuration();
        File workDir = new File(testWorkDir, "testReadAcontainerLogs1");
        Path remoteAppLogFile = new Path(workDir.getAbsolutePath(), "aggregatedLogFile");
        Path srcFileRoot = new Path(workDir.getAbsolutePath(), "srcFiles");
        ContainerId testContainerId = TestContainerId.newContainerId((int)1, (int)1, (long)1L, (int)1);
        Path t = new Path(srcFileRoot, testContainerId.getApplicationAttemptId().getApplicationId().toString());
        Path srcFilePath = new Path(t, testContainerId.toString());
        int numChars = 80000;
        this.writeSrcFile(srcFilePath, "stdout", (long)numChars);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        AggregatedLogFormat.LogWriter logWriter = new AggregatedLogFormat.LogWriter(conf, remoteAppLogFile, ugi);
        AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(testContainerId);
        AggregatedLogFormat.LogValue logValue = new AggregatedLogFormat.LogValue(Collections.singletonList(srcFileRoot.toString()), testContainerId, ugi.getShortUserName());
        logWriter.append(logKey, logValue);
        logWriter.close();
        FileStatus fsStatus = fs.getFileStatus(remoteAppLogFile);
        Assert.assertEquals((String)"permissions on log aggregation file are wrong", (Object)FsPermission.createImmutable((short)416), (Object)fsStatus.getPermission());
        AggregatedLogFormat.LogReader logReader = new AggregatedLogFormat.LogReader(conf, remoteAppLogFile);
        AggregatedLogFormat.LogKey rLogKey = new AggregatedLogFormat.LogKey();
        DataInputStream dis = logReader.next(rLogKey);
        StringWriter writer = new StringWriter();
        AggregatedLogFormat.LogReader.readAcontainerLogs((DataInputStream)dis, (Writer)writer);
        String s = ((Object)writer).toString();
        int expectedLength = "\n\nLogType:stdout".length() + ("\nLogLength:" + numChars).length() + "\nLog Contents:\n".length() + numChars;
        Assert.assertTrue((String)"LogType not matched", (boolean)s.contains("LogType:stdout"));
        Assert.assertTrue((String)"LogLength not matched", (boolean)s.contains("LogLength:" + numChars));
        Assert.assertTrue((String)"Log Contents not matched", (boolean)s.contains("Log Contents"));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numChars; ++i) {
            sb.append('x');
        }
        String expectedContent = sb.toString();
        Assert.assertTrue((String)"Log content incorrect", (boolean)s.contains(expectedContent));
        Assert.assertEquals((int)expectedLength, (int)s.length());
    }

    @Test(timeout=10000L)
    public void testContainerLogsFileAccess() throws IOException {
        String line;
        Assume.assumeTrue((boolean)NativeIO.isAvailable());
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File workDir = new File(testWorkDir, "testContainerLogsFileAccess1");
        Path remoteAppLogFile = new Path(workDir.getAbsolutePath(), "aggregatedLogFile");
        Path srcFileRoot = new Path(workDir.getAbsolutePath(), "srcFiles");
        String data = "Log File content for container : ";
        ApplicationId applicationId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ContainerId testContainerId1 = ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)1);
        Path appDir = new Path(srcFileRoot, testContainerId1.getApplicationAttemptId().getApplicationId().toString());
        Path srcFilePath1 = new Path(appDir, testContainerId1.toString());
        String stdout = "stdout";
        String stderr = "stderr";
        this.writeSrcFile(srcFilePath1, stdout, data + testContainerId1.toString() + stdout);
        this.writeSrcFile(srcFilePath1, stderr, data + testContainerId1.toString() + stderr);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        AggregatedLogFormat.LogWriter logWriter = new AggregatedLogFormat.LogWriter(conf, remoteAppLogFile, ugi);
        AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(testContainerId1);
        String randomUser = "randomUser";
        AggregatedLogFormat.LogValue logValue = (AggregatedLogFormat.LogValue)Mockito.spy((Object)new AggregatedLogFormat.LogValue(Collections.singletonList(srcFileRoot.toString()), testContainerId1, randomUser));
        Mockito.when((Object)logValue.getUser()).thenReturn((Object)randomUser).thenReturn((Object)ugi.getShortUserName());
        logWriter.append(logKey, logValue);
        logWriter.close();
        BufferedReader in = new BufferedReader(new FileReader(new File(remoteAppLogFile.toUri().getRawPath())));
        StringBuffer sb = new StringBuffer("");
        while ((line = in.readLine()) != null) {
            LOG.info((Object)line);
            sb.append(line);
        }
        line = sb.toString();
        String expectedOwner = ugi.getShortUserName();
        if (Path.WINDOWS) {
            String adminsGroupString = "Administrators";
            if (Arrays.asList(ugi.getGroupNames()).contains("Administrators")) {
                expectedOwner = "Administrators";
            }
        }
        String stdoutFile1 = StringUtils.join((CharSequence)File.separator, Arrays.asList(workDir.getAbsolutePath(), "srcFiles", testContainerId1.getApplicationAttemptId().getApplicationId().toString(), testContainerId1.toString(), stderr));
        String message1 = "Owner '" + expectedOwner + "' for path " + stdoutFile1 + " did not match expected owner '" + randomUser + "'";
        String stdoutFile2 = StringUtils.join((CharSequence)File.separator, Arrays.asList(workDir.getAbsolutePath(), "srcFiles", testContainerId1.getApplicationAttemptId().getApplicationId().toString(), testContainerId1.toString(), stdout));
        String message2 = "Owner '" + expectedOwner + "' for path " + stdoutFile2 + " did not match expected owner '" + ugi.getShortUserName() + "'";
        Assert.assertTrue((boolean)line.contains(message1));
        Assert.assertFalse((boolean)line.contains(message2));
        Assert.assertFalse((boolean)line.contains(data + testContainerId1.toString() + stderr));
        Assert.assertTrue((boolean)line.contains(data + testContainerId1.toString() + stdout));
    }

    private void writeSrcFile(Path srcFilePath, String fileName, long length) throws IOException {
        OutputStreamWriter osw = this.getOutputStreamWriter(srcFilePath, fileName);
        int ch = 120;
        int i = 0;
        while ((long)i < length) {
            osw.write(ch);
            ++i;
        }
        osw.close();
    }

    private void writeSrcFile(Path srcFilePath, String fileName, String data) throws IOException {
        OutputStreamWriter osw = this.getOutputStreamWriter(srcFilePath, fileName);
        osw.write(data);
        osw.close();
    }

    private OutputStreamWriter getOutputStreamWriter(Path srcFilePath, String fileName) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        File dir = new File(srcFilePath.toString());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create directory : " + dir);
        }
        File outputFile = new File(new File(srcFilePath.toString()), fileName);
        FileOutputStream os = new FileOutputStream(outputFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF8");
        return osw;
    }

    static {
        LOG = LogFactory.getLog(TestAggregatedLogFormat.class);
        try {
            fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

