/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.state;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.state.Graph;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class StateMachineFactory<OPERAND, STATE extends Enum<STATE>, EVENTTYPE extends Enum<EVENTTYPE>, EVENT> {
    private final TransitionsListNode transitionsListNode;
    private Map<STATE, Map<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>>> stateMachineTable;
    private STATE defaultInitialState;
    private final boolean optimized;

    public StateMachineFactory(STATE defaultInitialState) {
        this.transitionsListNode = null;
        this.defaultInitialState = defaultInitialState;
        this.optimized = false;
        this.stateMachineTable = null;
    }

    private StateMachineFactory(StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> that, ApplicableTransition<OPERAND, STATE, EVENTTYPE, EVENT> t) {
        this.defaultInitialState = that.defaultInitialState;
        this.transitionsListNode = new TransitionsListNode(this, t, that.transitionsListNode);
        this.optimized = false;
        this.stateMachineTable = null;
    }

    private StateMachineFactory(StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> that, boolean optimized) {
        this.defaultInitialState = that.defaultInitialState;
        this.transitionsListNode = that.transitionsListNode;
        this.optimized = optimized;
        if (optimized) {
            this.makeStateMachineTable();
        } else {
            this.stateMachineTable = null;
        }
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, EVENTTYPE eventType) {
        return this.addTransition(preState, postState, eventType, null);
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, Set<EVENTTYPE> eventTypes) {
        return this.addTransition(preState, postState, eventTypes, null);
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, Set<EVENTTYPE> eventTypes, SingleArcTransition<OPERAND, EVENT> hook) {
        StateMachineFactory factory = null;
        for (Enum event : eventTypes) {
            if (factory == null) {
                factory = this.addTransition(preState, postState, event, hook);
                continue;
            }
            factory = factory.addTransition(preState, postState, event, hook);
        }
        return factory;
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, EVENTTYPE eventType, SingleArcTransition<OPERAND, EVENT> hook) {
        return new StateMachineFactory(this, (ApplicableTransition)new ApplicableSingleOrMultipleTransition(preState, eventType, (Transition)new SingleInternalArc(this, postState, hook)));
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, Set<STATE> postStates, EVENTTYPE eventType, MultipleArcTransition<OPERAND, EVENT, STATE> hook) {
        return new StateMachineFactory(this, (ApplicableTransition)new ApplicableSingleOrMultipleTransition(preState, eventType, (Transition)new MultipleInternalArc(this, postStates, hook)));
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> installTopology() {
        return new StateMachineFactory(this, true);
    }

    private STATE doTransition(OPERAND operand, STATE oldState, EVENTTYPE eventType, EVENT event) throws InvalidStateTransitonException {
        Transition transition;
        Map transitionMap = (Map)this.stateMachineTable.get(oldState);
        if (transitionMap != null && (transition = (Transition)transitionMap.get(eventType)) != null) {
            return (STATE)transition.doTransition(operand, oldState, event, eventType);
        }
        throw new InvalidStateTransitonException(oldState, eventType);
    }

    private synchronized void maybeMakeStateMachineTable() {
        if (this.stateMachineTable == null) {
            this.makeStateMachineTable();
        }
    }

    private void makeStateMachineTable() {
        Stack<ApplicableTransition> stack = new Stack<ApplicableTransition>();
        HashMap<Enum, Object> prototype = new HashMap<Enum, Object>();
        prototype.put(this.defaultInitialState, null);
        this.stateMachineTable = new EnumMap(prototype);
        TransitionsListNode cursor = this.transitionsListNode;
        while (cursor != null) {
            stack.push(cursor.transition);
            cursor = cursor.next;
        }
        while (!stack.isEmpty()) {
            ((ApplicableTransition)stack.pop()).apply(this);
        }
    }

    public StateMachine<STATE, EVENTTYPE, EVENT> make(OPERAND operand, STATE initialState) {
        return new InternalStateMachine(this, operand, initialState);
    }

    public StateMachine<STATE, EVENTTYPE, EVENT> make(OPERAND operand) {
        return new InternalStateMachine(this, operand, this.defaultInitialState);
    }

    public Graph generateStateGraph(String name) {
        this.maybeMakeStateMachineTable();
        Graph g = new Graph(name);
        for (Enum startState : this.stateMachineTable.keySet()) {
            Map transitions = (Map)this.stateMachineTable.get(startState);
            for (Map.Entry entry : transitions.entrySet()) {
                Transition transition = (Transition)entry.getValue();
                if (transition instanceof SingleInternalArc) {
                    SingleInternalArc sa = (SingleInternalArc)transition;
                    Graph.Node fromNode = g.getNode(startState.toString());
                    Graph.Node toNode = g.getNode(SingleInternalArc.access$400((SingleInternalArc)sa).toString());
                    fromNode.addEdge(toNode, ((Enum)entry.getKey()).toString());
                    continue;
                }
                if (!(transition instanceof MultipleInternalArc)) continue;
                MultipleInternalArc ma = (MultipleInternalArc)transition;
                Iterator iter = MultipleInternalArc.access$500((MultipleInternalArc)ma).iterator();
                while (iter.hasNext()) {
                    Graph.Node fromNode = g.getNode(startState.toString());
                    Graph.Node toNode = g.getNode(iter.next().toString());
                    fromNode.addEdge(toNode, ((Enum)entry.getKey()).toString());
                }
            }
        }
        return g;
    }

    static /* synthetic */ Map access$000(StateMachineFactory x0) {
        return x0.stateMachineTable;
    }

    static /* synthetic */ boolean access$100(StateMachineFactory x0) {
        return x0.optimized;
    }

    static /* synthetic */ void access$200(StateMachineFactory x0) {
        x0.maybeMakeStateMachineTable();
    }

    static /* synthetic */ Enum access$300(StateMachineFactory x0, Object x1, Enum x2, Enum x3, Object x4) throws InvalidStateTransitonException {
        return x0.doTransition(x1, x2, x3, x4);
    }
}

