/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.TestCompositeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCompositeService {
    private static final int NUM_OF_SERVICES = 5;
    private static final int FAILED_SERVICE_SEQ_NUMBER = 2;
    private static final Log LOG = LogFactory.getLog(TestCompositeService.class);
    private static final boolean STOP_ONLY_STARTED_SERVICES = CompositeServiceImpl.isPolicyToStopOnlyStartedServices();

    @Before
    public void setup() {
        CompositeServiceImpl.resetCounter();
    }

    @Test
    public void testCallSequence() {
        int i;
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i2 = 0; i2 < 5; ++i2) {
            CompositeServiceImpl service = new CompositeServiceImpl(i2);
            serviceManager.addTestService((CompositeService)service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Assert.assertEquals((String)"Number of registered services ", (long)5L, (long)services.length);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        this.assertInState(Service.STATE.INITED, services);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, init() call sequence number should have been "), (long)i, (long)services[i].getCallSequenceNumber());
        }
        this.resetServices(services);
        serviceManager.start();
        this.assertInState(Service.STATE.STARTED, services);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, start() call sequence number should have been "), (long)i, (long)services[i].getCallSequenceNumber());
        }
        this.resetServices(services);
        serviceManager.stop();
        this.assertInState(Service.STATE.STOPPED, services);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, stop() call sequence number should have been "), (long)(4 - i), (long)services[i].getCallSequenceNumber());
        }
        serviceManager.stop();
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, stop() call sequence number should have been "), (long)(4 - i), (long)services[i].getCallSequenceNumber());
        }
    }

    private void resetServices(CompositeServiceImpl[] services) {
        for (int i = 0; i < 5; ++i) {
            services[i].reset();
        }
    }

    @Test
    public void testServiceStartup() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            if (i == 2) {
                service.setThrowExceptionOnStart(true);
            }
            serviceManager.addTestService((CompositeService)service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        try {
            serviceManager.start();
            Assert.fail((String)"Exception should have been thrown due to startup failure of last service");
        }
        catch (YarnRuntimeException e) {
            for (int i = 0; i < 4; ++i) {
                if (i >= 2 && STOP_ONLY_STARTED_SERVICES) {
                    Assert.assertEquals((String)"Service state should have been ", (Object)Service.STATE.INITED, (Object)services[4].getServiceState());
                    continue;
                }
                Assert.assertEquals((String)"Service state should have been ", (Object)Service.STATE.STOPPED, (Object)services[i].getServiceState());
            }
        }
    }

    @Test
    public void testServiceStop() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            if (i == 2) {
                service.setThrowExceptionOnStop(true);
            }
            serviceManager.addTestService((CompositeService)service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        serviceManager.start();
        try {
            serviceManager.stop();
        }
        catch (YarnRuntimeException e) {
            // empty catch block
        }
        this.assertInState(Service.STATE.STOPPED, services);
    }

    private void assertInState(Service.STATE expected, CompositeServiceImpl[] services) {
        this.assertInState(expected, services, 0, services.length);
    }

    private void assertInState(Service.STATE expected, CompositeServiceImpl[] services, int start, int finish) {
        for (int i = start; i < finish; ++i) {
            CompositeServiceImpl service = services[i];
            this.assertInState(expected, (Service)service);
        }
    }

    private void assertInState(Service.STATE expected, Service service) {
        Assert.assertEquals((String)("Service state should have been " + expected + " in " + service), (Object)expected, (Object)service.getServiceState());
    }

    @Test
    public void testServiceStopFromNotInited() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            serviceManager.addTestService((CompositeService)service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        serviceManager.stop();
        this.assertInState(Service.STATE.NOTINITED, services);
    }

    @Test
    public void testServiceStopFromInited() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            serviceManager.addTestService((CompositeService)service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        serviceManager.init(new Configuration());
        serviceManager.stop();
        if (STOP_ONLY_STARTED_SERVICES) {
            this.assertInState(Service.STATE.INITED, services);
        } else {
            this.assertInState(Service.STATE.STOPPED, services);
        }
    }

    @Test
    public void testInitNullConf() throws Throwable {
        ServiceManager serviceManager = new ServiceManager("testInitNullConf");
        CompositeServiceImpl service = new CompositeServiceImpl(0);
        serviceManager.addTestService((CompositeService)service);
        try {
            serviceManager.init(null);
            LOG.warn((Object)("Null Configurations are permitted " + serviceManager));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
    }

    @Test
    public void testServiceLifecycleNoChildren() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        serviceManager.init(new Configuration());
        serviceManager.start();
        serviceManager.stop();
    }

    @Test
    public void testAddServiceInInit() throws Throwable {
        BreakableService child = new BreakableService();
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
        CompositeServiceAddingAChild composite = new CompositeServiceAddingAChild((Service)child);
        composite.init(new Configuration());
        this.assertInState(Service.STATE.INITED, (Service)child);
    }

    @Test(timeout=1000L)
    public void testAddIfService() {
        1 testService = new /* Unavailable Anonymous Inner Class!! */;
        testService.init(new Configuration());
        Assert.assertEquals((String)"Incorrect number of services", (long)1L, (long)testService.getServices().size());
    }

    @Test
    public void testRemoveService() {
        2 testService = new /* Unavailable Anonymous Inner Class!! */;
        testService.init(new Configuration());
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)testService.getServices().size());
    }
}

