/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerResourceIncrease;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerResourceIncreasePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.Test;

public class TestContainerResourceIncrease {
    @Test
    public void testResourceIncreaseContext() {
        byte[] identifier = new byte[]{1, 2, 3, 4};
        Token token = Token.newInstance((byte[])identifier, (String)"", (byte[])"".getBytes(), (String)"");
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1234L, (int)3), (int)3), (int)7);
        Resource resource = Resource.newInstance((int)1023, (int)3);
        ContainerResourceIncrease ctx = ContainerResourceIncrease.newInstance((ContainerId)containerId, (Resource)resource, (Token)token);
        YarnProtos.ContainerResourceIncreaseProto proto = ((ContainerResourceIncreasePBImpl)ctx).getProto();
        ctx = new ContainerResourceIncreasePBImpl(proto);
        Assert.assertEquals((Object)ctx.getCapability(), (Object)resource);
        Assert.assertEquals((Object)ctx.getContainerId(), (Object)containerId);
        Assert.assertTrue((boolean)Arrays.equals(ctx.getContainerToken().getIdentifier().array(), identifier));
    }

    @Test
    public void testResourceIncreaseContextWithNull() {
        ContainerResourceIncrease ctx = ContainerResourceIncrease.newInstance(null, null, null);
        YarnProtos.ContainerResourceIncreaseProto proto = ((ContainerResourceIncreasePBImpl)ctx).getProto();
        ctx = new ContainerResourceIncreasePBImpl(proto);
        Assert.assertNull((Object)ctx.getContainerToken());
        Assert.assertNull((Object)ctx.getCapability());
        Assert.assertNull((Object)ctx.getContainerId());
    }
}

