/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RegisterApplicationMasterResponsePBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NMTokenPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RegisterApplicationMasterResponsePBImpl
extends RegisterApplicationMasterResponse {
    YarnServiceProtos.RegisterApplicationMasterResponseProto proto = YarnServiceProtos.RegisterApplicationMasterResponseProto.getDefaultInstance();
    YarnServiceProtos.RegisterApplicationMasterResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Resource maximumResourceCapability;
    private Map<ApplicationAccessType, String> applicationACLS = null;
    private List<Container> containersFromPreviousAttempts = null;
    private List<NMToken> nmTokens = null;

    public RegisterApplicationMasterResponsePBImpl() {
        this.builder = YarnServiceProtos.RegisterApplicationMasterResponseProto.newBuilder();
    }

    public RegisterApplicationMasterResponsePBImpl(YarnServiceProtos.RegisterApplicationMasterResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.RegisterApplicationMasterResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((RegisterApplicationMasterResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.maximumResourceCapability != null) {
            this.builder.setMaximumCapability(this.convertToProtoFormat(this.maximumResourceCapability));
        }
        if (this.applicationACLS != null) {
            this.addApplicationACLs();
        }
        if (this.containersFromPreviousAttempts != null) {
            this.addContainersFromPreviousAttemptToProto();
        }
        if (this.nmTokens != null) {
            this.builder.clearNmTokensFromPreviousAttempts();
            Iterable iterable = this.getTokenProtoIterable(this.nmTokens);
            this.builder.addAllNmTokensFromPreviousAttempts(iterable);
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.RegisterApplicationMasterResponseProto.newBuilder((YarnServiceProtos.RegisterApplicationMasterResponseProto)this.proto);
        }
        this.viaProto = false;
    }

    public Resource getMaximumResourceCapability() {
        YarnServiceProtos.RegisterApplicationMasterResponseProto p;
        if (this.maximumResourceCapability != null) {
            return this.maximumResourceCapability;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasMaximumCapability()) {
            return null;
        }
        this.maximumResourceCapability = this.convertFromProtoFormat(p.getMaximumCapability());
        return this.maximumResourceCapability;
    }

    public void setMaximumResourceCapability(Resource capability) {
        this.maybeInitBuilder();
        if (this.maximumResourceCapability == null) {
            this.builder.clearMaximumCapability();
        }
        this.maximumResourceCapability = capability;
    }

    public Map<ApplicationAccessType, String> getApplicationACLs() {
        this.initApplicationACLs();
        return this.applicationACLS;
    }

    private void initApplicationACLs() {
        if (this.applicationACLS != null) {
            return;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getApplicationACLsList();
        this.applicationACLS = new HashMap(list.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : list) {
            this.applicationACLS.put(ProtoUtils.convertFromProtoFormat((YarnProtos.ApplicationAccessTypeProto)aclProto.getAccessType()), aclProto.getAcl());
        }
    }

    private void addApplicationACLs() {
        this.maybeInitBuilder();
        this.builder.clearApplicationACLs();
        if (this.applicationACLS == null) {
            return;
        }
        1 values = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllApplicationACLs((Iterable)values);
    }

    public void setApplicationACLs(Map<ApplicationAccessType, String> appACLs) {
        if (appACLs == null) {
            return;
        }
        this.initApplicationACLs();
        this.applicationACLS.clear();
        this.applicationACLS.putAll(appACLs);
    }

    public void setClientToAMTokenMasterKey(ByteBuffer key) {
        if (key == null) {
            this.builder.clearClientToAmTokenMasterKey();
            return;
        }
        this.maybeInitBuilder();
        this.builder.setClientToAmTokenMasterKey(ByteString.copyFrom((ByteBuffer)key));
    }

    public ByteBuffer getClientToAMTokenMasterKey() {
        this.maybeInitBuilder();
        ByteBuffer key = ByteBuffer.wrap(this.builder.getClientToAmTokenMasterKey().toByteArray());
        return key;
    }

    public List<Container> getContainersFromPreviousAttempts() {
        if (this.containersFromPreviousAttempts != null) {
            return this.containersFromPreviousAttempts;
        }
        this.initContainersPreviousAttemptList();
        return this.containersFromPreviousAttempts;
    }

    public void setContainersFromPreviousAttempts(List<Container> containers) {
        if (containers == null) {
            return;
        }
        this.containersFromPreviousAttempts = new ArrayList();
        this.containersFromPreviousAttempts.addAll(containers);
    }

    public String getQueue() {
        YarnServiceProtos.RegisterApplicationMasterResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasQueue()) {
            return null;
        }
        return p.getQueue();
    }

    public void setQueue(String queue) {
        this.maybeInitBuilder();
        if (queue == null) {
            this.builder.clearQueue();
        } else {
            this.builder.setQueue(queue);
        }
    }

    private void initContainersPreviousAttemptList() {
        YarnServiceProtos.RegisterApplicationMasterResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getContainersFromPreviousAttemptsList();
        this.containersFromPreviousAttempts = new ArrayList();
        for (YarnProtos.ContainerProto c : list) {
            this.containersFromPreviousAttempts.add(this.convertFromProtoFormat(c));
        }
    }

    private void addContainersFromPreviousAttemptToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersFromPreviousAttempts();
        ArrayList<YarnProtos.ContainerProto> list = new ArrayList<YarnProtos.ContainerProto>();
        for (Container c : this.containersFromPreviousAttempts) {
            list.add(this.convertToProtoFormat(c));
        }
        this.builder.addAllContainersFromPreviousAttempts(list);
    }

    public List<NMToken> getNMTokensFromPreviousAttempts() {
        if (this.nmTokens != null) {
            return this.nmTokens;
        }
        this.initLocalNewNMTokenList();
        return this.nmTokens;
    }

    public void setNMTokensFromPreviousAttempts(List<NMToken> nmTokens) {
        if (nmTokens == null || nmTokens.isEmpty()) {
            if (this.nmTokens != null) {
                this.nmTokens.clear();
            }
            this.builder.clearNmTokensFromPreviousAttempts();
            return;
        }
        this.nmTokens = new ArrayList();
        this.nmTokens.addAll(nmTokens);
    }

    private synchronized void initLocalNewNMTokenList() {
        YarnServiceProtos.RegisterApplicationMasterResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getNmTokensFromPreviousAttemptsList();
        this.nmTokens = new ArrayList();
        for (YarnServiceProtos.NMTokenProto t : list) {
            this.nmTokens.add(this.convertFromProtoFormat(t));
        }
    }

    private synchronized Iterable<YarnServiceProtos.NMTokenProto> getTokenProtoIterable(List<NMToken> nmTokenList) {
        this.maybeInitBuilder();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Resource convertFromProtoFormat(YarnProtos.ResourceProto resource) {
        return new ResourcePBImpl(resource);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource resource) {
        return ((ResourcePBImpl)resource).getProto();
    }

    private ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto p) {
        return new ContainerPBImpl(p);
    }

    private YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    private YarnServiceProtos.NMTokenProto convertToProtoFormat(NMToken token) {
        return ((NMTokenPBImpl)token).getProto();
    }

    private NMToken convertFromProtoFormat(YarnServiceProtos.NMTokenProto proto) {
        return new NMTokenPBImpl(proto);
    }

    static /* synthetic */ Map access$000(RegisterApplicationMasterResponsePBImpl x0) {
        return x0.applicationACLS;
    }

    static /* synthetic */ YarnServiceProtos.NMTokenProto access$100(RegisterApplicationMasterResponsePBImpl x0, NMToken x1) {
        return x0.convertToProtoFormat(x1);
    }
}

