/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerLaunchContextPBImpl
extends ContainerLaunchContext {
    YarnProtos.ContainerLaunchContextProto proto = YarnProtos.ContainerLaunchContextProto.getDefaultInstance();
    YarnProtos.ContainerLaunchContextProto.Builder builder = null;
    boolean viaProto = false;
    private Map<String, LocalResource> localResources = null;
    private ByteBuffer tokens = null;
    private Map<String, ByteBuffer> serviceData = null;
    private Map<String, String> environment = null;
    private List<String> commands = null;
    private Map<ApplicationAccessType, String> applicationACLS = null;

    public ContainerLaunchContextPBImpl() {
        this.builder = YarnProtos.ContainerLaunchContextProto.newBuilder();
    }

    public ContainerLaunchContextPBImpl(YarnProtos.ContainerLaunchContextProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ContainerLaunchContextProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((ContainerLaunchContextPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    protected final ByteBuffer convertFromProtoFormat(ByteString byteString) {
        return ProtoUtils.convertFromProtoFormat((ByteString)byteString);
    }

    protected final ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        return ProtoUtils.convertToProtoFormat((ByteBuffer)byteBuffer);
    }

    private void mergeLocalToBuilder() {
        if (this.localResources != null) {
            this.addLocalResourcesToProto();
        }
        if (this.tokens != null) {
            this.builder.setTokens(this.convertToProtoFormat(this.tokens));
        }
        if (this.serviceData != null) {
            this.addServiceDataToProto();
        }
        if (this.environment != null) {
            this.addEnvToProto();
        }
        if (this.commands != null) {
            this.addCommandsToProto();
        }
        if (this.applicationACLS != null) {
            this.addApplicationACLs();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerLaunchContextProto.newBuilder((YarnProtos.ContainerLaunchContextProto)this.proto);
        }
        this.viaProto = false;
    }

    public List<String> getCommands() {
        this.initCommands();
        return this.commands;
    }

    private void initCommands() {
        if (this.commands != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getCommandList();
        this.commands = new ArrayList();
        for (String c : list) {
            this.commands.add(c);
        }
    }

    public void setCommands(List<String> commands) {
        if (commands == null) {
            return;
        }
        this.initCommands();
        this.commands.clear();
        this.commands.addAll(commands);
    }

    private void addCommandsToProto() {
        this.maybeInitBuilder();
        this.builder.clearCommand();
        if (this.commands == null) {
            return;
        }
        this.builder.addAllCommand((Iterable)this.commands);
    }

    public Map<String, LocalResource> getLocalResources() {
        this.initLocalResources();
        return this.localResources;
    }

    private void initLocalResources() {
        if (this.localResources != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getLocalResourcesList();
        this.localResources = new HashMap();
        for (YarnProtos.StringLocalResourceMapProto c : list) {
            this.localResources.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    public void setLocalResources(Map<String, LocalResource> localResources) {
        if (localResources == null) {
            return;
        }
        this.initLocalResources();
        this.localResources.clear();
        this.localResources.putAll(localResources);
    }

    private void addLocalResourcesToProto() {
        this.maybeInitBuilder();
        this.builder.clearLocalResources();
        if (this.localResources == null) {
            return;
        }
        1 iterable = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllLocalResources((Iterable)iterable);
    }

    public ByteBuffer getTokens() {
        YarnProtos.ContainerLaunchContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.tokens != null) {
            return this.tokens;
        }
        if (!p.hasTokens()) {
            return null;
        }
        this.tokens = this.convertFromProtoFormat(p.getTokens());
        return this.tokens;
    }

    public void setTokens(ByteBuffer tokens) {
        this.maybeInitBuilder();
        if (tokens == null) {
            this.builder.clearTokens();
        }
        this.tokens = tokens;
    }

    public Map<String, ByteBuffer> getServiceData() {
        this.initServiceData();
        return this.serviceData;
    }

    private void initServiceData() {
        if (this.serviceData != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getServiceDataList();
        this.serviceData = new HashMap();
        for (YarnProtos.StringBytesMapProto c : list) {
            this.serviceData.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    public void setServiceData(Map<String, ByteBuffer> serviceData) {
        if (serviceData == null) {
            return;
        }
        this.initServiceData();
        this.serviceData.putAll(serviceData);
    }

    private void addServiceDataToProto() {
        this.maybeInitBuilder();
        this.builder.clearServiceData();
        if (this.serviceData == null) {
            return;
        }
        2 iterable = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllServiceData((Iterable)iterable);
    }

    public Map<String, String> getEnvironment() {
        this.initEnv();
        return this.environment;
    }

    private void initEnv() {
        if (this.environment != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getEnvironmentList();
        this.environment = new HashMap();
        for (YarnProtos.StringStringMapProto c : list) {
            this.environment.put(c.getKey(), c.getValue());
        }
    }

    public void setEnvironment(Map<String, String> env) {
        if (env == null) {
            return;
        }
        this.initEnv();
        this.environment.clear();
        this.environment.putAll(env);
    }

    private void addEnvToProto() {
        this.maybeInitBuilder();
        this.builder.clearEnvironment();
        if (this.environment == null) {
            return;
        }
        3 iterable = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllEnvironment((Iterable)iterable);
    }

    public Map<ApplicationAccessType, String> getApplicationACLs() {
        this.initApplicationACLs();
        return this.applicationACLS;
    }

    private void initApplicationACLs() {
        if (this.applicationACLS != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getApplicationACLsList();
        this.applicationACLS = new HashMap(list.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : list) {
            this.applicationACLS.put(ProtoUtils.convertFromProtoFormat((YarnProtos.ApplicationAccessTypeProto)aclProto.getAccessType()), aclProto.getAcl());
        }
    }

    private void addApplicationACLs() {
        this.maybeInitBuilder();
        this.builder.clearApplicationACLs();
        if (this.applicationACLS == null) {
            return;
        }
        4 values = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllApplicationACLs((Iterable)values);
    }

    public void setApplicationACLs(Map<ApplicationAccessType, String> appACLs) {
        if (appACLs == null) {
            return;
        }
        this.initApplicationACLs();
        this.applicationACLS.clear();
        this.applicationACLS.putAll(appACLs);
    }

    private LocalResourcePBImpl convertFromProtoFormat(YarnProtos.LocalResourceProto p) {
        return new LocalResourcePBImpl(p);
    }

    private YarnProtos.LocalResourceProto convertToProtoFormat(LocalResource t) {
        return ((LocalResourcePBImpl)t).getProto();
    }

    static /* synthetic */ Map access$000(ContainerLaunchContextPBImpl x0) {
        return x0.localResources;
    }

    static /* synthetic */ YarnProtos.LocalResourceProto access$100(ContainerLaunchContextPBImpl x0, LocalResource x1) {
        return x0.convertToProtoFormat(x1);
    }

    static /* synthetic */ Map access$200(ContainerLaunchContextPBImpl x0) {
        return x0.serviceData;
    }

    static /* synthetic */ Map access$300(ContainerLaunchContextPBImpl x0) {
        return x0.environment;
    }

    static /* synthetic */ Map access$400(ContainerLaunchContextPBImpl x0) {
        return x0.applicationACLS;
    }
}

