/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceBlacklistRequestPBImpl
extends ResourceBlacklistRequest {
    YarnProtos.ResourceBlacklistRequestProto proto = null;
    YarnProtos.ResourceBlacklistRequestProto.Builder builder = null;
    boolean viaProto = false;
    List<String> blacklistAdditions = null;
    List<String> blacklistRemovals = null;

    public ResourceBlacklistRequestPBImpl() {
        this.builder = YarnProtos.ResourceBlacklistRequestProto.newBuilder();
    }

    public ResourceBlacklistRequestPBImpl(YarnProtos.ResourceBlacklistRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceBlacklistRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceBlacklistRequestProto.newBuilder((YarnProtos.ResourceBlacklistRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.blacklistAdditions != null) {
            this.addBlacklistAdditionsToProto();
        }
        if (this.blacklistRemovals != null) {
            this.addBlacklistRemovalsToProto();
        }
    }

    private void addBlacklistAdditionsToProto() {
        this.maybeInitBuilder();
        this.builder.clearBlacklistAdditions();
        if (this.blacklistAdditions == null) {
            return;
        }
        this.builder.addAllBlacklistAdditions((Iterable)this.blacklistAdditions);
    }

    private void addBlacklistRemovalsToProto() {
        this.maybeInitBuilder();
        this.builder.clearBlacklistAdditions();
        if (this.blacklistRemovals == null) {
            return;
        }
        this.builder.addAllBlacklistRemovals((Iterable)this.blacklistRemovals);
    }

    private void initBlacklistAdditions() {
        if (this.blacklistAdditions != null) {
            return;
        }
        YarnProtos.ResourceBlacklistRequestProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getBlacklistAdditionsList();
        this.blacklistAdditions = new ArrayList();
        this.blacklistAdditions.addAll(list);
    }

    private void initBlacklistRemovals() {
        if (this.blacklistRemovals != null) {
            return;
        }
        YarnProtos.ResourceBlacklistRequestProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getBlacklistRemovalsList();
        this.blacklistRemovals = new ArrayList();
        this.blacklistRemovals.addAll(list);
    }

    public List<String> getBlacklistAdditions() {
        this.initBlacklistAdditions();
        return this.blacklistAdditions;
    }

    public void setBlacklistAdditions(List<String> resourceNames) {
        if (resourceNames == null || resourceNames.isEmpty()) {
            if (this.blacklistAdditions != null) {
                this.blacklistAdditions.clear();
            }
            return;
        }
        this.initBlacklistAdditions();
        this.blacklistAdditions.clear();
        this.blacklistAdditions.addAll(resourceNames);
    }

    public List<String> getBlacklistRemovals() {
        this.initBlacklistRemovals();
        return this.blacklistRemovals;
    }

    public void setBlacklistRemovals(List<String> resourceNames) {
        if (resourceNames == null || resourceNames.isEmpty()) {
            if (this.blacklistRemovals != null) {
                this.blacklistRemovals.clear();
            }
            return;
        }
        this.initBlacklistRemovals();
        this.blacklistRemovals.clear();
        this.blacklistRemovals.addAll(resourceNames);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }
}

