/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factory.providers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RpcClientFactory;
import org.apache.hadoop.yarn.factories.RpcServerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class RpcFactoryProvider {
    private RpcFactoryProvider() {
    }

    public static RpcServerFactory getServerFactory(Configuration conf) {
        if (conf == null) {
            conf = new Configuration();
        }
        String serverFactoryClassName = conf.get("yarn.ipc.server.factory.class", "org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl");
        return (RpcServerFactory)RpcFactoryProvider.getFactoryClassInstance((String)serverFactoryClassName);
    }

    public static RpcClientFactory getClientFactory(Configuration conf) {
        String clientFactoryClassName = conf.get("yarn.ipc.client.factory.class", "org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl");
        return (RpcClientFactory)RpcFactoryProvider.getFactoryClassInstance((String)clientFactoryClassName);
    }

    private static Object getFactoryClassInstance(String factoryClassName) {
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            Method method = clazz.getMethod("get", null);
            method.setAccessible(true);
            return method.invoke(null, null);
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }
}

