/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.state;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.state.Graph;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class Graph {
    private String name;
    private Graph parent;
    private Set<Node> nodes = new HashSet();
    private Set<Graph> subgraphs = new HashSet();

    public Graph(String name, Graph parent) {
        this.name = name;
        this.parent = parent;
    }

    public Graph(String name) {
        this(name, null);
    }

    public Graph() {
        this("graph", null);
    }

    public String getName() {
        return this.name;
    }

    public Graph getParent() {
        return this.parent;
    }

    private Node newNode(String id) {
        Node ret = new Node(this, id);
        this.nodes.add(ret);
        return ret;
    }

    public Node getNode(String id) {
        for (Node node : this.nodes) {
            if (!node.id.equals(id)) continue;
            return node;
        }
        return this.newNode(id);
    }

    public Graph newSubGraph(String name) {
        Graph ret = new Graph(name, this);
        this.subgraphs.add(ret);
        return ret;
    }

    public void addSubGraph(Graph graph) {
        this.subgraphs.add(graph);
        graph.parent = this;
    }

    private static String wrapSafeString(String label) {
        if (label.indexOf(44) >= 0 && label.length() > 14) {
            label = label.replaceAll(",", ",\n");
        }
        label = "\"" + StringEscapeUtils.escapeJava((String)label) + "\"";
        return label;
    }

    public String generateGraphViz(String indent) {
        StringBuilder sb = new StringBuilder();
        if (this.parent == null) {
            sb.append("digraph " + this.name + " {\n");
            sb.append(String.format("graph [ label=%s, fontsize=24, fontname=Helvetica];\n", Graph.wrapSafeString((String)this.name)));
            sb.append("node [fontsize=12, fontname=Helvetica];\n");
            sb.append("edge [fontsize=9, fontcolor=blue, fontname=Arial];\n");
        } else {
            sb.append("subgraph cluster_" + this.name + " {\nlabel=\"" + this.name + "\"\n");
        }
        for (Graph g : this.subgraphs) {
            String ginfo = g.generateGraphViz(indent + "  ");
            sb.append(ginfo);
            sb.append("\n");
        }
        for (Node n : this.nodes) {
            sb.append(String.format("%s%s [ label = %s ];\n", indent, Graph.wrapSafeString((String)n.getUniqueId()), n.id));
            List combinedOuts = Graph.combineEdges((List)n.outs);
            for (Edge e : combinedOuts) {
                sb.append(String.format("%s%s -> %s [ label = %s ];\n", indent, Graph.wrapSafeString((String)e.from.getUniqueId()), Graph.wrapSafeString((String)e.to.getUniqueId()), Graph.wrapSafeString((String)e.label)));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String generateGraphViz() {
        return this.generateGraphViz("");
    }

    public void save(String filepath) throws IOException {
        FileWriter fout = new FileWriter(filepath);
        fout.write(this.generateGraphViz());
        fout.close();
    }

    public static List<Edge> combineEdges(List<Edge> edges) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Edge edge : edges) {
            boolean found = false;
            for (int i = 0; i < ret.size(); ++i) {
                Edge current = (Edge)ret.get(i);
                if (!edge.sameAs(current)) continue;
                ret.set(i, current.combine(edge));
                found = true;
                break;
            }
            if (found) continue;
            ret.add(edge);
        }
        return ret;
    }

    static /* synthetic */ String access$000(Graph x0) {
        return x0.name;
    }
}

