/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.junit.Assert;

public class NodeLabelTestBase {
    public static void assertMapEquals(Map<NodeId, Set<String>> m1, ImmutableMap<NodeId, Set<String>> m2) {
        Assert.assertEquals((long)m1.size(), (long)m2.size());
        for (NodeId k : m1.keySet()) {
            Assert.assertTrue((boolean)m2.containsKey((Object)k));
            NodeLabelTestBase.assertCollectionEquals((Collection<String>)m1.get(k), (Collection)m2.get((Object)k));
        }
    }

    public static void assertMapContains(Map<NodeId, Set<String>> m1, ImmutableMap<NodeId, Set<String>> m2) {
        for (NodeId k : m2.keySet()) {
            Assert.assertTrue((boolean)m1.containsKey(k));
            NodeLabelTestBase.assertCollectionEquals((Collection<String>)m1.get(k), (Collection)m2.get((Object)k));
        }
    }

    public static void assertCollectionEquals(Collection<String> c1, Collection<String> c2) {
        HashSet<String> s1 = new HashSet<String>(c1);
        HashSet<String> s2 = new HashSet<String>(c2);
        Assert.assertEquals(s1, s2);
        Assert.assertTrue((boolean)s1.containsAll(s2));
    }

    public static <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    public NodeId toNodeId(String str) {
        if (str.contains(":")) {
            int idx = str.indexOf(58);
            NodeId id = NodeId.newInstance((String)str.substring(0, idx), (int)Integer.valueOf(str.substring(idx + 1)));
            return id;
        }
        return NodeId.newInstance((String)str, (int)0);
    }
}

