/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFileSystemNodeLabelsStore
extends NodeLabelTestBase {
    MockNodeLabelManager mgr = null;
    Configuration conf = null;

    private FileSystemNodeLabelsStore getStore() {
        return (FileSystemNodeLabelsStore)this.mgr.store;
    }

    @Before
    public void before() throws IOException {
        this.mgr = new MockNodeLabelManager();
        this.conf = new Configuration();
        File tempDir = File.createTempFile("nlb", ".tmp");
        tempDir.delete();
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        this.conf.set("yarn.node-labels.fs-store.root-dir", tempDir.getAbsolutePath());
        this.mgr.init(this.conf);
        this.mgr.start();
    }

    @After
    public void after() throws IOException {
        this.getStore().fs.delete(this.getStore().fsWorkingPath, true);
        this.mgr.stop();
    }

    @Test(timeout=10000L)
    public void testRecoverWithMirror() throws Exception {
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1", "p2", "p3"));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p4"));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p5", "p6"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestFileSystemNodeLabelsStore.toSet("p1"), (Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestFileSystemNodeLabelsStore.toSet("p3"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n5"), TestFileSystemNodeLabelsStore.toSet("p5"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.removeFromClusterNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1"));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.stop();
    }

    @Test(timeout=10000L)
    public void testEditlogRecover() throws Exception {
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1", "p2", "p3"));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p4"));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p5", "p6"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestFileSystemNodeLabelsStore.toSet("p1"), (Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestFileSystemNodeLabelsStore.toSet("p3"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n5"), TestFileSystemNodeLabelsStore.toSet("p5"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.removeFromClusterNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1"));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.stop();
    }

    @Test
    public void testSerilizationAfterRecovery() throws Exception {
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1", "p2", "p3"));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p4"));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p5", "p6"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestFileSystemNodeLabelsStore.toSet("p1"), (Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestFileSystemNodeLabelsStore.toSet("p3"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n5"), TestFileSystemNodeLabelsStore.toSet("p5"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.removeFromClusterNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1"));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p7", "p8"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet("p9"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assert.assertEquals((long)6L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6", "p7", "p8", "p9")));
        this.mgr.stop();
    }

    @Test
    public void testRootMkdirOnInitStore() throws Exception {
        final FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemNodeLabelsStore mockStore = new FileSystemNodeLabelsStore(this.mgr){

            void setFileSystem(Configuration conf) throws IOException {
                this.fs = mockFs;
            }
        };
        mockStore.fs = mockFs;
        this.verifyMkdirsCount(mockStore, true, 0);
        this.verifyMkdirsCount(mockStore, false, 1);
        this.verifyMkdirsCount(mockStore, true, 1);
        this.verifyMkdirsCount(mockStore, false, 2);
    }

    private void verifyMkdirsCount(FileSystemNodeLabelsStore store, boolean existsRetVal, int expectedNumOfCalls) throws Exception {
        Mockito.when((Object)store.fs.exists((Path)Mockito.any(Path.class))).thenReturn((Object)existsRetVal);
        store.init(this.conf);
        ((FileSystem)Mockito.verify((Object)store.fs, (VerificationMode)Mockito.times((int)expectedNumOfCalls))).mkdirs((Path)Mockito.any(Path.class));
    }

    private static class MockNodeLabelManager
    extends CommonNodeLabelsManager {
        private MockNodeLabelManager() {
        }

        protected void initDispatcher(Configuration conf) {
            this.dispatcher = new InlineDispatcher();
        }

        protected void startDispatcher() {
        }

        protected void stopDispatcher() {
        }
    }
}

